/*
 * Decompiled with CFR 0.152.
 */
package com.ic.icsmartviewconfig;

import com.ic.icsmartviewconfig.BHttpRequestMessage;
import com.ic.icsmartviewconfig.BIRequestObserver;
import com.ic.icsmartviewconfig.BIRequestSubject;
import com.ic.icsmartviewconfig.BIStatusObserver;
import com.ic.icsmartviewconfig.BIStatusSubject;
import com.ic.icsmartviewconfig.BStatusEnum;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;

final class BHttpsThread
implements BIRequestSubject,
BIStatusSubject,
Runnable {
    public static final String THIS_CLASS_NAME = "BHttpsThread";
    private static final String DEFAULT_API = "/autostart";
    private static final String DEFAULT_METHOD = "GET";
    private static final int DEFAULT_TIMEOUT = 1000;
    private static final int HTTPS_PORT = 5580;
    private static final String PROTOCOL = "https";
    private static final long THREAD_TIMEOUT = 10000L;
    public static final Logger log = Logger.getLogger("iC_SmartView_Config");
    private URL url;
    private String ipAddress;
    private String userName;
    private int minTimeBetweenFrames;
    private String base64EncodedCredentials;
    private List<BHttpRequestMessage> requestsQueue = new ArrayList<BHttpRequestMessage>();
    private HttpsURLConnection conn;
    private BIStatusObserver statusObserver = null;
    private Thread thread;

    private BHttpsThread(String ipAddress, String userName, String password, int minTimeBetweenFrames, BIStatusObserver statusObserver) {
        this.setCredentials(userName, password);
        this.setIpAddress(ipAddress);
        this.setMinTimeBetweenFrames(minTimeBetweenFrames);
        this.subscribeStatusObserver(statusObserver);
    }

    public static BHttpsThreadBuilder builder() {
        return new BHttpsThreadBuilder();
    }

    @Override
    public void addRequest(BHttpRequestMessage message) {
        this.requestsQueue.add(message);
        this.start();
        log.finest("BHttpsThread: New message added to the queue, size is " + Integer.toString(this.requestsQueue.size()) + (this.requestsQueue.size() > 0 ? " now - " + this.requestsQueue.get(0).toString() : ""));
    }

    @Override
    public void addRequest(BIRequestObserver requestObserver) {
        this.addRequest(DEFAULT_API, null, DEFAULT_METHOD, requestObserver);
    }

    @Override
    public void addRequest(String api, String body, String httpMethod, BIRequestObserver requestObserver) {
        log.finest("BHttpsThread: Inputs of new message added to the queue - httpMethod == " + httpMethod + ", api == " + api + ", body == " + (body == null ? "null" : body) + ", requestObserver " + (requestObserver == null ? "== null" : "!= null"));
        BHttpRequestMessage message = BHttpRequestMessage.builder().api(api).body(body).httpMethod(httpMethod).requestObserver(requestObserver).build();
        this.addRequest(message);
    }

    private BHttpRequestMessage getRequestMessage() {
        return this.requestsQueue.isEmpty() ? null : this.requestsQueue.get(0);
    }

    private void notifyRequestResult(String result) {
        log.finest("BHttpsThread: Notify result: " + result);
        this.requestsQueue.get(0).getRequestObserver().notifyResult(result);
        this.requestsQueue.remove(0);
    }

    private void notifyStatusObserver(BStatusEnum statusType, boolean subscribe) {
        if (this.statusObserver != null) {
            if (subscribe) {
                this.statusObserver.subscribeStatus(statusType);
            } else {
                this.statusObserver.unsubscribeStatus(statusType);
            }
        }
    }

    @Override
    public void subscribeStatusObserver(BIStatusObserver statusObserver) {
        this.statusObserver = statusObserver;
    }

    @Override
    public void unsubscribeStatusObserver(BIStatusObserver statusObserver) {
        this.statusObserver = null;
    }

    private void communicationInterruped(BHttpRequestMessage message, Exception e, BStatusEnum statusSubscription, String prefixMessage) {
        log.severe((prefixMessage == null ? e.getClass().getSimpleName() + " occured during " + THIS_CLASS_NAME + " executing: " : prefixMessage) + e.getMessage());
        this.notifyStatusObserver(statusSubscription, true);
        message.getRequestObserver().notifyResult("No respond!");
        this.requestsQueue.remove(message);
    }

    @Override
    public void run() {
        boolean nextMessage = false;
        log.finest("BHttpsThread invoked run() method");
        while (this.requestsQueue.size() > 0) {
            String exMessage;
            BHttpRequestMessage message = this.getRequestMessage();
            if (message == null) continue;
            log.finest("BHttpsThread: new message found in the queue!");
            if (nextMessage) {
                log.fine("BHttpsThread: sleep thread for " + Integer.toString(this.minTimeBetweenFrames) + " seconds!");
                try {
                    Thread.sleep(this.minTimeBetweenFrames);
                }
                catch (InterruptedException e) {
                    this.communicationInterruped(message, e, BStatusEnum.InterruptedException, null);
                }
            } else {
                nextMessage = true;
            }
            this.notifyStatusObserver(BStatusEnum.ApiAccessException, false);
            this.notifyStatusObserver(BStatusEnum.ConnectException, false);
            this.notifyStatusObserver(BStatusEnum.CredentialsException, false);
            this.notifyStatusObserver(BStatusEnum.Exception, false);
            this.notifyStatusObserver(BStatusEnum.FileNotFoundException, false);
            this.notifyStatusObserver(BStatusEnum.IOException, false);
            this.notifyStatusObserver(BStatusEnum.SSLExceptionCertificate, false);
            this.notifyStatusObserver(BStatusEnum.SSLExceptionUnsupportedMessage, false);
            this.notifyStatusObserver(BStatusEnum.UnknownHostException, false);
            try {
                this.sendRequest(message);
            }
            catch (UnknownHostException e) {
                this.communicationInterruped(message, e, BStatusEnum.UnknownHostException, null);
            }
            catch (ConnectException e) {
                this.communicationInterruped(message, e, BStatusEnum.ConnectException, null);
            }
            catch (SSLException e) {
                exMessage = e.getMessage();
                if (exMessage.contains("failed certificate validation, failed hostname validation")) {
                    this.communicationInterruped(message, e, BStatusEnum.SSLExceptionCertificate, null);
                    continue;
                }
                if (exMessage.contains("Unsupported or unrecognized SSL message")) {
                    this.communicationInterruped(message, e, BStatusEnum.SSLExceptionUnsupportedMessage, null);
                    continue;
                }
                this.communicationInterruped(message, e, BStatusEnum.Exception, null);
            }
            catch (FileNotFoundException e) {
                this.communicationInterruped(message, e, BStatusEnum.FileNotFoundException, null);
            }
            catch (SocketException | SocketTimeoutException e) {
                this.communicationInterruped(message, e, BStatusEnum.ConnectException, null);
            }
            catch (IOException e) {
                exMessage = e.getMessage();
                if (exMessage.contains("Server returned HTTP response code: 401 for URL")) {
                    this.communicationInterruped(message, e, BStatusEnum.CredentialsException, null);
                    continue;
                }
                if (exMessage.contains("Server returned HTTP response code: 403 for URL")) {
                    this.communicationInterruped(message, e, BStatusEnum.ApiAccessException, null);
                    continue;
                }
                if (exMessage.contains("certificate_unknown")) {
                    this.communicationInterruped(message, e, BStatusEnum.SSLExceptionCertificate, null);
                    continue;
                }
                this.communicationInterruped(message, e, BStatusEnum.IOException, null);
            }
            catch (Exception e) {
                this.communicationInterruped(message, e, BStatusEnum.Exception, null);
            }
        }
        log.finest("BHttpsThread run() method finished!");
    }

    private void makeUrl(String api) {
        this.notifyStatusObserver(BStatusEnum.MalformedURLException, false);
        try {
            this.url = new URL("https://" + this.ipAddress + ":" + Integer.toString(5580) + api);
        }
        catch (MalformedURLException e) {
            this.notifyStatusObserver(BStatusEnum.MalformedURLException, true);
            log.severe("BIcSmartViewRecipient: URL created using IP Address is malformed: " + e.getMessage());
        }
    }

    public void sendRequest(BHttpRequestMessage message) throws SocketException, IOException {
        String result = "";
        String inputBuffer = "";
        String body = message.getBody();
        String method = message.getHttpMethod();
        log.finest("BHttpsThread sendRequest() method was invoked");
        this.makeUrl(message.getApi());
        log.fine("Remote host URL: " + this.url.toString());
        this.conn = (HttpsURLConnection)this.url.openConnection();
        this.conn.setConnectTimeout(1000);
        this.conn.setRequestMethod(method);
        this.conn.setRequestProperty("Host", this.url.getHost());
        this.conn.setRequestProperty("Authorization", this.base64EncodedCredentials);
        this.conn.setDoOutput(true);
        if (method.equals(new String("POST")) && body != "" && body != null) {
            log.fine("POST body incluing: " + body);
            this.conn.setRequestProperty("Content-Type", "application/json");
            this.conn.setUseCaches(false);
            this.notifyStatusObserver(BStatusEnum.Exception, false);
            this.notifyStatusObserver(BStatusEnum.IOException, false);
            try (DataOutputStream wr = new DataOutputStream(this.conn.getOutputStream());){
                wr.write(body.getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                this.communicationInterruped(message, e, BStatusEnum.IOException, "Body POST data write stream failed. ");
            }
            catch (Exception e) {
                this.communicationInterruped(message, e, BStatusEnum.Exception, "Body POST data write stream failed. ");
                throw e;
            }
        }
        this.conn.connect();
        log.fine("Connection to remote host in the HttpsURLConnection invoked.");
        BufferedReader input = new BufferedReader(new InputStreamReader(this.conn.getInputStream()));
        log.fine("BufferedReader in HttpsURLConnection created.");
        while ((inputBuffer = input.readLine()) != null) {
            result = result + inputBuffer + "\n";
        }
        log.fine("Input buffer read: " + result);
        this.conn.disconnect();
        log.fine("Connection closed in HttpsURLConnection.");
        this.notifyRequestResult(result);
    }

    public final void setCredentials(String userName, String password) {
        String authorizationText = userName + ":" + password;
        byte[] authBytes = authorizationText.getBytes(StandardCharsets.UTF_8);
        this.userName = userName;
        this.base64EncodedCredentials = "Basic " + Base64.getEncoder().encodeToString(authBytes);
    }

    public final void setIpAddress(String value) {
        this.ipAddress = value;
    }

    public final void setMinTimeBetweenFrames(int value) {
        this.minTimeBetweenFrames = value;
    }

    private final void start() {
        if (this.thread != null && this.thread.getState() != Thread.State.TERMINATED) {
            try {
                this.thread.join(10000L);
            }
            catch (InterruptedException e) {
                log.fine(e.getClass().getSimpleName() + " occured during " + THIS_CLASS_NAME + " starting: " + e.getMessage());
                this.notifyStatusObserver(BStatusEnum.InterruptedException, true);
            }
        } else {
            log.finest(this.toString() + ": new thread instance starting!");
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public final void initThread() {
        log.finer(this.toString() + ": thread initing!");
        this.notifyStatusObserver(BStatusEnum.ApiAccessException, false);
        this.notifyStatusObserver(BStatusEnum.ConnectException, false);
        this.notifyStatusObserver(BStatusEnum.CredentialsException, false);
        this.notifyStatusObserver(BStatusEnum.Exception, false);
        this.notifyStatusObserver(BStatusEnum.FileNotFoundException, false);
        this.notifyStatusObserver(BStatusEnum.InterruptedException, false);
        this.notifyStatusObserver(BStatusEnum.IOException, false);
        this.notifyStatusObserver(BStatusEnum.SSLExceptionCertificate, false);
        this.notifyStatusObserver(BStatusEnum.SSLExceptionUnsupportedMessage, false);
        this.notifyStatusObserver(BStatusEnum.UnknownHostException, false);
    }

    public final void interrupThread() {
        log.finer(this.toString() + ": thread stopping!");
        this.notifyStatusObserver(BStatusEnum.SecurityException, false);
        if (this.thread != null) {
            try {
                this.thread.interrupt();
            }
            catch (SecurityException e) {
                log.fine(e.getClass().getSimpleName() + " occured during " + THIS_CLASS_NAME + " stopping: " + e.getMessage());
                this.notifyStatusObserver(BStatusEnum.SecurityException, true);
            }
        }
        if (this.conn != null) {
            this.conn.disconnect();
        }
    }

    public String toString() {
        return "BHttpsThread(ipAddress=" + this.ipAddress + ", userName=" + this.userName + ")";
    }

    public static class BHttpsThreadBuilder {
        private String ipAddress;
        private String password;
        private int minTimeBetweenFrames;
        private BIStatusObserver statusObserver;
        private String userName;

        BHttpsThreadBuilder ipAddress(String value) {
            this.ipAddress = value;
            return this;
        }

        BHttpsThreadBuilder minTimeBetweenFrames(int value) {
            this.minTimeBetweenFrames = value;
            return this;
        }

        BHttpsThreadBuilder password(String value) {
            this.password = value;
            return this;
        }

        BHttpsThreadBuilder statusObserver(BIStatusObserver value) {
            this.statusObserver = value;
            return this;
        }

        BHttpsThreadBuilder userName(String value) {
            this.userName = value;
            return this;
        }

        BHttpsThread build() {
            return new BHttpsThread(this.ipAddress, this.userName, this.password, this.minTimeBetweenFrames, this.statusObserver);
        }
    }
}

