/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverAC256.point;

import com.tridium.andoverAC256.messages.AndoverDataResponse;
import com.tridium.andoverAC256.point.BAndoverProxyExt;
import javax.baja.control.BNumericPoint;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BAndoverNumericProxyExt
extends BAndoverProxyExt {
    public static final Type TYPE = Sys.loadType(BAndoverNumericProxyExt.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    public BAndoverNumericProxyExt() {
        super("");
    }

    public BAndoverNumericProxyExt(String assignedName) {
        super(assignedName);
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BNumericPoint;
    }

    @Override
    public void setValue(AndoverDataResponse rsp) {
        float floatValue;
        BStatusNumeric sv = (BStatusNumeric)this.getReadValue().newCopy();
        boolean isOverflow = false;
        try {
            floatValue = rsp.getFloatValue();
            isOverflow = rsp.isOverFlow();
        }
        catch (Exception e1) {
            try {
                floatValue = rsp.getTriStateValue();
            }
            catch (Exception e2) {
                try {
                    floatValue = rsp.getBinaryValue() ? 1.0f : 0.0f;
                }
                catch (Exception e3) {
                    this.readFail("unable to convert response to numeric");
                    return;
                }
            }
        }
        sv.setValue((double)floatValue);
        sv.setStatusFault(isOverflow);
        sv.setStatusOverridden(!this.getNativeEnableState());
        this.readOk((BStatusValue)sv);
        this.setRawValue(rsp.getStringValue());
    }
}

