/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverAC256.messages;

import com.tridium.andoverAC256.messages.AndoverReceivedMessage;

public class AndoverGetFlagPointsResponse
extends AndoverReceivedMessage {
    public int numberPointsReturned;
    public PointList[] pointList;

    public AndoverGetFlagPointsResponse(String message) {
        super(message);
    }

    public int getNumberPointsReturned() {
        return this.numberPointsReturned;
    }

    public void decodeMessage(boolean getUserFlags, boolean getSystemFlags) {
        String resp = new String(this.message);
        int equalsPosition = resp.indexOf("=");
        if (equalsPosition == -1) {
            this.numberPointsReturned = 0;
            return;
        }
        int firstSystemFlagsIndex = 0;
        int systemHeaderIndex = resp.indexOf("System Defined Flags");
        if (systemHeaderIndex == -1) {
            systemHeaderIndex = resp.length();
            firstSystemFlagsIndex = resp.length();
        } else {
            firstSystemFlagsIndex = resp.indexOf("\n", systemHeaderIndex);
        }
        int numberofPoints = 0;
        while (equalsPosition != -1 && (getSystemFlags || equalsPosition <= firstSystemFlagsIndex)) {
            if (getUserFlags && equalsPosition < firstSystemFlagsIndex) {
                ++numberofPoints;
            }
            if (getSystemFlags && equalsPosition > firstSystemFlagsIndex) {
                ++numberofPoints;
            }
            equalsPosition = resp.indexOf("=", equalsPosition + 1);
        }
        this.numberPointsReturned = numberofPoints;
        this.pointList = new PointList[numberofPoints];
        equalsPosition = getUserFlags ? resp.indexOf("=") : resp.indexOf("=", firstSystemFlagsIndex);
        for (int i = 0; i < numberofPoints; ++i) {
            int startofPoint = equalsPosition - 9;
            int endofPoint = equalsPosition + 8;
            String pointString = resp.substring(startofPoint, endofPoint);
            this.pointList[i] = new PointList(pointString.substring(0, 9).trim(), pointString.substring(10, 17).trim());
            equalsPosition = resp.indexOf("=", endofPoint);
        }
    }

    public String toString() {
        return "AndoverGetFlagPointsResponse: " + this.message;
    }

    public String getName(int index) {
        if (this.pointList == null || index >= this.pointList.length) {
            return "";
        }
        return this.pointList[index].getName();
    }

    public String getValue(int index) {
        if (this.pointList == null || index >= this.pointList.length) {
            return "";
        }
        return this.pointList[index].getValue();
    }

    public class PointList {
        String name;
        String value;

        PointList(String name, String value) {
            this.name = name;
            this.value = value;
        }

        String getName() {
            return this.name;
        }

        String getValue() {
            return this.value;
        }
    }
}

