/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.qnx;

import com.tridium.fox.sys.BFoxService;
import com.tridium.platform.BPlatform;
import com.tridium.platform.qnx.BSystemPlatformServiceQnx;
import com.tridium.sys.station.Station;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.security.AccessController;
import java.util.Properties;
import java.util.logging.Level;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BSystemPlatformServiceQnxEdge10
extends BSystemPlatformServiceQnx {
    public static final Property minFreeHeap = BSystemPlatformServiceQnxEdge10.newProperty((int)1, (int)8, null);
    public static final Type TYPE = Sys.loadType(BSystemPlatformServiceQnxEdge10.class);
    private static final String FOX_EXPORT_FILENAME = "foxConfig.properties";
    private static final String FOX_PROPERTIES_PATH = Sys.getProtectedStationHome() + File.separator + "export" + File.separator + "foxConfig.properties";
    private static Properties lastSavedFoxProperties = null;
    private final QnxEdge10ServiceSaveListener saveListener = new QnxEdge10ServiceSaveListener();

    @Override
    public Type getType() {
        return TYPE;
    }

    public final void stationStarted() {
        Station.addSaveListener((Station.SaveListener)this.saveListener);
        lastSavedFoxProperties = new Properties();
        try {
            File propsFile = new File(FOX_PROPERTIES_PATH);
            if (propsFile.exists()) {
                lastSavedFoxProperties = BSystemPlatformServiceQnxEdge10.readPropertiesFile(propsFile);
            }
            BSystemPlatformServiceQnxEdge10.exportFoxProperties();
        }
        catch (Exception e) {
            BPlatform.log.log(Level.SEVERE, "Unexpected failure to save file at " + FOX_PROPERTIES_PATH);
        }
    }

    @Override
    public final void serviceStopped() throws Exception {
        super.serviceStopped();
        Station.removeSaveListener((Station.SaveListener)this.saveListener);
    }

    private static void exportFoxProperties() {
        BFoxService service = (BFoxService)Sys.getService((Type)BFoxService.TYPE);
        String foxPort = String.valueOf(service.getFoxPort().getPublicServerPort());
        String foxsPort = String.valueOf(service.getFoxsPort().getPublicServerPort());
        Properties props = new Properties();
        props.setProperty("foxPort", foxPort);
        props.setProperty("foxEnabled", String.valueOf(service.getFoxEnabled()));
        props.setProperty("foxsPort", foxsPort);
        props.setProperty("foxsEnabled", String.valueOf(service.getFoxsEnabled()));
        props.setProperty("foxsOnly", String.valueOf(service.getFoxsOnly()));
        if (!props.equals(lastSavedFoxProperties)) {
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                props.store(out, "Do not modify the contents of this file");
                out.flush();
                BSystemPlatformServiceQnxEdge10.powerSafeSave(out.toByteArray(), FOX_PROPERTIES_PATH);
                lastSavedFoxProperties = props;
            }
            catch (Exception e) {
                BPlatform.log.log(Level.SEVERE, "Failure to export data to file: " + FOX_PROPERTIES_PATH, e);
            }
        }
    }

    private static Properties readPropertiesFile(File propsFile) throws Exception {
        Properties props = new Properties();
        AccessController.doPrivileged(() -> {
            try (FileInputStream inStream = new FileInputStream(propsFile);){
                props.load(inStream);
            }
            return null;
        });
        return props;
    }

    private final class QnxEdge10ServiceSaveListener
    implements Station.SaveListener {
        private QnxEdge10ServiceSaveListener() {
        }

        public void stationSave() throws Exception {
            BSystemPlatformServiceQnxEdge10.exportFoxProperties();
        }

        public void stationSaveOk() throws Exception {
        }

        public void stationSaveFail(String cause) throws Exception {
        }

        public final String toString() {
            return "SystemPlatformServiceSaveListener " + BSystemPlatformServiceQnxEdge10.this.getNavOrd();
        }
    }
}

