/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.qnx;

import com.tridium.nre.platform.IPlatformProvider;
import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.nre.platform.PlatformUtil;
import com.tridium.platform.BFilesystemAttributes;
import com.tridium.platform.BPlatform;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.archive.FileArchive;
import com.tridium.platform.archive.NullFileArchive;
import com.tridium.platform.archive.ZipArchive;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.LocalSessionUtil;
import com.tridium.platform.daemon.message.StartAppMessage;
import com.tridium.platform.daemon.message.UpdateRebootLimitsMessage;
import com.tridium.platform.daemon.message.UpdateStationMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.platform.qnx.QnxDiagnosticsPage;
import com.tridium.platform.timezone.BDstSupportLevel;
import com.tridium.sys.resource.ResourceReport;
import com.tridium.sys.station.Station;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.baja.agent.AgentList;
import javax.baja.data.BIDataValue;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFileSpace;
import javax.baja.file.FilePath;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.Spy;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="serialNumber", type="String", defaultValue="", flags=3), @NiagaraProperty(name="hardwareRevision", type="String", defaultValue="", flags=3), @NiagaraProperty(name="ramDiskSize", type="int", defaultValue="-1", flags=3), @NiagaraProperty(name="minFreeRamDiskPercentage", type="int", defaultValue="5", facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"percent\"), BFacets.MIN, BInteger.make(0), BFacets.MAX, BInteger.make(100))")}), @NiagaraProperty(name="lowRamDiskSpace", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="minFreeHeap", type="int", defaultValue="8", flags=1), @NiagaraProperty(name="lowHeap", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="freeHeap", type="int", defaultValue="0", flags=3), @NiagaraProperty(name="maxHeap", type="int", defaultValue="0", flags=3), @NiagaraProperty(name="minFreeDiskPercentage", type="int", defaultValue="10", facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"percent\"), BFacets.MIN, BInteger.make(0), BFacets.MAX, BInteger.make(100))")}), @NiagaraProperty(name="lowDiskSpace", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="minFreeFileDescriptors", type="int", defaultValue="50", facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(50))")}), @NiagaraProperty(name="openFileDescriptors", type="int", defaultValue="0", flags=3), @NiagaraProperty(name="maxOpenFileDescriptors", type="int", defaultValue="1000", flags=3), @NiagaraProperty(name="tooManyOpenFiles", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="lowAvailableFiles", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="minAvailableFiles", type="int", defaultValue="50", flags=3, facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(50))")}), @NiagaraProperty(name="minFreePhysicalMemory", type="int", defaultValue="1024", facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(512))")}), @NiagaraProperty(name="lowMemory", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="lowMetaSpace", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="failureRebootLimit", type="int", defaultValue="3", flags=3, facets={@Facet(value="BFacets.make(new String[] { BFacets.MIN }, new BIDataValue[] { BInteger.make(1) })")}), @NiagaraProperty(name="failureRebootLimitPeriod", type="BRelTime", defaultValue="BRelTime.makeMinutes(10)", flags=3, facets={@Facet(value="BFacets.make(new String[] { BFacets.UNITS, BFacets.MIN, BFacets.SHOW_SECONDS }, new BIDataValue[] { BUnit.getUnit(\"minute\"), BRelTime.make(0), BBoolean.FALSE })")})})
public class BSystemPlatformServiceQnx
extends BSystemPlatformService {
    public static final Property stationAutoSaveFrequency = BSystemPlatformServiceQnx.newProperty((int)1, (BValue)BRelTime.DAY, (BFacets)BSystemPlatformService.stationAutoSaveFrequency.getFacets());
    public static final Property stationSaveBackupCount = BSystemPlatformServiceQnx.newProperty((int)1, (int)0, null);
    public static final Property serialNumber = BSystemPlatformServiceQnx.newProperty((int)3, (String)"", null);
    public static final Property hardwareRevision = BSystemPlatformServiceQnx.newProperty((int)3, (String)"", null);
    public static final Property ramDiskSize = BSystemPlatformServiceQnx.newProperty((int)3, (int)-1, null);
    public static final Property minFreeRamDiskPercentage = BSystemPlatformServiceQnx.newProperty((int)0, (int)5, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"percent"), (String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)100)));
    public static final Property lowRamDiskSpace = BSystemPlatformServiceQnx.newProperty((int)3, (boolean)false, null);
    public static final Property minFreeHeap = BSystemPlatformServiceQnx.newProperty((int)1, (int)8, null);
    public static final Property lowHeap = BSystemPlatformServiceQnx.newProperty((int)3, (boolean)false, null);
    public static final Property freeHeap = BSystemPlatformServiceQnx.newProperty((int)3, (int)0, null);
    public static final Property maxHeap = BSystemPlatformServiceQnx.newProperty((int)3, (int)0, null);
    public static final Property minFreeDiskPercentage = BSystemPlatformServiceQnx.newProperty((int)0, (int)10, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"percent"), (String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)100)));
    public static final Property lowDiskSpace = BSystemPlatformServiceQnx.newProperty((int)3, (boolean)false, null);
    public static final Property minFreeFileDescriptors = BSystemPlatformServiceQnx.newProperty((int)0, (int)50, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)50)));
    public static final Property openFileDescriptors = BSystemPlatformServiceQnx.newProperty((int)3, (int)0, null);
    public static final Property maxOpenFileDescriptors = BSystemPlatformServiceQnx.newProperty((int)3, (int)1000, null);
    public static final Property tooManyOpenFiles = BSystemPlatformServiceQnx.newProperty((int)3, (boolean)false, null);
    public static final Property lowAvailableFiles = BSystemPlatformServiceQnx.newProperty((int)3, (boolean)false, null);
    public static final Property minAvailableFiles = BSystemPlatformServiceQnx.newProperty((int)3, (int)50, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)50)));
    public static final Property minFreePhysicalMemory = BSystemPlatformServiceQnx.newProperty((int)0, (int)1024, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)512)));
    public static final Property lowMemory = BSystemPlatformServiceQnx.newProperty((int)3, (boolean)false, null);
    public static final Property lowMetaSpace = BSystemPlatformServiceQnx.newProperty((int)3, (boolean)false, null);
    public static final Property failureRebootLimit = BSystemPlatformServiceQnx.newProperty((int)3, (int)3, (BFacets)BFacets.make((String[])new String[]{"min"}, (BIDataValue[])new BIDataValue[]{BInteger.make((int)1)}));
    public static final Property failureRebootLimitPeriod = BSystemPlatformServiceQnx.newProperty((int)3, (BValue)BRelTime.makeMinutes((int)10), (BFacets)BFacets.make((String[])new String[]{"units", "min", "showSeconds"}, (BIDataValue[])new BIDataValue[]{BUnit.getUnit((String)"minute"), BRelTime.make((long)0L), BBoolean.FALSE}));
    public static final Type TYPE = Sys.loadType(BSystemPlatformServiceQnx.class);
    private AgentList agentList = null;
    private boolean nativesLoaded = false;
    private static long lastFileCheck;
    private String[] fileSystems;
    private Property[] filesystemProps;
    private int ramFsNdx = -1;
    protected boolean localDaemonSessionAvailable = false;
    private boolean allowRebootLimitUpdate = true;
    private boolean rebootLimitUpdated = false;
    private final File daemonPropertiesFile = new File(Sys.getNiagaraUserHome(), "daemon" + File.separatorChar + "daemon.properties");
    private long lastDaemonPropertiesReload = -1L;

    public String getSerialNumber() {
        return this.getString(serialNumber);
    }

    public void setSerialNumber(String v) {
        this.setString(serialNumber, v, null);
    }

    public String getHardwareRevision() {
        return this.getString(hardwareRevision);
    }

    public void setHardwareRevision(String v) {
        this.setString(hardwareRevision, v, null);
    }

    public int getRamDiskSize() {
        return this.getInt(ramDiskSize);
    }

    public void setRamDiskSize(int v) {
        this.setInt(ramDiskSize, v, null);
    }

    public int getMinFreeRamDiskPercentage() {
        return this.getInt(minFreeRamDiskPercentage);
    }

    public void setMinFreeRamDiskPercentage(int v) {
        this.setInt(minFreeRamDiskPercentage, v, null);
    }

    public boolean getLowRamDiskSpace() {
        return this.getBoolean(lowRamDiskSpace);
    }

    public void setLowRamDiskSpace(boolean v) {
        this.setBoolean(lowRamDiskSpace, v, null);
    }

    public int getMinFreeHeap() {
        return this.getInt(minFreeHeap);
    }

    public void setMinFreeHeap(int v) {
        this.setInt(minFreeHeap, v, null);
    }

    public boolean getLowHeap() {
        return this.getBoolean(lowHeap);
    }

    public void setLowHeap(boolean v) {
        this.setBoolean(lowHeap, v, null);
    }

    public int getFreeHeap() {
        return this.getInt(freeHeap);
    }

    public void setFreeHeap(int v) {
        this.setInt(freeHeap, v, null);
    }

    public int getMaxHeap() {
        return this.getInt(maxHeap);
    }

    public void setMaxHeap(int v) {
        this.setInt(maxHeap, v, null);
    }

    public int getMinFreeDiskPercentage() {
        return this.getInt(minFreeDiskPercentage);
    }

    public void setMinFreeDiskPercentage(int v) {
        this.setInt(minFreeDiskPercentage, v, null);
    }

    public boolean getLowDiskSpace() {
        return this.getBoolean(lowDiskSpace);
    }

    public void setLowDiskSpace(boolean v) {
        this.setBoolean(lowDiskSpace, v, null);
    }

    public int getMinFreeFileDescriptors() {
        return this.getInt(minFreeFileDescriptors);
    }

    public void setMinFreeFileDescriptors(int v) {
        this.setInt(minFreeFileDescriptors, v, null);
    }

    public int getOpenFileDescriptors() {
        return this.getInt(openFileDescriptors);
    }

    public void setOpenFileDescriptors(int v) {
        this.setInt(openFileDescriptors, v, null);
    }

    public int getMaxOpenFileDescriptors() {
        return this.getInt(maxOpenFileDescriptors);
    }

    public void setMaxOpenFileDescriptors(int v) {
        this.setInt(maxOpenFileDescriptors, v, null);
    }

    public boolean getTooManyOpenFiles() {
        return this.getBoolean(tooManyOpenFiles);
    }

    public void setTooManyOpenFiles(boolean v) {
        this.setBoolean(tooManyOpenFiles, v, null);
    }

    public boolean getLowAvailableFiles() {
        return this.getBoolean(lowAvailableFiles);
    }

    public void setLowAvailableFiles(boolean v) {
        this.setBoolean(lowAvailableFiles, v, null);
    }

    public int getMinAvailableFiles() {
        return this.getInt(minAvailableFiles);
    }

    public void setMinAvailableFiles(int v) {
        this.setInt(minAvailableFiles, v, null);
    }

    public int getMinFreePhysicalMemory() {
        return this.getInt(minFreePhysicalMemory);
    }

    public void setMinFreePhysicalMemory(int v) {
        this.setInt(minFreePhysicalMemory, v, null);
    }

    public boolean getLowMemory() {
        return this.getBoolean(lowMemory);
    }

    public void setLowMemory(boolean v) {
        this.setBoolean(lowMemory, v, null);
    }

    public boolean getLowMetaSpace() {
        return this.getBoolean(lowMetaSpace);
    }

    public void setLowMetaSpace(boolean v) {
        this.setBoolean(lowMetaSpace, v, null);
    }

    public int getFailureRebootLimit() {
        return this.getInt(failureRebootLimit);
    }

    public void setFailureRebootLimit(int v) {
        this.setInt(failureRebootLimit, v, null);
    }

    public BRelTime getFailureRebootLimitPeriod() {
        return (BRelTime)this.get(failureRebootLimitPeriod);
    }

    public void setFailureRebootLimitPeriod(BRelTime v) {
        this.set(failureRebootLimitPeriod, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BSystemPlatformServiceQnx() {
        this.setTimezoneDayModeSupport(BDstSupportLevel.full);
    }

    @Override
    public void serviceStarted() throws Exception {
        super.serviceStarted();
    }

    @Override
    public void serviceStopped() throws Exception {
        super.serviceStopped();
    }

    @Override
    public boolean isValidPlatform() {
        return false;
    }

    @Override
    public void loadPlatformServiceProperties() {
        super.loadPlatformServiceProperties();
        if (!this.loadLibraries()) {
            return;
        }
        IPlatformProvider platformProvider = BSystemPlatformService.PlatformProviderHolder._PLATFORM_PROVIDER_INSTANCE;
        this.fileSystems = platformProvider.getAllFileSystemNames();
        this.filesystemProps = new Property[this.fileSystems.length];
        this.getFilesystemAttributes().removeAll();
        for (int i = 0; i < this.fileSystems.length; ++i) {
            BFilesystemAttributes attrs = new BFilesystemAttributes(platformProvider.getTotalBytes(this.fileSystems[i]) / 1024L, platformProvider.getFreeBytes(this.fileSystems[i]) / 1024L, platformProvider.getMaxFileCount(this.fileSystems[i]), platformProvider.getCurrentFileCount(this.fileSystems[i]));
            if (this.fileSystems[i].contains("/aram0")) {
                attrs.setIsRamDisk(true);
                this.ramFsNdx = i;
                this.setRamDiskSize((int)(attrs.getTotalSpace() / 1024L) + 1);
            }
            this.filesystemProps[i] = this.getFilesystemAttributes().add(SlotPath.escape((String)this.fileSystems[i]), (BValue)attrs, 3);
        }
        this.setTotalPhysicalMemory((int)(platformProvider.getTotalPhysicalMemoryBytes() / 1024L));
        this.setFreePhysicalMemory((int)(platformProvider.getFreePhysicalMemoryBytes() / 1024L));
        this.setCurrentCpuUsage(platformProvider.getCurrentCPUUtilization());
        this.setOverallCpuUsage(platformProvider.getOverallCPUUtilization());
        this.setNumCpus(Runtime.getRuntime().availableProcessors());
        this.setFreeHeap((int)(Runtime.getRuntime().freeMemory() / 0x100000L));
        this.setMaxHeap((int)(Runtime.getRuntime().maxMemory() / 0x100000L));
        this.setHardwareRevision(BSystemPlatformServiceQnx.getQNXSystemInfo("/sys/info/sysrev", "N/A"));
        this.setSerialNumber(BSystemPlatformServiceQnx.getQNXSystemInfo("/sys/info/serialnum", "N/A"));
        this.setMaxOpenFileDescriptors(this.getMaxOpenFds());
        this.setOpenFileDescriptors(this.getFdUsageCount());
        this.localDaemonSessionAvailable = LocalSessionUtil.localDaemonIsAvailable();
    }

    @Override
    public void doSavePlatformServiceProperties() throws Exception {
        if (!this.isRunning()) {
            return;
        }
        super.doSavePlatformServiceProperties();
        this.checkPropertiesLoaded();
        if (this.rebootLimitUpdated) {
            this.allowRebootLimitUpdate = false;
            BDaemonSession daemonSession = LocalSessionUtil.getLocalSession();
            RebootLimits limits = new RebootLimits(this.getFailureRebootLimit(), this.getFailureRebootLimitPeriod());
            String msg = daemonSession.getErrorText(new UpdateRebootLimitsMessage(limits.limit, limits.period));
            if (msg != null) {
                throw new BajaRuntimeException(msg);
            }
            this.allowRebootLimitUpdate = true;
            try {
                this.lastDaemonPropertiesReload = AccessController.doPrivileged(() -> this.daemonPropertiesFile.lastModified());
            }
            catch (PrivilegedActionException pae) {
                throw new BajaRuntimeException((Throwable)pae);
            }
            this.rebootLimitUpdated = false;
        }
    }

    @Override
    public void doPoll(Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (!this.loadLibraries()) {
            return;
        }
        IPlatformProvider platformProvider = BSystemPlatformService.PlatformProviderHolder._PLATFORM_PROVIDER_INSTANCE;
        this.setFreePhysicalMemory((int)(platformProvider.getFreePhysicalMemoryBytes() / 1024L));
        this.setCurrentCpuUsage(platformProvider.getCurrentCPUUtilization());
        this.setOverallCpuUsage(platformProvider.getOverallCPUUtilization());
        this.setFreeHeap((int)(Runtime.getRuntime().freeMemory() / 0x100000L));
        if (cx != null && cx.getFacets().getb("resourceOnly", false)) {
            return;
        }
        super.doPoll(cx);
        long fileCheck = Clock.ticks();
        if (fileCheck - lastFileCheck > 15000L) {
            lastFileCheck = fileCheck;
            if (this.fileSystems != null) {
                for (int i = 0; i < this.fileSystems.length; ++i) {
                    BFilesystemAttributes attrs = (BFilesystemAttributes)this.getFilesystemAttributes().get(this.filesystemProps[i]);
                    attrs.setFreeSpace(platformProvider.getFreeBytes(this.fileSystems[i]) / 1024L);
                    attrs.setCurrentFileCount((int)platformProvider.getCurrentFileCount(this.fileSystems[i]));
                }
            }
            this.setOpenFileDescriptors(this.getFdUsageCount());
        }
        if (this.localDaemonSessionAvailable && !this.rebootLimitUpdated) {
            long lastDaemonPropertiesModifiedTime;
            try {
                lastDaemonPropertiesModifiedTime = AccessController.doPrivileged(() -> this.daemonPropertiesFile.lastModified());
            }
            catch (PrivilegedActionException pae) {
                throw new BajaRuntimeException((Throwable)pae);
            }
            if (this.lastDaemonPropertiesReload != lastDaemonPropertiesModifiedTime) {
                Properties daemonProperties;
                int failureRebootLimit = this.getFailureRebootLimit();
                long failureRebootLimitPeriod = this.getFailureRebootLimitPeriod().getMillis();
                try {
                    daemonProperties = AccessController.doPrivileged(() -> {
                        Properties properties = new Properties();
                        try (FileInputStream daemonPropertiesInput = new FileInputStream(this.daemonPropertiesFile);){
                            properties.load(daemonPropertiesInput);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return properties;
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw new BajaRuntimeException((Throwable)pae);
                }
                try {
                    failureRebootLimit = Integer.valueOf(daemonProperties.getProperty("failureRebootLimit", String.valueOf(failureRebootLimit)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    failureRebootLimitPeriod = Long.valueOf(daemonProperties.getProperty("failureRebootLimitPeriod", String.valueOf(failureRebootLimitPeriod)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (failureRebootLimit != this.getFailureRebootLimit() || failureRebootLimitPeriod != this.getFailureRebootLimitPeriod().getMillis()) {
                    if (BPlatform.log.isLoggable(Level.FINE)) {
                        BPlatform.log.log(Level.FINE, "daemon.properties modification found, updating Station failure reboot limits");
                    }
                    this.allowRebootLimitUpdate = false;
                    this.setFailureRebootLimit(failureRebootLimit);
                    this.setFailureRebootLimitPeriod(BRelTime.make((long)failureRebootLimitPeriod));
                    this.allowRebootLimitUpdate = true;
                }
                this.lastDaemonPropertiesReload = lastDaemonPropertiesModifiedTime;
            }
        }
    }

    @Override
    public String makeRootName(String rootDirName) {
        return "/" + rootDirName;
    }

    @Override
    public final void doRestartStation() throws Exception {
        if (this.getAllowStationRestart()) {
            super.doRestartStation();
        } else {
            this.doReboot();
        }
    }

    @Override
    public final void doReboot() throws Exception {
        new Thread("BSystemPlatformService::doReboot"){

            @Override
            public void run() {
                boolean manualReboot = false;
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    AccessController.doPrivileged(() -> {
                        Station.shutdown((boolean)true, (int)-99);
                        return null;
                    });
                }
                catch (PrivilegedActionException e) {
                    manualReboot = true;
                    BPlatform.log.log(Level.SEVERE, "Station shutdown failed, rebooting manually", e.getException());
                }
                if (manualReboot) {
                    BSystemPlatformServiceQnx.rebootManually();
                }
            }
        }.start();
    }

    private static void rebootManually() {
        try {
            Station.shutdown((boolean)false);
        }
        catch (Exception e) {
            BPlatform.log.log(Level.SEVERE, "Failed to shutdown station", e);
        }
        try {
            AccessController.doPrivileged(() -> {
                BSystemPlatformService.PlatformProviderHolder._PLATFORM_PROVIDER_INSTANCE.reboot();
                return null;
            });
        }
        catch (Exception e) {
            BPlatform.log.log(Level.SEVERE, "Failed to execute QNX shutdown command", e);
        }
    }

    protected boolean isLowJavaHeap() {
        long minFreeBytes = (long)this.getMinFreeHeap() * 1024L * 1024L;
        long maxHeapBytes = (long)this.getMaxHeap() * 1024L * 1024L;
        boolean lowHeap = false;
        boolean wasLowHeap = this.getLowHeap();
        long total = Runtime.getRuntime().totalMemory();
        if (minFreeBytes == 0L || total < maxHeapBytes) {
            lowHeap = false;
        } else {
            long heapFree = Runtime.getRuntime().freeMemory();
            if (heapFree < minFreeBytes) {
                if (BPlatform.log.isLoggable(Level.FINE)) {
                    BPlatform.log.fine("Low Heap Monitor forcing GC, heapFree " + heapFree + " < minFree " + minFreeBytes);
                }
                System.gc();
                heapFree = Runtime.getRuntime().freeMemory();
                if (heapFree < minFreeBytes) {
                    lowHeap = true;
                    if (!wasLowHeap) {
                        BPlatform.log.warning("Low Heap: heapFree " + heapFree + " < minFree " + minFreeBytes);
                    }
                }
            }
        }
        this.setLowHeap(lowHeap);
        return lowHeap;
    }

    protected boolean isLowRamDisk() {
        boolean lowDisk;
        if (this.filesystemProps == null || this.ramFsNdx < 0) {
            return false;
        }
        int minFreePercent = this.getMinFreeRamDiskPercentage();
        BFilesystemAttributes attrs = (BFilesystemAttributes)this.getFilesystemAttributes().get(this.filesystemProps[this.ramFsNdx]);
        int percentFree = (int)(attrs.getFreeSpace() * 100L / attrs.getTotalSpace());
        if (attrs.getFreeSpace() > 0L && percentFree < minFreePercent) {
            lowDisk = true;
            if (!this.getLowRamDiskSpace()) {
                BPlatform.log.warning("Low RAM Disk Space: " + percentFree + "% free, minimum " + minFreePercent + "%");
            }
        } else {
            lowDisk = false;
        }
        this.setLowRamDiskSpace(lowDisk);
        return lowDisk;
    }

    protected boolean isLowDisk() {
        boolean lowDisk;
        if (this.filesystemProps == null) {
            return false;
        }
        int minFreePercent = this.getMinFreeDiskPercentage();
        BFilesystemAttributes attrs = (BFilesystemAttributes)this.getFilesystemAttributes().get(this.filesystemProps[0]);
        int percentFree = (int)(attrs.getFreeSpace() * 100L / attrs.getTotalSpace());
        if (attrs.getFreeSpace() > 0L && percentFree < minFreePercent) {
            lowDisk = true;
            if (!this.getLowDiskSpace()) {
                BPlatform.log.warning("Low Disk Space " + percentFree + "% free, minimum " + minFreePercent + "%");
            }
        } else {
            lowDisk = false;
        }
        this.setLowDiskSpace(lowDisk);
        return lowDisk;
    }

    private boolean isFdUsageHigh() {
        boolean tooMany;
        int used = this.getOpenFileDescriptors();
        int max = this.getMaxOpenFileDescriptors();
        int min = this.getMinFreeFileDescriptors();
        if (used >= 0 && max - used < min) {
            tooMany = true;
            if (!this.getTooManyOpenFiles()) {
                BPlatform.log.warning("Too many open files or sockets: " + used + " in use, maximum available is " + max);
            }
        } else {
            tooMany = false;
        }
        this.setTooManyOpenFiles(tooMany);
        return tooMany;
    }

    private boolean isFileCountHigh() {
        boolean tooManyFiles;
        if (this.filesystemProps == null) {
            return false;
        }
        int minFiles = this.getMinAvailableFiles();
        BFilesystemAttributes attrs = (BFilesystemAttributes)this.getFilesystemAttributes().get(this.filesystemProps[0]);
        long maxFiles = attrs.getMaxFileCount();
        long currentFiles = attrs.getCurrentFileCount();
        if (currentFiles >= 0L && maxFiles - currentFiles < (long)minFiles) {
            tooManyFiles = true;
            if (!this.getLowAvailableFiles()) {
                BPlatform.log.warning("Too many files: " + currentFiles + " on file system: " + this.fileSystems[0] + ", maximum available is " + maxFiles);
            }
        } else {
            tooManyFiles = false;
        }
        this.setLowAvailableFiles(tooManyFiles);
        return tooManyFiles;
    }

    private boolean isLowMemory() {
        boolean lowMem;
        int free = this.getFreePhysicalMemory();
        int min = this.getMinFreePhysicalMemory();
        if (free > 0 && free < min) {
            lowMem = true;
            if (!this.getLowMemory()) {
                BPlatform.log.warning("Low System Memory " + free + "KB available");
            }
        } else {
            lowMem = false;
        }
        this.setLowMemory(lowMem);
        return lowMem;
    }

    private boolean isLowMetaSpace() {
        boolean lowMeta;
        int minPercentage = AccessController.doPrivileged(() -> Integer.getInteger("niagara.minMetaSpacePercentage", 5));
        int freePercentage = 100;
        long freeMetaspaceKB = 0L;
        if (minPercentage < 0 || minPercentage > 100) {
            minPercentage = 5;
        }
        List<MemoryPoolMXBean> poolList = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean pool : poolList) {
            if (!pool.getName().equalsIgnoreCase("Metaspace")) continue;
            long maxMetaspaceBytes = pool.getUsage().getMax();
            long currentMetaspaceBytes = pool.getUsage().getUsed();
            long freeMetaspaceBytes = maxMetaspaceBytes - currentMetaspaceBytes;
            freePercentage = (int)(freeMetaspaceBytes * 100L / maxMetaspaceBytes);
            freeMetaspaceKB = freeMetaspaceBytes / 1024L;
        }
        if (freePercentage < minPercentage) {
            lowMeta = true;
            if (!this.getLowMetaSpace()) {
                BPlatform.log.warning("Low Meta Space " + freeMetaspaceKB + " KB available");
            }
        } else {
            lowMeta = false;
        }
        this.setLowMetaSpace(lowMeta);
        return lowMeta;
    }

    @Override
    public String checkForStationFault() {
        if (this.isLowMemory()) {
            return "stationFault.lowSystemMemory";
        }
        if (this.isLowJavaHeap()) {
            return "stationFault.lowHeap";
        }
        if (this.isLowDisk()) {
            return "stationFault.diskSpace";
        }
        if (this.isLowRamDisk()) {
            return "stationFault.ramDiskSpace";
        }
        if (this.isFdUsageHigh()) {
            return "stationFault.fdUsage";
        }
        if (this.isFileCountHigh()) {
            return "stationFault.fileUsage";
        }
        if (this.isLowMetaSpace()) {
            return "stationFault.lowMetaSpace";
        }
        return null;
    }

    @Override
    public void queryResources(ResourceReport rr) {
        rr.put("fd.open", String.valueOf(this.getOpenFileDescriptors()));
        rr.put("fd.max", String.valueOf(this.getMaxOpenFileDescriptors()));
    }

    @Override
    public FileArchive createFileArchive(String archiveId) {
        if (this.getRamDiskSize() == 0) {
            if (ZipArchive.log.isLoggable(Level.FINEST)) {
                ZipArchive.log.finest("QNX System Platform Service RAM disk size is 0, returning NullFileArchive for archive identifier \"" + archiveId + "\"");
            }
            return new NullFileArchive();
        }
        return super.createFileArchive(archiveId);
    }

    @Override
    public synchronized void extractArchive(String archiveId) {
        if (this.getRamDiskSize() == 0) {
            if (ZipArchive.log.isLoggable(Level.FINEST)) {
                ZipArchive.log.finest("QNX System Platform Service RAM disk size is 0, skipping archive extraction for archive identifier \"" + archiveId + "\"");
            }
            return;
        }
        super.extractArchive(archiveId);
    }

    @Override
    public AgentList getAgents(Context cx) {
        if (this.agentList == null) {
            this.agentList = super.getAgents(cx);
            this.agentList.remove("platform:SystemPlatformServicePlugin");
        }
        return this.agentList;
    }

    @Override
    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        if (this.allowRebootLimitUpdate && this.platformServicePropertiesLoaded && (prop == failureRebootLimit || prop == failureRebootLimitPeriod)) {
            this.rebootLimitUpdated = true;
        }
    }

    @Override
    protected void doRenameAndRestart(BDaemonSession daemon, String oldStationName, String newStationName) throws Exception {
        try {
            AccessController.doPrivileged(() -> {
                Station.shutdown((boolean)false);
                FilePath stationsDir = SystemFilePaths.getStationsDirPath((BIFileSpace)daemon.getFileSpace());
                BFileSystem.INSTANCE.delete(stationsDir.merge(newStationName));
                BFileSystem.INSTANCE.move(stationsDir.merge(oldStationName), stationsDir.merge(newStationName));
                XmlResponseMessage restartMessage = this.getAllowStationRestart() ? new StartAppMessage("station", newStationName) : new XmlResponseMessage(){

                    @Override
                    public String getMessageString() {
                        return "reboot?force=true";
                    }

                    @Override
                    public boolean isStateChangeMessage() {
                        return true;
                    }

                    @Override
                    public int getConnectionFlags() {
                        return 4;
                    }
                };
                XmlResponseMessage[] messages = new XmlResponseMessage[]{new UpdateStationMessage(), new UpdateStationMessage(newStationName, false, true, true, true), restartMessage};
                daemon.sendMessages(messages, BDaemonSession.DEFAULT_TIMEOUT);
                return null;
            });
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
    }

    private static String getQNXSystemInfo(String path, String defaultValue) {
        return AccessController.doPrivileged(() -> {
            String returnValue = defaultValue;
            try (BufferedReader reader = new BufferedReader(new FileReader(new File(path)));){
                returnValue = reader.readLine();
                if (returnValue == null) {
                    returnValue = defaultValue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return returnValue;
        });
    }

    protected boolean loadLibraries() {
        if (this.nativesLoaded) {
            return true;
        }
        return AccessController.doPrivileged(() -> {
            try {
                BPlatform.log.fine("Loading platform native library");
                System.loadLibrary("platform");
                this.nativesLoaded = true;
            }
            catch (Throwable e) {
                BPlatform.log.log(Level.SEVERE, "Cannot load platform native library", e);
            }
            return this.nativesLoaded;
        });
    }

    protected int getFdUsageCount() {
        return BSystemPlatformServiceQnx.getFdUsageCount0();
    }

    protected int getMaxOpenFds() {
        return BSystemPlatformServiceQnx.getMaxOpenFds0();
    }

    private static native int getFdUsageCount0();

    private static native int getMaxOpenFds0();

    static {
        if (PlatformUtil.isTridiumPlatform() && OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.qnx)) {
            Spy.ROOT.add("platform diagnostics", (Spy)new QnxDiagnosticsPage());
        }
        lastFileCheck = 0L;
    }

    private static class RebootLimits {
        int limit;
        BRelTime period;

        public RebootLimits(int limit, BRelTime period) {
            this.limit = limit;
            this.period = period;
        }
    }
}

