/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.npsdk;

import com.tridium.nre.platform.IPlatformProvider;
import com.tridium.platform.BFilesystemAttributes;
import com.tridium.platform.BPlatform;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.timezone.BDstSupportLevel;
import com.tridium.sys.station.Station;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.logging.Level;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BSystemPlatformServiceNpsdk
extends BSystemPlatformService {
    public static final Type TYPE = Sys.loadType(BSystemPlatformServiceNpsdk.class);
    private static long lastFileCheck = 0L;
    private String[] fileSystems;
    private Property[] filesystemProps;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BSystemPlatformServiceNpsdk() {
        this.setTimezoneDayModeSupport(BDstSupportLevel.full);
    }

    @Override
    public boolean isValidPlatform() {
        return false;
    }

    @Override
    public void loadPlatformServiceProperties() {
        super.loadPlatformServiceProperties();
        IPlatformProvider platformProvider = BSystemPlatformService.PlatformProviderHolder._PLATFORM_PROVIDER_INSTANCE;
        this.fileSystems = platformProvider.getAllFileSystemNames();
        this.filesystemProps = new Property[this.fileSystems.length];
        this.getFilesystemAttributes().removeAll();
        for (int i = 0; i < this.fileSystems.length; ++i) {
            BFilesystemAttributes attrs = new BFilesystemAttributes(platformProvider.getTotalBytes(this.fileSystems[i]) / 1024L, platformProvider.getFreeBytes(this.fileSystems[i]) / 1024L, platformProvider.getMaxFileCount(this.fileSystems[i]), platformProvider.getCurrentFileCount(this.fileSystems[i]));
            this.filesystemProps[i] = this.getFilesystemAttributes().add(SlotPath.escape((String)this.fileSystems[i]), (BValue)attrs, 3);
        }
        this.setTotalPhysicalMemory((int)(platformProvider.getTotalPhysicalMemoryBytes() / 1024L));
        this.setFreePhysicalMemory((int)(platformProvider.getFreePhysicalMemoryBytes() / 1024L));
        this.setCurrentCpuUsage(platformProvider.getCurrentCPUUtilization());
        this.setOverallCpuUsage(platformProvider.getOverallCPUUtilization());
        this.setNumCpus(Runtime.getRuntime().availableProcessors());
    }

    @Override
    public void doPoll(Context cx) {
        if (!this.isRunning()) {
            return;
        }
        IPlatformProvider platformProvider = BSystemPlatformService.PlatformProviderHolder._PLATFORM_PROVIDER_INSTANCE;
        this.setFreePhysicalMemory((int)(platformProvider.getFreePhysicalMemoryBytes() / 1024L));
        this.setCurrentCpuUsage(platformProvider.getCurrentCPUUtilization());
        this.setOverallCpuUsage(platformProvider.getOverallCPUUtilization());
        if (cx != null && cx.getFacets().getb("resourceOnly", false)) {
            return;
        }
        super.doPoll(cx);
        long fileCheck = Clock.ticks();
        if (fileCheck - lastFileCheck > 15000L) {
            lastFileCheck = fileCheck;
            for (int i = 0; i < this.fileSystems.length; ++i) {
                BFilesystemAttributes attrs = (BFilesystemAttributes)this.getFilesystemAttributes().get(this.filesystemProps[i]);
                attrs.setFreeSpace(platformProvider.getFreeBytes(this.fileSystems[i]) / 1024L);
                attrs.setCurrentFileCount((int)platformProvider.getCurrentFileCount(this.fileSystems[i]));
            }
        }
    }

    @Override
    public String makeRootName(String rootDirName) {
        return "/" + rootDirName + "/";
    }

    @Override
    public final void doRestartStation() throws Exception {
        if (this.getIsServiceReadonly()) {
            BPlatform.log.log(Level.SEVERE, "Ignoring Restart Station request, System Platform Service is readonly");
            return;
        }
        if (this.getAllowStationRestart()) {
            super.doRestartStation();
        } else {
            this.doReboot();
        }
    }

    @Override
    public final void doReboot() throws Exception {
        if (!BSystemPlatformServiceNpsdk.isRebootSupported()) {
            throw new LocalizableRuntimeException("platform", "system.error.rebootNotSupported");
        }
        new Thread("BSystemPlatformService::doReboot"){

            @Override
            public void run() {
                boolean manualReboot = false;
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    AccessController.doPrivileged(() -> {
                        Station.shutdown((boolean)true, (int)-99);
                        return null;
                    });
                }
                catch (PrivilegedActionException e) {
                    manualReboot = true;
                    BPlatform.log.log(Level.SEVERE, "Station shutdown failed, rebooting manually", e.getException());
                }
                if (manualReboot) {
                    BSystemPlatformServiceNpsdk.rebootManually();
                }
            }
        }.start();
    }

    private static void rebootManually() {
        try {
            Station.shutdown((boolean)false);
        }
        catch (Exception e) {
            BPlatform.log.log(Level.SEVERE, "Failed to shutdown station", e);
        }
        try {
            AccessController.doPrivileged(() -> {
                BSystemPlatformService.PlatformProviderHolder._PLATFORM_PROVIDER_INSTANCE.reboot();
                return null;
            });
        }
        catch (Exception e) {
            BPlatform.log.log(Level.SEVERE, "Failed to execute NPSDK shutdown command", e);
        }
    }
}

