/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.npsdk;

import com.tridium.platform.ntp.BNtpPlatformService;
import com.tridium.platform.ntp.BNtpServer;
import com.tridium.platform.posix.BNtpModePosix;
import java.util.StringTokenizer;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BNtpServerNpsdk
extends BNtpServer {
    public static final Property useBurst = BNtpServerNpsdk.newProperty((int)3, (boolean)false, null);
    public static final Property serverPreferred = BNtpServerNpsdk.newProperty((int)3, (boolean)false, null);
    public static final Property minPollInterval = BNtpServerNpsdk.newProperty((int)3, (int)6, (BFacets)BFacets.make((String[])new String[]{"min", "max", "fieldWidth", "units"}, (BIDataValue[])new BIDataValue[]{BInteger.make((int)4), BInteger.make((int)16), BInteger.make((int)3), BNtpPlatformService.LOG_2_SEC_UNIT}));
    public static final Property maxPollInterval = BNtpServerNpsdk.newProperty((int)3, (int)10, (BFacets)BFacets.make((String[])new String[]{"min", "max", "fieldWidth", "units"}, (BIDataValue[])new BIDataValue[]{BInteger.make((int)5), BInteger.make((int)17), BInteger.make((int)3), BNtpPlatformService.LOG_2_SEC_UNIT}));
    public static final Property peerMode = BNtpServerNpsdk.newProperty((int)3, (BValue)BNtpModePosix.server, (BFacets)BFacets.make((String)"range", (BIDataValue)BEnumRange.make(null, (int[])new int[]{2, 1, 3, 4}, (String[])new String[]{BNtpModePosix.server.getTag(), BNtpModePosix.peer.getTag(), BNtpModePosix.broadcast.getTag(), BNtpModePosix.manycastclient.getTag()})));
    public static final Type TYPE = Sys.loadType(BNtpServerNpsdk.class);
    protected String serverString = null;

    public boolean getUseBurst() {
        return this.getBoolean(useBurst);
    }

    public void setUseBurst(boolean v) {
        this.setBoolean(useBurst, v, null);
    }

    public boolean getServerPreferred() {
        return this.getBoolean(serverPreferred);
    }

    public void setServerPreferred(boolean v) {
        this.setBoolean(serverPreferred, v, null);
    }

    public int getMinPollInterval() {
        return this.getInt(minPollInterval);
    }

    public void setMinPollInterval(int v) {
        this.setInt(minPollInterval, v, null);
    }

    public int getMaxPollInterval() {
        return this.getInt(maxPollInterval);
    }

    public void setMaxPollInterval(int v) {
        this.setInt(maxPollInterval, v, null);
    }

    public BNtpModePosix getPeerMode() {
        return (BNtpModePosix)this.get(peerMode);
    }

    public void setPeerMode(BNtpModePosix v) {
        this.set(peerMode, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BNtpServerNpsdk() {
    }

    public BNtpServerNpsdk(String serverString) {
        this.updateServerString(serverString);
    }

    @Override
    public BNtpServer makeServer(String serverString) {
        return new BNtpServerNpsdk(serverString);
    }

    @Override
    public void updateServerString(String serverString) {
        this.serverString = serverString;
        StringTokenizer tokenizer = new StringTokenizer(serverString);
        String buf = tokenizer.nextToken();
        if (buf.equals("server")) {
            this.setPeerMode(BNtpModePosix.server);
        } else if (buf.equals("peer")) {
            this.setPeerMode(BNtpModePosix.peer);
        } else if (buf.equals("broadcast")) {
            this.setPeerMode(BNtpModePosix.broadcast);
        } else if (buf.equals("manycastclient")) {
            this.setPeerMode(BNtpModePosix.manycastclient);
        }
        this.setAddress(tokenizer.nextToken());
        this.setUseBurst(false);
        this.setMaxPollInterval(10);
        this.setMinPollInterval(6);
        this.setServerPreferred(false);
        buf = null;
        while (tokenizer.hasMoreTokens()) {
            buf = tokenizer.nextToken();
            switch (buf.charAt(0)) {
                case 'b': {
                    if (!buf.equals("burst")) break;
                    this.setUseBurst(true);
                    break;
                }
                case 'm': {
                    if (buf.equals("minpoll")) {
                        this.setMinPollInterval(Integer.valueOf(tokenizer.nextToken()));
                        break;
                    }
                    if (!buf.equals("maxpoll")) break;
                    this.setMaxPollInterval(Integer.valueOf(tokenizer.nextToken()));
                    break;
                }
                case 'p': {
                    if (!buf.equals("prefer")) break;
                    this.setServerPreferred(true);
                }
            }
        }
    }

    @Override
    public String getServerString() {
        if (this.serverString == null) {
            this.serverString = this.getServerString(this.getPeerMode(), this.getAddress(), this.getUseBurst(), this.getServerPreferred(), this.getMinPollInterval(), this.getMaxPollInterval());
        }
        return this.serverString;
    }

    public String getServerString(BNtpModePosix peerMode, String address, boolean useBurst, boolean serverPreferred, int minPollInterval, int maxPollInterval) {
        StringBuffer result = null;
        if (peerMode == BNtpModePosix.server) {
            result = new StringBuffer("server");
        } else if (peerMode == BNtpModePosix.peer) {
            result = new StringBuffer("peer");
        } else if (peerMode == BNtpModePosix.manycastclient) {
            result = new StringBuffer("manycastclient");
        } else if (peerMode == BNtpModePosix.broadcast) {
            result = new StringBuffer("broadcast");
        } else {
            return null;
        }
        result.append(" ").append(address);
        if (useBurst) {
            result.append(" burst");
        }
        if (serverPreferred && peerMode != BNtpModePosix.manycastclient && peerMode != BNtpModePosix.broadcast) {
            result.append(" prefer");
        }
        if (minPollInterval != 6 && minPollInterval >= 4 && minPollInterval < 17 && minPollInterval < maxPollInterval) {
            result.append(" minpoll ").append(minPollInterval);
        }
        if (maxPollInterval != 10 && maxPollInterval <= 17 && maxPollInterval > 4 && maxPollInterval > minPollInterval) {
            result.append(" maxpoll ").append(maxPollInterval);
        }
        return result.toString().trim();
    }

    @Override
    public String getPropertyName(String serverString) {
        return SlotPath.escape((String)serverString);
    }

    public synchronized boolean equivalent(Object o) {
        if (o instanceof String) {
            return this.getServerString().equals(o);
        }
        if (o instanceof BNtpServerNpsdk) {
            return ((BNtpServerNpsdk)((Object)o)).getServerString().equals(this.getServerString());
        }
        return false;
    }

    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        if (prop == address || prop == useBurst || prop == maxPollInterval || prop == minPollInterval || prop == serverPreferred || prop == peerMode) {
            this.serverString = null;
        }
    }
}

