/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.license;

import com.tridium.file.types.text.BCertificateFile;
import com.tridium.file.types.text.BLicenseFile;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.file.BFoxFileStore;
import com.tridium.platform.daemon.message.ByteArrayFileTransferElement;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.fox.BLicenseChannel;
import com.tridium.platform.license.BCertificateSummary;
import com.tridium.platform.license.BEnvLicenseSummary;
import com.tridium.platform.license.BLicenseArchiveFile;
import com.tridium.platform.license.BrandProps;
import com.tridium.platform.license.CertificateInfo;
import com.tridium.platform.license.IFileInfo;
import com.tridium.platform.license.LicenseInfo;
import com.tridium.platform.license.LicenseModel;
import com.tridium.platform.license.LicenseSync;
import com.tridium.sys.license.dom.CertificateDatabase;
import com.tridium.sys.license.dom.Feature;
import com.tridium.sys.license.dom.LicenseDatabase;
import com.tridium.sys.license.dom.VendorCertificate;
import com.tridium.sys.license.dom.VendorLicense;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.baja.file.BIFile;
import javax.baja.sys.BModule;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.util.Version;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class PortalLicenseUtil {
    private static boolean initialized = false;
    private static Class<?> portalApiClass = null;

    public static IFileInfo makeFileInfo(BIFile file) throws Exception {
        InputStream in2;
        BLicenseChannel channel = null;
        if (file.getSession() instanceof BFoxSession) {
            BFoxSession session = (BFoxSession)file.getSession();
            try {
                Version remoteVersion = (Version)session.fw(404, (Object)"platform", (Object)"rt", null, null);
                if (remoteVersion != null && remoteVersion.compareTo(new Version("3.7.201")) != -1) {
                    channel = (BLicenseChannel)session.getConnection().getChannels().get("license", BLicenseChannel.TYPE);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (file instanceof BLicenseFile) {
            if (channel != null) {
                try {
                    in2 = channel.read((BFoxFileStore)file.getStore());
                    return new LicenseInfo(XParser.make((InputStream)in2).parse(true), file);
                }
                catch (Exception in2) {
                    // empty catch block
                }
            }
            return new LicenseInfo(file);
        }
        if (file instanceof BCertificateFile) {
            if (channel != null) {
                try {
                    in2 = channel.read((BFoxFileStore)file.getStore());
                    return new CertificateInfo(XParser.make((InputStream)in2).parse(true), file);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return new CertificateInfo(file);
        }
        return null;
    }

    public static synchronized boolean isApiAvailable() {
        if (!initialized) {
            try {
                BModule portalApiModule = Sys.loadModule((String)"portalApi");
                portalApiClass = portalApiModule.loadClass("com.tridium.portal.api.PortalApi");
            }
            catch (ClassNotFoundException | ModuleNotFoundException throwable) {
                // empty catch block
            }
            initialized = true;
        }
        return portalApiClass != null;
    }

    public static boolean autoFetchLicenses() {
        return BrandProps.getLocalInstance().get("license.autoFetch", true);
    }

    public static boolean requestLicensesOnline() {
        return BrandProps.getLocalInstance().get("license.onlineRequest", true);
    }

    public static VendorLicense[] getUpdatedLicenses(BEnvLicenseSummary[] summaries, LicenseDatabase db) throws Exception {
        ArrayList<VendorLicense> result = new ArrayList<VendorLicense>();
        for (BEnvLicenseSummary summary : summaries) {
            HashSet<String> nonTridiumVendorsSent = new HashSet<String>();
            for (VendorLicense license : db.getLicenses(summary.getHostId(), summary.getBrandId())) {
                String vendor = license.getVendor();
                if (!vendor.equalsIgnoreCase("tridium") && nonTridiumVendorsSent.contains(vendor)) continue;
                long summaryGenerated = summary.getLicenseGenerated(vendor);
                long licenseGenerated = license.getGenerated();
                if (summary.getLicenseSignature(vendor) != null && summaryGenerated >= licenseGenerated && (summaryGenerated != licenseGenerated || license.getSignature().equals(summary.getLicenseSignature(vendor)))) continue;
                result.add(license);
                if (vendor.equalsIgnoreCase("tridium")) continue;
                nonTridiumVendorsSent.add(vendor);
            }
        }
        return result.toArray(new VendorLicense[result.size()]);
    }

    public static VendorCertificate[] getUpdatedCertificates(BCertificateSummary[] summaries, CertificateDatabase db) throws Exception {
        ArrayList<VendorCertificate> result = new ArrayList<VendorCertificate>();
        for (BCertificateSummary summary : summaries) {
            VendorCertificate cert = db.getCertificate(summary.getVendor());
            if (cert == null) continue;
            long summaryGenerated = summary.getCertificateGenerated();
            long certGenerated = cert.getGenerated();
            if (summary.getCertificateSignature() != null && summaryGenerated >= certGenerated && (summaryGenerated != certGenerated || cert.getSignature().equals(summary.getCertificateSignature()))) continue;
            result.add(cert);
        }
        return result.toArray(new VendorCertificate[result.size()]);
    }

    public static VendorLicense[] getPortalUpdates(VendorLicense[] current) throws Exception {
        return PortalLicenseUtil.getPortalUpdates(BEnvLicenseSummary.make(current));
    }

    public static VendorLicense[] getPortalUpdates(BEnvLicenseSummary[] summaries) throws Exception {
        if (!PortalLicenseUtil.isApiAvailable()) {
            throw new UnsupportedOperationException();
        }
        try {
            Method method = portalApiClass.getMethod("getLicenseUpdates", XElem[].class);
            XElem[] summaryArg = new XElem[summaries.length];
            for (int i = 0; i < summaries.length; ++i) {
                summaryArg[i] = summaries[i].asXml();
            }
            XElem[] updates = (XElem[])method.invoke(null, new Object[]{summaryArg});
            VendorLicense[] results = new VendorLicense[updates.length];
            for (int i = 0; i < updates.length; ++i) {
                results[i] = VendorLicense.make((String)"portal", (XElem)updates[i]);
            }
            return results;
        }
        catch (NoSuchMethodException nsme) {
            throw new UnsupportedOperationException();
        }
    }

    public static VendorCertificate[] getPortalUpdates(VendorCertificate[] current) throws Exception {
        return PortalLicenseUtil.getPortalUpdates(BCertificateSummary.make(current));
    }

    public static VendorCertificate[] getPortalUpdates(BCertificateSummary[] summaries) throws Exception {
        if (!PortalLicenseUtil.isApiAvailable()) {
            throw new UnsupportedOperationException();
        }
        try {
            Method method = portalApiClass.getMethod("getCertificateUpdates", XElem[].class);
            XElem[] summaryArg = new XElem[summaries.length];
            for (int i = 0; i < summaries.length; ++i) {
                summaryArg[i] = summaries[i].asXml();
            }
            XElem[] updates = (XElem[])method.invoke(null, new Object[]{summaryArg});
            VendorCertificate[] results = new VendorCertificate[updates.length];
            for (int i = 0; i < updates.length; ++i) {
                results[i] = VendorCertificate.make((String)"portal", (XElem)updates[i]);
            }
            return results;
        }
        catch (NoSuchMethodException nsme) {
            throw new UnsupportedOperationException();
        }
    }

    public static LicenseInfo[] getLicenseInfo(BIFile file, String hostId, String brandId) throws Exception {
        return PortalLicenseUtil.getLicenseInfo(new BIFile[]{file}, hostId, brandId);
    }

    public static LicenseInfo[] getLicenseInfo(BIFile[] files, String hostId, String brandId) throws Exception {
        HashMap<VendorLicense, BIFile> filesByLicense = new HashMap<VendorLicense, BIFile>();
        VendorLicense[] licenses = PortalLicenseUtil.getLicenses(files, hostId, brandId, filesByLicense);
        LicenseInfo[] result = new LicenseInfo[licenses.length];
        for (int i = 0; i < licenses.length; ++i) {
            result[i] = new LicenseInfo(licenses[i], (BIFile)filesByLicense.get(licenses[i]));
        }
        return result;
    }

    public static VendorLicense[] getLicenses(BIFile file, String hostId, String brandId) throws Exception {
        return PortalLicenseUtil.getLicenses(new BIFile[]{file}, hostId, brandId, null);
    }

    public static VendorLicense[] getLicenses(BIFile[] files, String hostId, String brandId) throws Exception {
        return PortalLicenseUtil.getLicenses(files, hostId, brandId, null);
    }

    protected static VendorLicense[] getLicenses(BIFile[] files, String hostId, String brandId, Map<VendorLicense, BIFile> filesByLicense) throws Exception {
        HashMap<String, VendorLicense> licensesByName = new HashMap<String, VendorLicense>();
        String b = brandId;
        for (BIFile file : files) {
            if (file instanceof BLicenseFile) {
                VendorLicense license = VendorLicense.make((BIFile)file);
                if (license.getBrandId() != null && brandId != null && !brandId.equals(license.getBrandId())) continue;
                b = PortalLicenseUtil.accumLicenses(b, licensesByName, filesByLicense, license, file);
                continue;
            }
            if (!(file instanceof BLicenseArchiveFile)) continue;
            for (VendorLicense license : ((BLicenseArchiveFile)file).getLicenses(hostId)) {
                b = PortalLicenseUtil.accumLicenses(b, licensesByName, filesByLicense, license, file);
            }
        }
        VendorLicense[] result = new VendorLicense[licensesByName.size()];
        licensesByName.values().toArray(result);
        return result;
    }

    protected static String accumLicenses(String brandId, Map<String, VendorLicense> licensesByName, Map<VendorLicense, BIFile> filesByLicense, VendorLicense lic, BIFile file) throws Exception {
        VendorLicense existing;
        if (!(lic.getBrandId() != null && brandId != null && !brandId.equals(lic.getBrandId()) || (existing = licensesByName.get(lic.getLicenseName())) != null && existing.getGenerated() >= lic.getGenerated())) {
            licensesByName.put(lic.getLicenseName(), lic);
            if (filesByLicense != null) {
                filesByLicense.put(lic, file);
            }
        }
        return brandId == null ? lic.getBrandId() : brandId;
    }

    public static synchronized boolean checkConnectivity() {
        if (!PortalLicenseUtil.isApiAvailable()) {
            throw new UnsupportedOperationException();
        }
        try {
            Method method = portalApiClass.getMethod("checkConnectivity", new Class[0]);
            return (Boolean)method.invoke(null, (Object[])null);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static List<LicenseModel> getExistingLicenses(String hostId, String brandId, Version requestedVersion) throws Exception {
        if (!PortalLicenseUtil.isApiAvailable()) {
            throw new UnsupportedOperationException();
        }
        Method method = portalApiClass.getMethod("getLicenses", String.class, String.class, Version.class);
        XElem[] licensefiles = (XElem[])method.invoke(null, hostId, brandId, requestedVersion);
        if (licensefiles == null || licensefiles.length == 0) {
            return Collections.emptyList();
        }
        return LicenseModel.make(licensefiles);
    }

    public static XElem[] getCertificates(String hostId) throws Exception {
        if (!PortalLicenseUtil.isApiAvailable()) {
            throw new UnsupportedOperationException();
        }
        Method method = portalApiClass.getMethod("getCertificates", String.class);
        XElem[] certs = (XElem[])method.invoke(null, hostId);
        if (certs == null || certs.length == 0) {
            return null;
        }
        return certs;
    }

    public static XElem getCertificate(String vendor) throws Exception {
        if (!PortalLicenseUtil.isApiAvailable()) {
            throw new UnsupportedOperationException();
        }
        Method method = portalApiClass.getMethod("getCertificate", String.class);
        return (XElem)method.invoke(null, vendor);
    }

    public static XElem[] getCertificates(String[] vendors) throws Exception {
        if (!PortalLicenseUtil.isApiAvailable()) {
            throw new UnsupportedOperationException();
        }
        Method method = portalApiClass.getMethod("getCertificates", vendors.getClass());
        return (XElem[])method.invoke(null, new Object[]{vendors});
    }

    public static LicenseSync<LicenseInfo> syncLicenses(String hostId, LicenseInfo[] current, LicenseInfo[] toInstall) {
        return PortalLicenseUtil.syncLicenses(hostId, LicenseInfo.getLocalBrandFeature(), current, toInstall);
    }

    public static LicenseSync<LicenseInfo> syncLicenses(String hostId, Feature.Brand brandFeature, LicenseInfo[] current, LicenseInfo[] toInstall) {
        ArrayList<LicenseInfo> toAdd = new ArrayList<LicenseInfo>();
        ArrayList<LicenseInfo> toUpdate = new ArrayList<LicenseInfo>();
        ArrayList<LicenseInfo> toRemove = new ArrayList<LicenseInfo>();
        HashMap<String, LicenseInfo> installedLicenses = new HashMap<String, LicenseInfo>();
        for (LicenseInfo licenseInfo : current) {
            VendorLicense license = licenseInfo.vendorLicense;
            if (!license.getHostId().equals(hostId)) continue;
            LicenseInfo loadedInfo = (LicenseInfo)installedLicenses.get(license.getVendor());
            if (loadedInfo != null) {
                VendorLicense loaded = loadedInfo.vendorLicense;
                if (license.getGenerated() > loaded.getGenerated()) {
                    toRemove.add(loadedInfo);
                    installedLicenses.put(license.getVendor(), licenseInfo);
                    continue;
                }
                if (loaded.getGenerated() > license.getGenerated()) {
                    toRemove.add(licenseInfo);
                    continue;
                }
                if (licenseInfo.file.getFileName().equals(licenseInfo.getInstalledFileName())) {
                    toRemove.add(loadedInfo);
                    installedLicenses.put(license.getVendor(), licenseInfo);
                    continue;
                }
                toRemove.add(licenseInfo);
                continue;
            }
            installedLicenses.put(license.getVendor(), licenseInfo);
        }
        for (LicenseInfo licenseInfo : toInstall) {
            boolean update;
            LicenseInfo installedInfo = (LicenseInfo)installedLicenses.get(licenseInfo.vendorLicense.getVendor());
            if (!PortalLicenseUtil.shouldInstall(licenseInfo, installedInfo, brandFeature)) continue;
            boolean bl = update = installedInfo != null;
            if (update) {
                String fileName = licenseInfo.getInstalledFileName();
                if (fileName.equals(installedInfo.file.getFileName())) {
                    toUpdate.add(licenseInfo);
                    continue;
                }
                toRemove.add(installedInfo);
                toAdd.add(licenseInfo);
                continue;
            }
            toAdd.add(licenseInfo);
        }
        return new LicenseSync<LicenseInfo>(toAdd, toUpdate, toRemove);
    }

    public static void sync(FileTransferMessage message, LicenseSync<? extends IFileInfo> sync) {
        int i;
        if (sync == null || message == null) {
            return;
        }
        for (i = 0; i < sync.toAdd.size(); ++i) {
            PortalLicenseUtil.addFile(message, (IFileInfo)sync.toAdd.get(i));
        }
        for (i = 0; i < sync.toUpdate.size(); ++i) {
            PortalLicenseUtil.addFile(message, (IFileInfo)sync.toUpdate.get(i));
        }
        for (i = 0; i < sync.toRemove.size(); ++i) {
            message.addDelete(((IFileInfo)sync.toRemove.get(i)).getInstalledFilePath(message.isNiagara4Space()));
        }
    }

    public static void addLicense(FileTransferMessage message, LicenseInfo license) {
        PortalLicenseUtil.addFile(message, license);
    }

    public static void addCertificate(FileTransferMessage message, CertificateInfo cert) {
        PortalLicenseUtil.addFile(message, cert);
    }

    public static void addFile(FileTransferMessage message, IFileInfo fileInfo) {
        ByteArrayFileTransferElement elem = new ByteArrayFileTransferElement(fileInfo.getInstalledFilePath(message.isNiagara4Space()), fileInfo.getXmlContent().getBytes(), message.getTargetFileSpace());
        message.addElement(elem);
    }

    public static LicenseSync<CertificateInfo> syncCertificates(CertificateInfo[] current, CertificateInfo[] toInstall) {
        ArrayList<CertificateInfo> toAdd = new ArrayList<CertificateInfo>();
        ArrayList<CertificateInfo> toUpdate = new ArrayList<CertificateInfo>();
        ArrayList<CertificateInfo> toRemove = new ArrayList<CertificateInfo>();
        HashMap<String, CertificateInfo> installedCerts = new HashMap<String, CertificateInfo>();
        for (CertificateInfo cert : current) {
            CertificateInfo loaded = (CertificateInfo)installedCerts.get(cert.vendorCertificate.getVendor());
            if (loaded != null) {
                if (cert.vendorCertificate.getExpiration() > loaded.vendorCertificate.getExpiration()) {
                    toRemove.add(loaded);
                    installedCerts.put(cert.vendorCertificate.getVendor(), cert);
                    continue;
                }
                if (loaded.vendorCertificate.getExpiration() > cert.vendorCertificate.getExpiration()) {
                    toRemove.add(cert);
                    continue;
                }
                if (cert.file.getFileName().equals(cert.getInstalledFileName())) {
                    toRemove.add(loaded);
                    installedCerts.put(cert.vendorCertificate.getVendor(), cert);
                    continue;
                }
                toRemove.add(cert);
                continue;
            }
            installedCerts.put(cert.vendorCertificate.getVendor(), cert);
        }
        for (CertificateInfo cert : toInstall) {
            boolean update;
            CertificateInfo installed = (CertificateInfo)installedCerts.get(cert.vendorCertificate.getVendor());
            if (!PortalLicenseUtil.shouldInstall(cert, installed)) continue;
            boolean bl = update = installed != null;
            if (update) {
                String fileName = cert.getInstalledFileName();
                if (fileName.equals(installed.file.getFileName())) {
                    toUpdate.add(cert);
                    continue;
                }
                toRemove.add(installed);
                toAdd.add(cert);
                continue;
            }
            toAdd.add(cert);
        }
        return new LicenseSync<CertificateInfo>(toAdd, toUpdate, toRemove);
    }

    public static boolean shouldInstall(LicenseInfo portalLicense, LicenseInfo installedLicense) {
        return PortalLicenseUtil.shouldInstall(portalLicense, installedLicense, LicenseInfo.getLocalBrandFeature());
    }

    public static boolean shouldInstall(LicenseInfo portalLicense, LicenseInfo installedLicense, Feature.Brand brandFeature) {
        if (installedLicense == null) {
            return true;
        }
        if (!portalLicense.allowsWbAccess(brandFeature)) {
            return false;
        }
        String portalSig = portalLicense.vendorLicense.getSignature();
        String installedSig = installedLicense.vendorLicense.getSignature();
        if (portalSig == null) {
            return false;
        }
        if (installedSig == null) {
            return true;
        }
        return !portalSig.equals(installedSig);
    }

    public static boolean shouldInstall(CertificateInfo portalCert, CertificateInfo installedCert) {
        String installedSig;
        if (installedCert == null) {
            return true;
        }
        String portalSig = portalCert.vendorCertificate.getSignature();
        return !portalSig.equals(installedSig = installedCert.vendorCertificate.getSignature());
    }

    public static void main(String[] args) {
        System.out.println("connectivity: " + PortalLicenseUtil.checkConnectivity());
        try {
            XElem[] certs = PortalLicenseUtil.getCertificates(args);
            for (int i = 0; i < certs.length; ++i) {
                System.out.println("----- " + i + " -----");
                certs[i].dump();
            }
        }
        catch (Exception e) {
            System.err.println("error retrieving certificates from portal");
            e.printStackTrace();
        }
    }
}

