/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.license;

import com.tridium.platform.license.CertificateInfo;
import com.tridium.sys.license.LicenseUtil;
import com.tridium.sys.license.dom.VendorCertificate;
import javax.baja.file.BIFile;
import javax.baja.sys.BStruct;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;

public class BCertificateSummary
extends BStruct {
    public static final Property vendor = BCertificateSummary.newProperty((int)1, (String)"", null);
    public static final Property certificateGenerated = BCertificateSummary.newProperty((int)1, (long)Long.MIN_VALUE, null);
    public static final Property certificateExpires = BCertificateSummary.newProperty((int)1, (long)Long.MIN_VALUE, null);
    public static final Property certificateSignatureString = BCertificateSummary.newProperty((int)1, (String)"", null);
    public static final Type TYPE = Sys.loadType(BCertificateSummary.class);

    public String getVendor() {
        return this.getString(vendor);
    }

    public void setVendor(String v) {
        this.setString(vendor, v, null);
    }

    public long getCertificateGenerated() {
        return this.getLong(certificateGenerated);
    }

    public void setCertificateGenerated(long v) {
        this.setLong(certificateGenerated, v, null);
    }

    public long getCertificateExpires() {
        return this.getLong(certificateExpires);
    }

    public void setCertificateExpires(long v) {
        this.setLong(certificateExpires, v, null);
    }

    public String getCertificateSignatureString() {
        return this.getString(certificateSignatureString);
    }

    public void setCertificateSignatureString(String v) {
        this.setString(certificateSignatureString, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BCertificateSummary() {
    }

    public BCertificateSummary(String vendor, long certificateGenerated, long certificateExpires, String certificateSignature) {
        this.setVendor(vendor);
        this.setCertificateGenerated(certificateGenerated);
        this.setCertificateExpires(certificateExpires);
        this.setCertificateSignature(certificateSignature);
    }

    public static BCertificateSummary make(XElem xml) {
        String generatedString = xml.get("certGenerated", null);
        long certGenerated = generatedString == null ? Long.MIN_VALUE : LicenseUtil.parseDate((String)generatedString, (boolean)true);
        String expiresString = xml.get("certExpires", null);
        long certExpires = expiresString == null ? Long.MIN_VALUE : LicenseUtil.parseDate((String)expiresString, (boolean)false);
        XElem sigElem = xml.elem("certSignature");
        String certSignature = sigElem == null ? null : sigElem.string();
        return new BCertificateSummary(xml.get("vendor"), certGenerated, certExpires, certSignature);
    }

    public static BCertificateSummary makeEmpty(String vendorName) {
        return new BCertificateSummary(vendorName, Long.MIN_VALUE, Long.MIN_VALUE, null);
    }

    public boolean isEmpty() {
        return this.getCertificateGenerated() == Long.MIN_VALUE;
    }

    public static BCertificateSummary make(BIFile file) throws Exception {
        return BCertificateSummary.make(VendorCertificate.make((BIFile)file));
    }

    public static BCertificateSummary make(VendorCertificate cert) {
        return new BCertificateSummary(cert.getVendor(), cert.getGenerated(), cert.getExpiration(), cert.getSignature());
    }

    public static BCertificateSummary[] make(CertificateInfo[] certs) {
        BCertificateSummary[] result = new BCertificateSummary[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            result[i] = BCertificateSummary.make(certs[i].vendorCertificate);
        }
        return result;
    }

    public static BCertificateSummary[] make(VendorCertificate[] certs) {
        BCertificateSummary[] result = new BCertificateSummary[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            result[i] = BCertificateSummary.make(certs[i]);
        }
        return result;
    }

    public String getCertificateSignature() {
        String result = this.getCertificateSignatureString();
        return result.length() == 0 ? null : result;
    }

    public void setCertificateSignature(String value) {
        this.setCertificateSignatureString(value == null ? "" : value);
    }

    public void update(VendorCertificate cert) {
        if (cert.getGenerated() > this.getCertificateGenerated()) {
            this.setCertificateGenerated(cert.getGenerated());
            this.setCertificateExpires(cert.getExpiration());
            this.setCertificateSignatureString(cert.getSignature());
        }
    }

    public void update(BCertificateSummary summary) {
        if (summary.getCertificateGenerated() > this.getCertificateGenerated()) {
            this.setCertificateGenerated(summary.getCertificateGenerated());
            this.setCertificateExpires(summary.getCertificateExpires());
            this.setCertificateSignatureString(summary.getCertificateSignatureString());
        }
    }

    public XElem asXml() {
        XElem result = new XElem("certSummary");
        result.setAttr("vendor", this.getVendor());
        if (this.getCertificateGenerated() > Long.MIN_VALUE) {
            result.setAttr("certGenerated", LicenseUtil.formatDate((long)this.getCertificateGenerated()));
        }
        if (this.getCertificateExpires() > Long.MIN_VALUE) {
            result.setAttr("certExpires", LicenseUtil.formatDate((long)this.getCertificateExpires()));
        }
        if (this.getCertificateSignature() != null) {
            XElem sigElem = new XElem("certSignature");
            sigElem.addText(this.getCertificateSignature());
            result.addContent((XContent)sigElem);
        }
        return result;
    }
}

