/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.message;

import com.tridium.net.HttpUtil;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import javax.baja.sys.BAbsTime;
import javax.baja.timezone.BTimeZone;
import javax.baja.timezone.DstRule;

public class UpdateTimeMessage
extends XmlResponseMessage {
    private StringBuffer message = new StringBuffer("time?update=true");

    public UpdateTimeMessage(BAbsTime time, String bajaTimeZoneId, BTimeZone osTz, boolean sendFull) {
        if (time != null) {
            this.message.append("&time=").append(time.getMillis());
        }
        if (sendFull && bajaTimeZoneId != null) {
            this.message.append("&bajaTzId=");
            this.message.append(HttpUtil.encodeUrl((String)bajaTimeZoneId));
        }
        if (osTz != null) {
            this.message.append("&tzId=");
            this.message.append(HttpUtil.encodeUrl((String)osTz.getId()));
            if (sendFull) {
                DstRule endRule;
                this.message.append("&tzUtcOffset=");
                if (time != null) {
                    this.message.append(String.valueOf(osTz.getUtcOffset() / 60000));
                } else {
                    this.message.append(String.valueOf(osTz.getUtcOffset() / 60000));
                }
                this.message.append("&dstOffset=");
                if (time != null) {
                    this.message.append(String.valueOf(osTz.getDaylightAdjustment() / 60000));
                } else {
                    this.message.append(String.valueOf(osTz.getDaylightAdjustment() / 60000));
                }
                DstRule startRule = DstRule.getWallTimeRule((DstRule)osTz.getDaylightStartRule(), (int)0, (BTimeZone)osTz);
                if (startRule != null) {
                    this.message.append("&dstStartHour=");
                    this.message.append(String.valueOf(startRule.getTime().getHour()));
                    this.message.append("&dstStartMinute=");
                    this.message.append(String.valueOf(startRule.getTime().getMinute()));
                    this.message.append("&dstStartMonth=");
                    this.message.append(String.valueOf(startRule.getMonth().getOrdinal()));
                    this.message.append("&dstStartDay=");
                    this.message.append(String.valueOf(startRule.getDay()));
                    this.message.append("&dstStartDayMode=");
                    this.message.append(String.valueOf(startRule.getDayMode()));
                    this.message.append("&dstStartWeek=");
                    this.message.append(String.valueOf(startRule.getWeek()));
                    if (startRule.getWeekday() != null) {
                        this.message.append("&dstStartWeekDay=");
                        this.message.append(String.valueOf(startRule.getWeekday().getOrdinal()));
                    }
                }
                if ((endRule = DstRule.getWallTimeRule((DstRule)osTz.getDaylightEndRule(), (int)1, (BTimeZone)osTz)) != null) {
                    this.message.append("&dstEndHour=");
                    this.message.append(String.valueOf(endRule.getTime().getHour()));
                    this.message.append("&dstEndMinute=");
                    this.message.append(String.valueOf(endRule.getTime().getMinute()));
                    this.message.append("&dstEndMonth=");
                    this.message.append(String.valueOf(endRule.getMonth().getOrdinal()));
                    this.message.append("&dstEndDay=");
                    this.message.append(String.valueOf(endRule.getDay()));
                    this.message.append("&dstEndDayMode=");
                    this.message.append(String.valueOf(endRule.getDayMode()));
                    this.message.append("&dstEndWeek=");
                    this.message.append(String.valueOf(endRule.getWeek()));
                    if (endRule.getWeekday() != null) {
                        this.message.append("&dstEndWeekDay=");
                        this.message.append(String.valueOf(endRule.getWeekday().getOrdinal()));
                    }
                }
            }
        }
    }

    @Override
    public String getMessageString() {
        return this.message.toString();
    }

    @Override
    public boolean isStateChangeMessage() {
        return true;
    }
}

