/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.message;

import com.tridium.net.HttpUtil;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.platform.tcpip.BTcpIpAdapterSettings;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import javax.baja.sys.SlotCursor;

public class UpdateTcpIpHostMessage
extends XmlResponseMessage {
    private StringBuffer path = new StringBuffer("tcpip?update=true");

    public UpdateTcpIpHostMessage(BTcpIpHostSettings settings) {
        this.path.append("&hostname=").append(HttpUtil.encodeUrl((String)settings.getHostName()));
        boolean hasIpv6Adapter = false;
        SlotCursor c = settings.getAdapters().getProperties();
        while (c.next(BTcpIpAdapterSettings.class)) {
            BTcpIpAdapterSettings temp = (BTcpIpAdapterSettings)c.get();
            if (!temp.getIsIpv6Supported()) continue;
            hasIpv6Adapter = true;
            break;
        }
        if (hasIpv6Adapter) {
            this.path.append("&niagaraUsesIpv6=").append(settings.getNiagaraUsesIpv6());
        } else {
            this.path.append("&niagaraUsesIpv6=false");
        }
        if (!settings.getUsesAdapterLevelSettings()) {
            this.path.append("&domain=").append(HttpUtil.encodeUrl((String)settings.getDomain()));
            this.path.append("&defaultGateway=").append(HttpUtil.encodeUrl((String)settings.getDefaultGateway()));
            StringBuilder hostsString = new StringBuilder();
            SlotCursor c2 = settings.getDnsHosts().loadSlots().getProperties();
            while (c2.next()) {
                if (hostsString.length() > 0) {
                    hostsString.append("%2C");
                }
                hostsString.append(HttpUtil.encodeUrl((String)c2.get().toString()));
            }
            this.path.append("&dnsHosts=").append(hostsString.toString());
            if (hasIpv6Adapter) {
                this.path.append("&ipv6DefaultGateway=").append(HttpUtil.encodeUrl((String)settings.getIpv6DefaultGateway()));
                StringBuilder ipv6HostsString = new StringBuilder();
                SlotCursor c3 = settings.getIpv6DnsHosts().loadSlots().getProperties();
                while (c3.next()) {
                    if (ipv6HostsString.length() > 0) {
                        ipv6HostsString.append("%2C");
                    }
                    ipv6HostsString.append(HttpUtil.encodeUrl((String)c3.get().toString()));
                }
                this.path.append("&ipv6DnsHosts=").append(ipv6HostsString.toString());
            } else {
                this.path.append("&ipv6DefaultGateway=");
                this.path.append("&ipv6DnsHosts=");
            }
        }
    }

    @Override
    public String getMessageString() {
        return this.path.toString();
    }

    @Override
    public boolean isStateChangeMessage() {
        return true;
    }
}

