/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.file;

import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.FilePathComparator;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;

public class StoreCache {
    private TreeSet<FilePath> pathsNotFound = new TreeSet<FilePath>(FilePathComparator.INSTANCE);
    private TreeMap<FilePath, BIFileStore> storeByPath = new TreeMap(FilePathComparator.INSTANCE);
    private TreeSet<FilePath> completedPaths = new TreeSet<FilePath>(FilePathComparator.INSTANCE);
    public static final int FOUND = 0;
    public static final int NOT_FOUND = 1;
    public static final int UNKNOWN = 2;

    public int getCacheStatus(FilePath path) {
        if (this.pathsNotFound.contains(path)) {
            return 1;
        }
        if (this.storeByPath.containsKey(path)) {
            return 0;
        }
        if (path.getParent() != null && this.completedPaths.contains(path.getParent())) {
            return 1;
        }
        return 2;
    }

    public BIFileStore getStore(FilePath path) {
        return this.storeByPath.get(path);
    }

    public void cacheResult(BIFileStore file) {
        this.storeByPath.put(file.getFilePath(), file);
    }

    public void cacheNotFound(FilePath path) {
        this.pathsNotFound.add(path);
    }

    public void cacheCompleted(FilePath path) {
        this.completedPaths.add(path);
    }

    public void clear() {
        this.pathsNotFound.clear();
        this.storeByPath.clear();
        this.completedPaths.clear();
    }

    public void clear(FilePath pathToClear) {
        TreeSet newPathsNotFound = this.pathsNotFound.stream().filter(path -> !DaemonFileUtil.isSubPath(path, pathToClear)).collect(Collectors.toCollection(() -> new TreeSet<FilePath>(FilePathComparator.INSTANCE)));
        TreeMap newStoreByPath = new TreeMap(FilePathComparator.INSTANCE);
        this.storeByPath.keySet().stream().filter(path -> !DaemonFileUtil.isSubPath(path, pathToClear)).forEach(path -> newStoreByPath.put((FilePath)path, this.storeByPath.get(path)));
        this.completedPaths = this.completedPaths.stream().filter(path -> !DaemonFileUtil.isSubPath(path, pathToClear)).collect(Collectors.toCollection(() -> new TreeSet<FilePath>(FilePathComparator.INSTANCE)));
        this.pathsNotFound = newPathsNotFound;
        this.storeByPath = newStoreByPath;
    }

    public void dump() {
        System.out.println("cached not found:");
        for (FilePath aPathsNotFound : this.pathsNotFound) {
            System.out.println("  " + aPathsNotFound);
        }
        System.out.println("cached stores:");
        for (FilePath filePath : this.storeByPath.keySet()) {
            System.out.println("  " + filePath);
        }
        System.out.println("cached completed:");
        for (FilePath completedPath : this.completedPaths) {
            System.out.println("  " + completedPath);
        }
    }
}

