/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.file;

import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.FilePathComparator;
import com.tridium.platform.daemon.file.StoreCache;
import java.util.Collection;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;

public class FileCache
extends StoreCache {
    private TreeSet<FilePath> pathsNotFound = new TreeSet<FilePath>(FilePathComparator.INSTANCE);
    private TreeMap<FilePath, BIFile> fileByPath = new TreeMap(FilePathComparator.INSTANCE);
    private TreeSet<FilePath> completedPaths = new TreeSet<FilePath>(FilePathComparator.INSTANCE);
    private BFileSpace space;
    public static final int FOUND = 0;
    public static final int NOT_FOUND = 1;
    public static final int UNKNOWN = 2;

    public FileCache(BFileSpace pSpace) {
        this.space = pSpace;
    }

    @Override
    public int getCacheStatus(FilePath path) {
        if (this.pathsNotFound.contains(path)) {
            return 1;
        }
        if (this.fileByPath.containsKey(path)) {
            return 0;
        }
        if (this.completedPaths.contains(path.getParent())) {
            return 1;
        }
        return 2;
    }

    public BIFile getFile(FilePath path) {
        return this.fileByPath.get(path);
    }

    @Override
    public BIFileStore getStore(FilePath path) {
        BIFile file = this.getFile(path);
        return file == null ? null : file.getStore();
    }

    public Collection<BIFile> getCachedFiles() {
        return this.fileByPath.values();
    }

    public Set<FilePath> getCachedFilePaths() {
        return this.fileByPath.keySet();
    }

    @Override
    public void cacheResult(BIFileStore store) {
        this.cacheResult(this.space.makeFile(store));
    }

    public void cacheResult(BIFile file) {
        this.fileByPath.put(file.getFilePath(), file);
    }

    @Override
    public void cacheNotFound(FilePath path) {
        this.pathsNotFound.add(path);
    }

    @Override
    public void cacheCompleted(FilePath path) {
        this.completedPaths.add(path);
    }

    @Override
    public void clear() {
        this.pathsNotFound.clear();
        this.fileByPath.clear();
        this.completedPaths.clear();
    }

    @Override
    public void clear(FilePath pathToClear) {
        TreeSet<FilePath> newPathsNotFound = new TreeSet<FilePath>(FilePathComparator.INSTANCE);
        for (FilePath path : this.pathsNotFound) {
            if (DaemonFileUtil.isSubPath(path, pathToClear)) continue;
            newPathsNotFound.add(path);
        }
        TreeMap<FilePath, BIFile> newFileByPath = new TreeMap<FilePath, BIFile>(FilePathComparator.INSTANCE);
        for (FilePath path : this.fileByPath.keySet()) {
            if (DaemonFileUtil.isSubPath(path, pathToClear)) continue;
            newFileByPath.put(path, this.fileByPath.get(path));
        }
        TreeSet<FilePath> newCompleted = new TreeSet<FilePath>(FilePathComparator.INSTANCE);
        for (FilePath path : this.completedPaths) {
            if (DaemonFileUtil.isSubPath(path, pathToClear)) continue;
            newCompleted.add(path);
        }
        this.pathsNotFound = newPathsNotFound;
        this.fileByPath = newFileByPath;
        this.completedPaths = newCompleted;
    }
}

