/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.authn.AuthenticationClient;
import com.tridium.authn.SimpleAuthenticationClient;
import com.tridium.nre.security.Aes256PasswordManager;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.KeyRing;
import com.tridium.nre.security.NiagaraBasicPermission;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.daemon.BDaemonAccessLevel;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonSessionListener;
import com.tridium.platform.daemon.message.InitializeSessionMessage;
import com.tridium.sys.Nre;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.BHost;
import javax.baja.naming.BIpHost;
import javax.baja.net.HttpConnection;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BICredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.security.PasswordEncodingContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class LocalSessionUtil {
    public static final Object MONITOR = "monitor";
    private static volatile BDaemonSession localDaemonSession;
    public static Logger log;
    private static boolean warnedOnce;
    private static DaemonSessionListener LOCAL_LISTENER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BDaemonSession getLocalSession() {
        Object object;
        BDaemonSession localCopyLocalDaemonSession;
        block45: {
            BSystemPlatformService sys;
            boolean createdSession = false;
            int localPort = -1;
            int localSslPort = -1;
            boolean allowStationRestart = false;
            boolean allowBrandChange = false;
            boolean isLicenseReadonly = false;
            boolean isSystemTimeReadonly = false;
            BDaemonAccessLevel accessLevel = BDaemonAccessLevel.none;
            localCopyLocalDaemonSession = localDaemonSession;
            try {
                if (localCopyLocalDaemonSession == null) {
                    object = MONITOR;
                    synchronized (object) {
                        localCopyLocalDaemonSession = localDaemonSession;
                        if (localCopyLocalDaemonSession == null) {
                            BDaemonSession localDaemonSessionWorking;
                            block44: {
                                localDaemonSessionWorking = null;
                                try {
                                    BIpHost host;
                                    Properties daemonProps;
                                    try {
                                        daemonProps = AccessController.doPrivileged(LocalSessionUtil::getProperties);
                                    }
                                    catch (PrivilegedActionException e) {
                                        throw (IOException)e.getException();
                                    }
                                    localPort = Integer.parseInt(daemonProps.getProperty("port", "3011"));
                                    localSslPort = Integer.parseInt(daemonProps.getProperty("sslPort", "5011"));
                                    String name = "platform";
                                    if (localPort != 3011) {
                                        name = name + ":" + localPort;
                                    }
                                    try {
                                        host = AccessController.doPrivileged(() -> {
                                            boolean ipv6Enabled = Boolean.getBoolean("niagara.ipv6Enabled");
                                            String loopbackAddress = !ipv6Enabled ? System.getProperty("niagara.daemonsession.ipv4Loopback", "127.0.0.1") : System.getProperty("niagara.daemonsession.ipv6Loopback", "::1");
                                            return new BIpHost(loopbackAddress);
                                        });
                                    }
                                    catch (PrivilegedActionException e) {
                                        throw e.getException();
                                    }
                                    localDaemonSessionWorking = new BDaemonSession(name, (BHost)host, localPort);
                                    createdSession = true;
                                    String daemonUser = Nre.args.getOption("daemonspawn", null);
                                    if (daemonUser == null) {
                                        if (Sys.getStation() != null && !warnedOnce) {
                                            warnedOnce = true;
                                            if (Nre.args.hasOption("daemonspawn")) {
                                                log.warning("No credentials available for local platform daemon session");
                                            } else {
                                                log.warning("Local daemon session not available, station not started by niagarad");
                                            }
                                        }
                                        localPort = -1;
                                        localSslPort = -1;
                                        allowStationRestart = false;
                                        allowBrandChange = false;
                                        isLicenseReadonly = false;
                                        isSystemTimeReadonly = false;
                                        accessLevel = BDaemonAccessLevel.none;
                                        if (localDaemonSessionWorking != null) {
                                            localDaemonSessionWorking.sessionCSRFToken = null;
                                            localDaemonSessionWorking.sessionKey = null;
                                            localDaemonSessionWorking = null;
                                        }
                                        break block44;
                                    }
                                    try {
                                        BUsernameAndPassword credentials = LocalSessionUtil.parseUsername(daemonUser);
                                        localDaemonSessionWorking.setCredentials((BICredentials)credentials, true);
                                        localDaemonSessionWorking.setAuthenticationClient((AuthenticationClient)new SimpleAuthenticationClient(credentials));
                                        try {
                                            localDaemonSessionWorking.connect();
                                            allowStationRestart = localDaemonSessionWorking.getHostProperties().getAllowStationRestart();
                                            allowBrandChange = localDaemonSessionWorking.getHostProperties().getAllowBrandChange();
                                            isLicenseReadonly = localDaemonSessionWorking.getHostProperties().getIsLicenseReadonly();
                                            isSystemTimeReadonly = localDaemonSessionWorking.getHostProperties().getIsSystemTimeReadonly();
                                            accessLevel = localDaemonSessionWorking.getHostProperties().getAccessLevel();
                                            if (!localDaemonSessionWorking.getHostProperties().getSslSettings().getSslEnabled()) {
                                                localSslPort = -1;
                                            }
                                            localDaemonSessionWorking.addListener(LOCAL_LISTENER);
                                        }
                                        catch (Exception e) {
                                            localPort = -1;
                                            localSslPort = -1;
                                            allowStationRestart = false;
                                            allowBrandChange = false;
                                            isLicenseReadonly = false;
                                            isSystemTimeReadonly = false;
                                            accessLevel = BDaemonAccessLevel.none;
                                            if (localDaemonSessionWorking != null) {
                                                localDaemonSessionWorking.sessionCSRFToken = null;
                                                localDaemonSessionWorking.sessionKey = null;
                                                localDaemonSessionWorking = null;
                                            }
                                            log.log(Level.SEVERE, "Error connecting to local session", e);
                                        }
                                    }
                                    catch (Exception e) {
                                        localPort = -1;
                                        localSslPort = -1;
                                        allowStationRestart = false;
                                        allowBrandChange = false;
                                        isLicenseReadonly = false;
                                        isSystemTimeReadonly = false;
                                        accessLevel = BDaemonAccessLevel.none;
                                        if (localDaemonSessionWorking != null) {
                                            localDaemonSessionWorking.sessionCSRFToken = null;
                                            localDaemonSessionWorking.sessionKey = null;
                                            localDaemonSessionWorking = null;
                                        }
                                        log.log(Level.SEVERE, "Error setting daemon credentials", e);
                                    }
                                }
                                catch (Exception e) {
                                    localPort = -1;
                                    localSslPort = -1;
                                    allowStationRestart = false;
                                    allowBrandChange = false;
                                    isLicenseReadonly = false;
                                    isSystemTimeReadonly = false;
                                    accessLevel = BDaemonAccessLevel.none;
                                    if (localDaemonSessionWorking != null) {
                                        localDaemonSessionWorking.sessionCSRFToken = null;
                                        localDaemonSessionWorking.sessionKey = null;
                                        localDaemonSessionWorking = null;
                                    }
                                    log.log(Level.SEVERE, "Error getting local instance", e);
                                }
                            }
                            localDaemonSession = localCopyLocalDaemonSession = localDaemonSessionWorking;
                        }
                    }
                }
                if (!createdSession) break block45;
            }
            catch (Throwable throwable) {
                if (createdSession) {
                    BSystemPlatformService sys2;
                    BSystemPlatformService bSystemPlatformService = sys2 = Sys.getStation() == null ? null : (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
                    if (sys2 != null) {
                        sys2.setLocalDaemonPort(localPort);
                        sys2.setLocalDaemonSslPort(localSslPort);
                        sys2.setLocalDaemonAccess(accessLevel);
                        sys2.setAllowStationRestart(allowStationRestart);
                        sys2.setAllowBrandChange(allowBrandChange);
                        sys2.setIsLicenseReadonly(isLicenseReadonly);
                        sys2.setIsSystemTimeReadonly(isSystemTimeReadonly);
                    }
                }
                if ((localCopyLocalDaemonSession = localDaemonSession) != null && (localCopyLocalDaemonSession.sessionCSRFToken == null || localCopyLocalDaemonSession.sessionKey == null)) {
                    Object object2 = MONITOR;
                    synchronized (object2) {
                        localCopyLocalDaemonSession = localDaemonSession;
                        if (localCopyLocalDaemonSession != null && (localCopyLocalDaemonSession.sessionCSRFToken == null || localCopyLocalDaemonSession.sessionKey == null)) {
                            log.fine("Initializing daemon session attributes for local session...");
                            try {
                                localCopyLocalDaemonSession.sendMessage(new InitializeSessionMessage());
                            }
                            catch (Exception e) {
                                log.log(Level.SEVERE, "Failed to initialized local session ", e);
                            }
                        }
                    }
                }
                throw throwable;
            }
            BSystemPlatformService bSystemPlatformService = sys = Sys.getStation() == null ? null : (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            if (sys != null) {
                sys.setLocalDaemonPort(localPort);
                sys.setLocalDaemonSslPort(localSslPort);
                sys.setLocalDaemonAccess(accessLevel);
                sys.setAllowStationRestart(allowStationRestart);
                sys.setAllowBrandChange(allowBrandChange);
                sys.setIsLicenseReadonly(isLicenseReadonly);
                sys.setIsSystemTimeReadonly(isSystemTimeReadonly);
            }
        }
        if ((localCopyLocalDaemonSession = localDaemonSession) != null && (localCopyLocalDaemonSession.sessionCSRFToken == null || localCopyLocalDaemonSession.sessionKey == null)) {
            object = MONITOR;
            synchronized (object) {
                localCopyLocalDaemonSession = localDaemonSession;
                if (localCopyLocalDaemonSession != null && (localCopyLocalDaemonSession.sessionCSRFToken == null || localCopyLocalDaemonSession.sessionKey == null)) {
                    log.fine("Initializing daemon session attributes for local session...");
                    try {
                        localCopyLocalDaemonSession.sendMessage(new InitializeSessionMessage());
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "Failed to initialized local session ", e);
                    }
                }
            }
        }
        return localCopyLocalDaemonSession;
    }

    private static BUsernameAndPassword parseUsername(String daemonUser) throws Exception {
        String[] daemonUserFields = TextUtil.split((String)daemonUser, (char)':');
        ISecurityInfoProvider provider = AccessController.doPrivileged(() -> SecurityInitializer.getInstance().getSecurityInfoProvider());
        String daemonUserPassClearText = Aes256PasswordManager.getManager((KeyRing)provider.getKeyRing()).decrypt(daemonUserFields[0], daemonUserFields[1]);
        String[] userFields = TextUtil.split((String)daemonUserPassClearText, (char)'-');
        try (PasswordEncodingContext context = PasswordEncodingContext.makeKeyring();){
            BUsernameAndPassword bUsernameAndPassword = new BUsernameAndPassword(userFields[0], BPassword.make((String)userFields[1], (Context)context));
            return bUsernameAndPassword;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetLocalSession() {
        Object object = MONITOR;
        synchronized (object) {
            if (localDaemonSession != null) {
                LocalSessionUtil.localDaemonSession.sessionCSRFToken = null;
                LocalSessionUtil.localDaemonSession.sessionKey = null;
                localDaemonSession = null;
            }
            LocalSessionUtil.getLocalSession();
        }
    }

    private static Properties getProperties() throws IOException {
        try {
            NiagaraBasicPermission getPropsPermission = new NiagaraBasicPermission("PLAT_GET_PROPS");
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission((Permission)getPropsPermission);
            }
            return AccessController.doPrivileged(new GetPropertiesPrivilegedAction());
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    public static boolean localDaemonIsAvailable() {
        boolean result = false;
        try {
            BDaemonSession session = LocalSessionUtil.getLocalSession();
            if (session == null) {
                return false;
            }
            try {
                result = AccessController.doPrivileged(() -> {
                    HttpURLConnection conn = (HttpURLConnection)new URL("http", session.getHost().getHostname(), session.getPort(), "/check").openConnection();
                    conn.setRequestProperty("User-Agent", "Niagara/" + AccessController.doPrivileged(() -> Nre.getModuleManager()).getModuleForClass(HttpConnection.class).getVendorVersion());
                    conn.setRequestProperty("Connection", "close");
                    int responseCode = conn.getResponseCode();
                    conn.disconnect();
                    return responseCode < 500;
                });
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        }
        catch (ConnectException session) {
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "error checking for running daemon", e);
        }
        return result;
    }

    static {
        log = Logger.getLogger("platform");
        warnedOnce = false;
        LOCAL_LISTENER = new DaemonSessionListener(){

            @Override
            public void sessionConnected(BDaemonSession session) {
            }

            @Override
            public void sessionDisconnected(BDaemonSession session) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sessionConnectionError(BDaemonSession session, Throwable cause) {
                Object object = MONITOR;
                synchronized (object) {
                    if (session == localDaemonSession && localDaemonSession != null) {
                        localDaemonSession.sessionCSRFToken = null;
                        localDaemonSession.sessionKey = null;
                        localDaemonSession = null;
                    }
                }
            }
        };
    }

    private static class GetPropertiesPrivilegedAction
    implements PrivilegedExceptionAction<Properties> {
        private GetPropertiesPrivilegedAction() {
        }

        @Override
        public Properties run() throws IOException {
            Properties props = new Properties();
            File propsFile = new File(Sys.getNiagaraUserHome() + File.separator + "daemon" + File.separator + "daemon.properties");
            if (propsFile.exists()) {
                try (FileInputStream fis = new FileInputStream(propsFile);){
                    props.load(fis);
                }
            }
            return props;
        }
    }
}

