/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.net.HttpUtil;
import com.tridium.platform.BFilesystemAttributes;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonResponseException;
import com.tridium.platform.daemon.DaemonText;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.file.BDaemonFileStore;
import com.tridium.platform.daemon.file.FileCache;
import com.tridium.platform.daemon.file.FileHeaderInfo;
import com.tridium.platform.daemon.file.FilePathComparator;
import com.tridium.platform.daemon.message.FileHeaderMessage;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.FileTransferMessageElement;
import com.tridium.platform.daemon.message.FilesystemAttributesMessage;
import com.tridium.platform.daemon.message.GetJarContentMessage;
import com.tridium.platform.daemon.task.CancelableDaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.baja.file.BAbstractFile;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.zip.BZipFile;
import javax.baja.file.zip.BZipSpace;
import javax.baja.net.HttpConnection;
import javax.baja.nre.util.FileUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.platform.ICancelHint;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public final class DaemonFileUtil {
    public static final int _PIPE_BUFFER_SIZE = 8192;
    public static final Lexicon lex = Lexicon.make((String)"platform");
    public static final Logger log = Logger.getLogger("platform.daemonSession");
    public static final ThreadLocal<DecimalFormat> kbFormat = ThreadLocal.withInitial(() -> new DecimalFormat(lex.getText("Formats.kb")));
    public static final ThreadLocal<DecimalFormat> byteFormat = ThreadLocal.withInitial(() -> new DecimalFormat(lex.getText("Formats.bytes")));
    public static final ThreadLocal<DecimalFormat> mbFormat = ThreadLocal.withInitial(() -> new DecimalFormat(lex.getText("Formats.mb")));

    private DaemonFileUtil() {
    }

    public static void deleteFile(BIFile file) throws Exception {
        BFileSpace space = (BFileSpace)file.getSpace();
        if (space instanceof BDaemonFileSpace) {
            BDaemonFileSpace daemonFileSpace = (BDaemonFileSpace)space;
            DaemonFileUtil.transfer(daemonFileSpace.getDaemonSession(), FileTransferMessage.makeDelete(file.getFilePath(), daemonFileSpace), null);
        } else {
            file.delete();
        }
    }

    public static String fileSize(long size) {
        if (size < 0L) {
            return "";
        }
        if (size < 1024L) {
            return byteFormat.get().format(size);
        }
        return kbFormat.get().format((double)size / 1024.0);
    }

    public static void pipe(InputStream in, OutputStream out, TransferStatus status) throws IOException {
        int len = 8192;
        byte[] buf = new byte[len];
        long transferred = 0L;
        while (true) {
            if (status.isCanceled()) {
                throw new ICancelHint.CanceledException();
            }
            int n = in.read(buf, 0, len);
            if (n < 0) break;
            out.write(buf, 0, n);
            status.updateBytesWritten(transferred += (long)n);
        }
    }

    public static BIFile findFile(BFileSpace space, FilePath path, FileCache cache) {
        if (cache == null) {
            return space.findFile(path);
        }
        switch (cache.getCacheStatus(path)) {
            case 0: {
                return cache.getFile(path);
            }
            case 1: {
                return null;
            }
        }
        BIFile result = space.findFile(path);
        if (result == null) {
            cache.cacheNotFound(path);
        } else {
            cache.cacheResult(result);
        }
        return result;
    }

    public static long getCrc(BIFile file) {
        try {
            if (file instanceof BAbstractFile) {
                return ((BAbstractFile)file).getCrc();
            }
            return -1L;
        }
        catch (IOException ioe) {
            throw new LocalizableRuntimeException("platform", "FileUtilities.exception.readCrc", (Throwable)ioe);
        }
    }

    public static FileHeaderInfo getFileHeaderInfo(BDaemonSession session, FileHeaderMessage message) throws ConnectException, AuthenticationException {
        String crc;
        long lastModified;
        String contentLengthString;
        String messageURI = session.prepareMessageUri(message);
        HttpConnection conn = session.getConnection(messageURI, "HEAD", BDaemonSession.DEFAULT_TIMEOUT);
        if (conn == null) {
            return null;
        }
        FileHeaderInfo result = new FileHeaderInfo();
        String contentType = conn.getResponseHeader("Content-Type");
        if (contentType != null) {
            result.setContentType(contentType);
        }
        if ((contentLengthString = conn.getResponseHeader("Content-Length")) != null) {
            result.setContentLength(Long.parseLong(contentLengthString));
        }
        if ((lastModified = conn.getResponseHeaderDate("Last-Modified")) > 0L) {
            result.setLastModified(BAbsTime.make((long)lastModified));
        }
        if ((crc = conn.getResponseHeader("File-CRC")) != null) {
            result.setCrc(Long.parseLong(crc));
        }
        conn.close();
        return result;
    }

    public static BFilesystemAttributes getFilesystemAttributes(BDaemonSession session, FilePath path) throws Exception {
        InputStream in = session.getInputStream(new FilesystemAttributesMessage(session.getFileSpace(), path));
        XElem elem = XParser.make((InputStream)in).parse();
        return new BFilesystemAttributes(elem.getl("totalKb", -1L), elem.getl("freeKb", -1L), elem.getl("maxFileCount", -1L), elem.getl("currentFileCount", -1L));
    }

    public static FilePath getNormalizedFilePath(BIFileStore store) {
        if (store.getFilePath().isLocalAbsolute()) {
            return store.getFilePath();
        }
        if (store.getFileSpace() instanceof BDaemonFileSpace) {
            FilePath result = ((BDaemonFileSpace)store.getFileSpace()).getAltPath(store.getFilePath());
            if (result != null) {
                return result;
            }
        } else if (store instanceof BLocalFileStore) {
            return BFileSystem.INSTANCE.localFileToPath(((BLocalFileStore)store).getLocalFile());
        }
        return store.getFilePath();
    }

    public static InputStream getZipStream(BIFile file, FilePath entryPath) throws IOException {
        ZipEntry entry;
        if (file.getStore() instanceof BLocalFileStore) {
            BZipFile zipFile = file instanceof BZipFile ? (BZipFile)file : new BZipFile(file.getStore());
            BZipSpace space = (BZipSpace)zipFile.open();
            BIFile zipEntry = space.findFile(entryPath);
            if (zipEntry == null) {
                try {
                    zipFile.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
            return new ZipEntryInputStream(zipFile, zipEntry);
        }
        if (file.getStore() instanceof BDaemonFileStore) {
            BDaemonFileStore store = (BDaemonFileStore)file.getStore();
            return store.getDaemonSession().getInputStream(new GetJarContentMessage(file.getFilePath(), entryPath));
        }
        ZipInputStream in = new ZipInputStream(file.getInputStream());
        while ((entry = in.getNextEntry()) != null) {
            if (!entry.getName().equalsIgnoreCase(entryPath.getBody())) continue;
            return in;
        }
        in.close();
        return null;
    }

    public static boolean isSubPath(FilePath p1, FilePath p2) {
        return DaemonFileUtil.pathsMatch(p1, p2, p2.depth());
    }

    public static BIFile[] listFiles(BDirectory dir, FileCache cache) {
        BIFile[] result = dir.listFiles();
        if (cache != null) {
            for (BIFile file : result) {
                cache.cacheResult(file);
            }
        }
        return result;
    }

    public static String addSessionCSRFToken(String uri, BDaemonSession daemonSession) {
        StringBuilder messageUri = new StringBuilder(uri);
        if (daemonSession.getSessionCSRFToken() != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Adding CSRF token to File Transfer Message '" + TextUtil.truncate((String)uri, (int)25) + "...'");
            }
            if (!uri.contains("?")) {
                messageUri.append("?");
            } else {
                messageUri.append("&");
            }
            messageUri.append("csrfToken").append("=").append(HttpUtil.encodeUrl((String)daemonSession.getSessionCSRFToken()));
        } else if (daemonSession.getHostProperties().isNiagara4() && new Version(daemonSession.getHostProperties().getDaemonVersion()).compareTo(new Version("4.4.62.0")) >= 0) {
            log.severe("Sending Daemon Message '" + TextUtil.truncate((String)uri, (int)15) + "...' that changes state without CSRF token, failure likely!");
            if (log.isLoggable(Level.ALL)) {
                Thread.dumpStack();
            }
        }
        return messageUri.toString();
    }

    public static boolean pathsMatch(FilePath p1, FilePath p2, int comparisonDepth) {
        if (comparisonDepth < 0) {
            return false;
        }
        if (p1.getAbsoluteMode() != p2.getAbsoluteMode()) {
            return false;
        }
        if (p1.depth() < comparisonDepth) {
            return false;
        }
        if (p2.depth() < comparisonDepth) {
            return false;
        }
        for (int i = 0; i < comparisonDepth; ++i) {
            if (p1.nameAt(i).equals(p2.nameAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean transfer(BDaemonSession session, FileTransferMessage message, ICancelHint cancelHint) throws ConnectException, AuthenticationException {
        return DaemonFileUtil.transfer(session, message, cancelHint, DaemonSessionTaskListener.NULL_TASK_LISTENER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized boolean transfer(BDaemonSession session, FileTransferMessage message, ICancelHint cancelHint, DaemonSessionTaskListener taskListener) throws ConnectException, AuthenticationException {
        if (DaemonFileUtil.canceled(cancelHint)) {
            throw new ICancelHint.CanceledException();
        }
        allDelete = message.getDeleteCount() != 0 && message.getTransferCount() == 0;
        task = new CancelableDaemonSessionTask(DaemonFileUtil.lex, allDelete != false ? "DaemonSession.deleteFiles.taskTitle" : "DaemonSession.transferFiles.taskTitle", allDelete != false ? "DaemonSession.deleteFiles.taskMessage" : "DaemonSession.transferFiles.taskMessage", 100, cancelHint);
        if (taskListener == null) {
            taskListener = DaemonSessionTaskListener.NULL_TASK_LISTENER;
        }
        mustCommit = (transactionId = message.getTransactionId()) != null;
        first = true;
        message.initProgress();
        task.setProgress(message.getProgress());
        taskListener.taskStarted(task);
        startTransfer = Instant.now();
        bytesTransferred = 0L;
        connection = null;
        elems = message.getElements(session);
lbl17:
        // 3 sources

        for (FileTransferMessageElement elem : elems) {
            if (DaemonFileUtil.canceled(task)) {
                DaemonFileUtil.sendAbort(session, message, connection, task, taskListener);
                message.getCache().clear();
                throw new ICancelHint.CanceledException();
            }
            uri = elem.getFullUri(message, first);
            first = false;
            if (elem.getRequestMethod().equals("POST")) {
                task.setMessage(DaemonFileUtil.lex.getText("FileTransferMessageElement.progress", new Object[]{elem.getFilePath().getBody()}));
            } else if (elem.getRequestMethod().equals("DELETE")) {
                task.setMessage(DaemonFileUtil.lex.getText("DeleteFileTransferMessageElement.progress", new Object[]{elem.getFilePath().getBody()}));
            }
            taskListener.taskUpdated(task);
            flags = elem.getRequestMethod().equals("POST") != false ? 32 : 0;
            fileSize = elem.getSize();
            timeout = BDaemonSession.DEFAULT_TIMEOUT;
            if ("bog".equalsIgnoreCase(FileUtil.getExtension((String)elem.getFilePath().getName()))) {
                multiplier = (int)Math.floor((double)elem.getSize() / 10240.0);
                timeout = multiplier * 15000;
                if (timeout < 60000) {
                    timeout = 60000;
                }
                if (DaemonFileUtil.log.isLoggable(Level.FINEST)) {
                    DaemonFileUtil.log.finest("transferring bog file, overriding default session timeout of " + BDaemonSession.DEFAULT_TIMEOUT + " with " + timeout);
                }
            }
            if ((connection = session.getConnection(uri = DaemonFileUtil.addSessionCSRFToken(uri, session), elem.getRequestMethod(), fileSize, timeout, connection, flags)) != null) ** GOTO lbl65
            DaemonFileUtil.sendAbort(session, message, connection, task, taskListener);
            message.getCache().clear();
            multiplier = 0;
            taskListener.taskFinished(task);
            ** GOTO lbl58
        }
        ** GOTO lbl145
        {
            block45: {
                block41: {
                    block44: {
                        block42: {
                            block43: {
                                catch (Throwable var28_44) {
                                    taskListener.taskFinished(task);
                                    transferLogger = Logger.getLogger("platform.daemonSession.transfer");
                                    if (transferLogger.isLoggable(Level.INFO) == false) throw var28_44;
                                    transferDuration = Duration.between(startTransfer, Instant.now());
                                    if (bytesTransferred <= 0L) throw var28_44;
                                    if (transferDuration.toMillis() <= 0L) throw var28_44;
                                    transferLogger.log(Level.INFO, String.format("%,d bytes transferred, Transfer time: %s, Transfer Speed: %,.0f bps", new Object[]{bytesTransferred, transferDuration.toString(), (double)bytesTransferred * 8000.0 / (double)transferDuration.toMillis()}));
                                    throw var28_44;
                                }
lbl58:
                                // 1 sources

                                transferLogger = Logger.getLogger("platform.daemonSession.transfer");
                                if (transferLogger.isLoggable(Level.INFO) == false) return (boolean)multiplier;
                                transferDuration = Duration.between(startTransfer, Instant.now());
                                if (bytesTransferred <= 0L) return (boolean)multiplier;
                                if (transferDuration.toMillis() <= 0L) return (boolean)multiplier;
                                transferLogger.log(Level.INFO, String.format("%,d bytes transferred, Transfer time: %s, Transfer Speed: %,.0f bps", new Object[]{bytesTransferred, transferDuration.toString(), (double)bytesTransferred * 8000.0 / (double)transferDuration.toMillis()}));
                                return (boolean)multiplier;
lbl65:
                                // 1 sources

                                if (transactionId == null && (transactionId = connection.getResponseHeader("transactionId")) != null) {
                                    message.setTransactionId(transactionId);
                                    mustCommit = true;
                                }
                                if (elem.getRequestMethod().equals("POST")) {
                                    buf = new byte[FileUtil.getFileBufferSize((long)elem.getSize())];
                                    try {
                                        in = elem.getStream();
                                        message.updateProgress(elem, 0);
                                        task.setProgress(message.getProgress());
                                        taskListener.taskUpdated(task);
                                        if (DaemonFileUtil.canceled(task)) {
                                            try {
                                                try {
                                                    connection.close();
                                                    connection = null;
                                                }
                                                catch (Exception var24_36) {
                                                    connection = null;
                                                }
                                            }
                                            catch (Throwable var25_38) {
                                                connection = null;
                                                throw var25_38;
                                            }
                                            DaemonFileUtil.sendAbort(session, message, connection, task, taskListener);
                                            message.getCache().clear();
                                            in.close();
                                            throw new ICancelHint.CanceledException();
                                        }
                                        while ((nRead = in.read(buf, 0, buf.length)) > 0) {
                                            if (DaemonFileUtil.canceled(task)) {
                                                try {
                                                    try {
                                                        connection.close();
                                                        connection = null;
                                                    }
                                                    catch (Exception var24_37) {
                                                        connection = null;
                                                    }
                                                }
                                                catch (Throwable var26_40) {
                                                    connection = null;
                                                    throw var26_40;
                                                }
                                                DaemonFileUtil.sendAbort(session, message, connection, task, taskListener);
                                                message.getCache().clear();
                                                throw new ICancelHint.CanceledException();
                                            }
                                            connection.getOutputStream().write(buf, 0, nRead);
                                            bytesTransferred += (long)nRead;
                                            message.updateProgress(elem, nRead);
                                            task.setProgress(message.getProgress());
                                            taskListener.taskUpdated(task);
                                        }
                                        in.close();
                                        rc = connection.postComplete();
                                        if (rc != 201) {
                                            try {
                                                responseElem = XParser.make((InputStream)connection.getInputStream()).parse();
                                                throw new DaemonResponseException(rc, session.getAddressString(), new DaemonText((XElem)responseElem).message);
                                            }
                                            catch (Exception ioe) {
                                                throw new LocalizableRuntimeException("platform", "DaemonSession.exception.write", new Object[]{session.getAddressString(), elem.getRequestMethod(), uri});
                                            }
                                        }
                                        BDaemonSession.readFully(connection);
                                        if (transactionId != null || (transactionId = connection.getResponseHeader("transactionId")) == null) ** GOTO lbl139
                                        message.setTransactionId(transactionId);
                                        mustCommit = true;
                                    }
                                    catch (IOException ioe) {
                                        DaemonFileUtil.log.fine("transfer(FileTransferMessage) closes connection");
                                        if (connection != null) {
                                            connection.close();
                                        }
                                        throw new LocalizableRuntimeException("platform", "DaemonSession.exception.write", new Object[]{session.getAddressString(), elem.getRequestMethod(), uri}, (Throwable)ioe);
                                    }
                                } else {
                                    message.updateProgress(elem, 0);
                                    task.setProgress(message.getProgress());
                                    taskListener.taskUpdated(task);
                                    BDaemonSession.readFully(connection);
                                }
lbl139:
                                // 3 sources

                                if (mustCommit) ** GOTO lbl17
                                removed = new TreeSet<FilePath>(FilePathComparator.INSTANCE);
                                transferred = new TreeSet<FilePath>(FilePathComparator.INSTANCE);
                                elem.updateTransferInfo(removed, transferred);
                                session.getFileSpace().notify(removed, transferred);
                                ** GOTO lbl17
lbl145:
                                // 1 sources

                                message.getCache().clear();
                                if (!mustCommit) break block41;
                                task.setIsCancelEnabled(false);
                                taskListener.taskUpdated(task);
                                if (!DaemonFileUtil.sendCommit(session, message, connection, task, taskListener)) break block42;
                                removed = new TreeSet<FilePath>(FilePathComparator.INSTANCE);
                                transferred = new TreeSet<FilePath>(FilePathComparator.INSTANCE);
                                for (FileTransferMessageElement elem : elems) {
                                    elem.updateTransferInfo(removed, transferred);
                                }
                                session.getFileSpace().notify(removed, transferred);
                                flags = true;
                                if (connection == null) break block43;
                                connection.close();
                            }
                            taskListener.taskFinished(task);
                            transferLogger = Logger.getLogger("platform.daemonSession.transfer");
                            if (transferLogger.isLoggable(Level.INFO) == false) return flags;
                            transferDuration = Duration.between(startTransfer, Instant.now());
                            if (bytesTransferred <= 0L) return flags;
                            if (transferDuration.toMillis() <= 0L) return flags;
                            transferLogger.log(Level.INFO, String.format("%,d bytes transferred, Transfer time: %s, Transfer Speed: %,.0f bps", new Object[]{bytesTransferred, transferDuration.toString(), (double)bytesTransferred * 8000.0 / (double)transferDuration.toMillis()}));
                            return flags;
                        }
                        var15_14 = false;
                        if (connection == null) break block44;
                        connection.close();
                    }
                    taskListener.taskFinished(task);
                    transferLogger = Logger.getLogger("platform.daemonSession.transfer");
                    if (transferLogger.isLoggable(Level.INFO) == false) return var15_14;
                    transferDuration = Duration.between(startTransfer, Instant.now());
                    if (bytesTransferred <= 0L) return var15_14;
                    if (transferDuration.toMillis() <= 0L) return var15_14;
                    transferLogger.log(Level.INFO, String.format("%,d bytes transferred, Transfer time: %s, Transfer Speed: %,.0f bps", new Object[]{bytesTransferred, transferDuration.toString(), (double)bytesTransferred * 8000.0 / (double)transferDuration.toMillis()}));
                    return var15_14;
                }
                try {
                    var15_15 = true;
                    if (connection == null) break block45;
                }
                catch (Throwable var27_43) {}
                {
                    if (connection == null) throw var27_43;
                    connection.close();
                    throw var27_43;
                }
                connection.close();
            }
            taskListener.taskFinished(task);
            transferLogger = Logger.getLogger("platform.daemonSession.transfer");
            if (transferLogger.isLoggable(Level.INFO) == false) return var15_15;
            transferDuration = Duration.between(startTransfer, Instant.now());
            if (bytesTransferred <= 0L) return var15_15;
            if (transferDuration.toMillis() <= 0L) return var15_15;
            transferLogger.log(Level.INFO, String.format("%,d bytes transferred, Transfer time: %s, Transfer Speed: %,.0f bps", new Object[]{bytesTransferred, transferDuration.toString(), (double)bytesTransferred * 8000.0 / (double)transferDuration.toMillis()}));
            return var15_15;
        }
    }

    private static boolean canceled(ICancelHint i) {
        return i != null && i.isCanceled();
    }

    private static boolean sendAbort(BDaemonSession session, FileTransferMessage message, HttpConnection connection, CancelableDaemonSessionTask task, DaemonSessionTaskListener taskListener) throws ConnectException, AuthenticationException {
        String uri = message.getAbortUri();
        if (uri == null) {
            return true;
        }
        try {
            uri = DaemonFileUtil.addSessionCSRFToken(uri, session);
            connection = session.getConnection(uri, "GET", -1L, BDaemonSession.DEFAULT_TIMEOUT, connection);
        }
        catch (IOException ioe) {
            log.fine("sendAbort closes connection");
            if (connection != null) {
                connection.close();
            }
            throw new LocalizableRuntimeException("platform", "DaemonSession.exception.write", new Object[]{session.getAddressString(), "GET", uri}, (Throwable)ioe);
        }
        return true;
    }

    private static boolean sendCommit(BDaemonSession session, FileTransferMessage message, HttpConnection connection, CancelableDaemonSessionTask task, DaemonSessionTaskListener taskListener) throws ConnectException, AuthenticationException {
        String uri = message.getCommitUri();
        InputStream in = null;
        if (uri == null) {
            if (message.getTransactionId() == null) {
                log.warning("attempt to commit file transfer that is not transacted");
            } else {
                log.warning("attempt to commit file transfer that is autocommit");
            }
            return false;
        }
        try {
            uri = DaemonFileUtil.addSessionCSRFToken(uri, session);
            in = session.getInputStream(uri, 0, "text/xml", connection);
            if (in == null) {
                return true;
            }
            XParser parser = XParser.make((InputStream)in);
            while (parser.next() != -1) {
                if (parser.type() == 1) {
                    XElem logEntry = null;
                    switch (parser.elem().name()) {
                        case "message": 
                        case "warning": 
                        case "trace": {
                            logEntry = parser.parseCurrent(false);
                            break;
                        }
                        case "error": {
                            logEntry = parser.parseCurrent(false);
                            int code = logEntry.geti("code", 500);
                            DaemonText daemonText = new DaemonText(logEntry);
                            if (daemonText.lexModule == null) {
                                String text = daemonText.message;
                                if (text == null) {
                                    text = session.getAddressString() + " " + "GET" + " " + uri;
                                }
                                if (code < 400) break;
                                throw new LocalizableRuntimeException("platform", "DaemonSession.exception.commit", new Object[]{text});
                            }
                            if (code < 300) break;
                            throw new LocalizableRuntimeException(daemonText.lexModule, daemonText.lexKey, daemonText.lexArgs);
                        }
                    }
                    if (logEntry == null) continue;
                    DaemonText daemonText = new DaemonText(logEntry);
                    task.setMessage(daemonText.message);
                    taskListener.taskUpdated(task);
                    continue;
                }
                if (parser.type() != 2 || parser.depth() > 1) continue;
                break;
            }
        }
        catch (IOException ioe) {
            log.fine("sendCommit closes connection");
            try {
                if (in != null) {
                    in.close();
                } else if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new LocalizableRuntimeException("platform", "DaemonSession.exception.commit", new Object[]{session.getAddressString(), "GET", uri}, (Throwable)ioe);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
        return true;
    }

    public static interface TransferStatus
    extends ICancelHint {
        public void updateBytesWritten(long var1);
    }

    public static class ZipEntryInputStream
    extends InputStream {
        private final InputStream stream;
        private final BZipFile zipFile;

        public ZipEntryInputStream(BZipFile pZipFile, BIFile pZipEntryFile) throws IOException {
            this.zipFile = pZipFile;
            this.stream = pZipEntryFile.getInputStream();
        }

        @Override
        public int read() throws IOException {
            return this.stream.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.stream.read(b);
        }

        @Override
        public int read(byte[] b, int offset, int len) throws IOException {
            return this.stream.read(b, offset, len);
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
            this.zipFile.close();
        }
    }
}

