/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.command;

import com.tridium.platform.command.BIPlatformCommand;
import java.security.AccessController;
import java.util.function.Predicate;
import javax.baja.sys.BSingleton;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BAbstractPlatformCommand
extends BSingleton
implements BIPlatformCommand {
    public static final Type TYPE = Sys.loadType(BAbstractPlatformCommand.class);
    public static final Predicate<String> NOT_EMPTY_STRING = value -> value != null && value.length() > 0;
    public static final Predicate<char[]> NOT_EMPTY_CHARS = value -> value != null && ((char[])value).length > 0;

    public Type getType() {
        return TYPE;
    }

    @Override
    public String getLicenseVendor() {
        return null;
    }

    @Override
    public String getLicenseFeature() {
        return null;
    }

    @Override
    public boolean includeInCommandListing() {
        return true;
    }

    protected boolean promptBoolean(String text) {
        String result = this.promptString(text);
        return result.charAt(0) == 'Y' || result.charAt(0) == 'y';
    }

    protected char[] promptPassword(String text) {
        return this.promptPassword(text, NOT_EMPTY_CHARS);
    }

    protected char[] promptPassword(String text, Predicate<char[]> validator) {
        try {
            char[] line = AccessController.doPrivileged(() -> System.console().readPassword(text, new Object[0]));
            while (!validator.test(line)) {
                line = AccessController.doPrivileged(() -> System.console().readPassword(text, new Object[0]));
            }
            return line;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    protected String promptString(String text) {
        return this.promptString(text, NOT_EMPTY_STRING);
    }

    protected String promptString(String text, Predicate<String> validator) {
        try {
            String line = null;
            while (!validator.test(line)) {
                line = AccessController.doPrivileged(() -> System.console().readLine(text, new Object[0]));
            }
            return line;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    protected static void println(String format, Object ... args) {
        if (args.length == 0) {
            System.out.println(format);
        } else {
            System.out.println(String.format(format, args));
        }
    }
}

