/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipArchiveReader {
    private ZipInputStream in;
    private boolean isVerbose = false;

    public ZipArchiveReader(File archiveFile, boolean isVerbose) throws IOException {
        if (!archiveFile.exists()) {
            throw new IllegalArgumentException("File does not exist: " + archiveFile);
        }
        if (archiveFile.isDirectory()) {
            throw new IllegalArgumentException("File is directory: " + archiveFile);
        }
        this.in = new ZipInputStream(new FileInputStream(archiveFile));
        this.isVerbose = isVerbose;
        if (isVerbose) {
            System.out.println("archive file name: " + archiveFile);
        }
    }

    public void extractAll(File dir) throws IOException {
        ZipEntry entry;
        if (!dir.exists()) {
            throw new IllegalArgumentException("Path does not exist " + dir);
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Path not a directory: " + dir);
        }
        byte[] b = new byte[65000];
        while ((entry = this.in.getNextEntry()) != null) {
            String name = dir.getPath() + "/" + entry.getName();
            String parentDir = name.substring(0, name.lastIndexOf(47));
            new File(parentDir).mkdirs();
            if (entry.isDirectory()) {
                File newDir = new File(name);
                newDir.mkdir();
                if (this.isVerbose) {
                    System.out.println("ZipArchiveReader: creating dir " + name);
                }
            } else {
                FileOutputStream out = new FileOutputStream(new File(name));
                if (this.isVerbose) {
                    System.out.println("ZipArchiveReader: expanding " + name);
                }
                int bytesRead = this.in.read(b);
                while (bytesRead >= 0) {
                    out.write(b, 0, bytesRead);
                    bytesRead = this.in.read(b);
                }
                out.flush();
                out.close();
            }
            this.in.closeEntry();
        }
    }
}

