/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform;

import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.sys.license.Brand;
import com.tridium.sys.license.dom.CertificateDatabase;
import com.tridium.sys.license.dom.LicenseDatabase;
import javax.baja.file.BIFileSpace;
import javax.baja.file.FilePath;
import javax.baja.util.Lexicon;

public class SystemFilePaths {
    private static final FilePath CERTS_PATH_AX = new FilePath("!certificates");
    private static final FilePath LEXICON_HOME_PATH_AX = new FilePath("!lexicon");
    private static final FilePath LICENSES_DIR_PATH_AX = new FilePath("!licenses");
    private static FilePath BRAND_PROPS_PATH_AX = new FilePath("!lib/brand.properties");
    private static final FilePath STATIONS_DIR_PATH = new FilePath("~stations");
    private static final FilePath STATIONS_DIR_PATH_AX = new FilePath("!stations");
    private static final FilePath PLATFORM_BOG_PATH = new FilePath("!defaults/platform.bog");
    private static final FilePath PLATFORM_BOG_PATH_AX = new FilePath("!lib/platform.bog");
    private static final FilePath PLATFORM_AUDIT_DIR_PATH = new FilePath("~audits");
    private static final FilePath FIPS_COOKIE_DIR_PATH = new FilePath("!security/fips/cookies");
    private static final FilePath SW_SIGNATURES = new FilePath("!sw/signing/signers");

    public static FilePath getPlatformBogPath() {
        return SystemFilePaths.getPlatformBogPath(true);
    }

    public static FilePath getPlatformBogPath(boolean forNiagara4) {
        return forNiagara4 ? PLATFORM_BOG_PATH : PLATFORM_BOG_PATH_AX;
    }

    public static FilePath getPlatformBogPath(BIFileSpace space) {
        return BDaemonFileSpace.isAxDaemonFileSpace(space) ? PLATFORM_BOG_PATH_AX : PLATFORM_BOG_PATH;
    }

    public static FilePath getStationsDirPath() {
        return SystemFilePaths.getStationsDirPath(true);
    }

    public static FilePath getStationsDirPath(boolean forNiagara4) {
        return forNiagara4 ? STATIONS_DIR_PATH : STATIONS_DIR_PATH_AX;
    }

    public static FilePath getStationsDirPath(BIFileSpace space) {
        return BDaemonFileSpace.isAxDaemonFileSpace(space) ? STATIONS_DIR_PATH_AX : STATIONS_DIR_PATH;
    }

    public static FilePath translateStationPath(FilePath path, String stationName, boolean forNiagara4) {
        if (path.isStationHomeAbsolute() || path.isProtectedStationHomeAbsolute()) {
            FilePath result = SystemFilePaths.getStationsDirPath(forNiagara4).merge(stationName);
            if (path.isStationHomeAbsolute() && forNiagara4) {
                result = result.merge("shared");
            }
            for (int i = 0; i < path.depth(); ++i) {
                result = result.merge(path.nameAt(i));
            }
            return result;
        }
        return path;
    }

    public static FilePath getLicensesDirPath() {
        return SystemFilePaths.getLicensesDirPath(true);
    }

    public static FilePath getLicensesDirPath(boolean forNiagara4) {
        return forNiagara4 ? LicenseDatabase.LICENSES_DIR_PATH : LICENSES_DIR_PATH_AX;
    }

    public static FilePath getLicensesDirPath(BIFileSpace space) {
        return BDaemonFileSpace.isAxDaemonFileSpace(space) ? LICENSES_DIR_PATH_AX : LicenseDatabase.LICENSES_DIR_PATH;
    }

    public static FilePath getCertificatesDirPath(boolean forNiagara4) {
        return forNiagara4 ? CertificateDatabase.CERTS_PATH : CERTS_PATH_AX;
    }

    public static FilePath getCertificatesDirPath(BIFileSpace space) {
        return BDaemonFileSpace.isAxDaemonFileSpace(space) ? CERTS_PATH_AX : CertificateDatabase.CERTS_PATH;
    }

    public static FilePath getCertificatesDirPath() {
        return SystemFilePaths.getCertificatesDirPath(true);
    }

    public static FilePath getBrandPropsPath() {
        return SystemFilePaths.getBrandPropsPath(true);
    }

    public static FilePath getBrandPropsPath(boolean isNiagara4) {
        return isNiagara4 ? Brand.BRAND_PROPS_PATH : BRAND_PROPS_PATH_AX;
    }

    public static FilePath getBrandPropsPath(BIFileSpace space) {
        return BDaemonFileSpace.isAxDaemonFileSpace(space) ? BRAND_PROPS_PATH_AX : Brand.BRAND_PROPS_PATH;
    }

    public static FilePath getLexiconHomePath() {
        return SystemFilePaths.getLexiconHomePath(true);
    }

    public static FilePath getLexiconHomePath(boolean forNiagara4) {
        return forNiagara4 ? Lexicon.LEXICON_HOME_PATH : LEXICON_HOME_PATH_AX;
    }

    public static FilePath getLexiconHomePath(BIFileSpace space) {
        return BDaemonFileSpace.isAxDaemonFileSpace(space) ? LEXICON_HOME_PATH_AX : Lexicon.LEXICON_HOME_PATH;
    }

    public static FilePath getPlatformAuditDirPath() {
        return PLATFORM_AUDIT_DIR_PATH;
    }

    public static FilePath getFipsCookieDirPath() {
        return FIPS_COOKIE_DIR_PATH;
    }

    public static FilePath getSwSignatures() {
        return SW_SIGNATURES;
    }
}

