/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform;

import java.net.ConnectException;
import java.text.MessageFormat;
import javax.baja.sys.Context;
import javax.baja.sys.Localizable;
import javax.baja.util.Lexicon;

public class LocalizableConnectException
extends ConnectException
implements Localizable {
    private String lexiconModule;
    private String lexiconKey;
    private Object[] lexiconArgs;

    public LocalizableConnectException(String lexiconModule, String lexiconKey, Object[] lexiconArgs) {
        super(LocalizableConnectException.format(lexiconModule, lexiconKey, lexiconArgs, null));
        this.lexiconModule = lexiconModule;
        this.lexiconKey = lexiconKey;
        this.lexiconArgs = lexiconArgs;
    }

    public LocalizableConnectException(String lexiconModule, String lexiconKey) {
        this(lexiconModule, lexiconKey, null);
    }

    public LocalizableConnectException(Lexicon lexicon, String lexiconKey) {
        this(lexicon.module.getModuleName(), lexiconKey, null);
    }

    public String getLexiconModule() {
        return this.lexiconModule;
    }

    public String getLexiconKey() {
        return this.lexiconKey;
    }

    public Object[] getLexiconArguments() {
        return this.lexiconArgs;
    }

    public String toString(Context context) {
        return LocalizableConnectException.format(this.lexiconModule, this.lexiconKey, this.lexiconArgs, context);
    }

    public static String format(String lexiconModule, String lexiconKey, Object[] lexiconArgs, Context context) {
        try {
            String value = Lexicon.make((String)lexiconModule, (Context)context).get(lexiconKey, null);
            if (value != null) {
                return MessageFormat.format(value, lexiconArgs);
            }
            StringBuffer s = new StringBuffer(lexiconKey);
            if (lexiconArgs != null) {
                s.append(" {");
                for (int i = 0; i < lexiconArgs.length; ++i) {
                    if (i > 0) {
                        s.append(", ");
                    }
                    s.append(lexiconArgs[i]);
                }
                s.append(" }");
            }
            return s.toString();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return lexiconKey;
        }
    }
}

