/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform;

import com.tridium.platform.BSessionNavNode;
import java.util.Comparator;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.BIAgent;
import javax.baja.naming.BISession;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.Array;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BSessionNavNodeFactory
extends BObject
implements BIAgent {
    public static final Type TYPE = Sys.loadType(BSessionNavNodeFactory.class);
    private Array<BINavNode> navNodes;
    private BISession session;
    public static Comparator<BINavNode> NAV_NODE_COMPARATOR = (o1, o2) -> o1.getNavDisplayName(null).compareTo(o2.getNavDisplayName(null));

    public Type getType() {
        return TYPE;
    }

    public static BSessionNavNodeFactory[] makeFor(BISession session) {
        AgentInfo[] agents = ((BObject)session).getAgents().filter(AgentFilter.is((Type)TYPE)).list();
        Array resultArray = new Array(BSessionNavNodeFactory.class);
        for (AgentInfo agent : agents) {
            if (agent.getAgentType().isAbstract() || agent.getAgentType().isInterface()) continue;
            BSessionNavNodeFactory factory = (BSessionNavNodeFactory)agent.getAgentType().getInstance();
            factory.setNavSession(session);
            resultArray.add((Object)factory);
            if (!session.isConnected()) continue;
            factory.connect();
        }
        return (BSessionNavNodeFactory[])resultArray.trim();
    }

    public abstract void connect();

    public void disconnect() {
    }

    public final Array<BINavNode> getNavNodes() {
        return this.navNodes;
    }

    public final BSessionNavNode getNavNode(String navName) {
        if (this.navNodes != null) {
            for (int i = 0; i < this.navNodes.size(); ++i) {
                if (!((BINavNode)this.navNodes.get(i)).getNavName().equals(navName)) continue;
                return (BSessionNavNode)((Object)this.navNodes.get(i));
            }
        }
        return null;
    }

    public void setNavSession(BISession value) {
        this.session = value;
    }

    public final BISession getNavSession() {
        return this.session;
    }

    protected final void setNavNodes(Array<BINavNode> value) {
        this.navNodes = value;
    }

    protected final void setNavNodes(BSessionNavNode[] value) {
        this.setNavNodes((Array<BINavNode>)new Array((Object[])value));
    }
}

