/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install.part;

import com.tridium.install.BDependency;
import com.tridium.install.BVersion;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.part.BPart;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;

public class BOsPart
extends BPart {
    public static final Type TYPE = Sys.loadType(BOsPart.class);
    private static final BIcon icon = BPart.getPartTypeIcon(TYPE);
    boolean isInstallable = false;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BOsPart() {
    }

    public BOsPart(String pName, String pDescription, BVersion pVersion, BInstallable pInstallable, boolean canInstall) {
        this.setPartName(pName);
        this.setDescription(pDescription);
        this.setVersion(pVersion);
        this.setInstallable(pInstallable);
        this.isInstallable = canInstall;
    }

    @Override
    public boolean meets(BDependency depend) {
        return depend.getPartType().is(TYPE) && this.getVersion().meets(depend) && this.matchesName(depend.getPartName());
    }

    public static BPart make(XElem elem) {
        return BOsPart.make(elem, null);
    }

    public static BPart make(XElem elem, BInstallable installable) {
        if (elem == null) {
            return null;
        }
        if (elem.name().equals("os")) {
            String name = elem.get("name");
            boolean canInstallDefault = name.startsWith("qnx-jace") || name.startsWith("tridium-qnx7");
            return new BOsPart(name, elem.get("description", elem.get("desc", "")), new BVersion("", BOsPart.getVendorVersion(elem)), installable, elem.getb("installable", canInstallDefault));
        }
        return null;
    }

    @Override
    public XElem getXml() {
        XElem result = new XElem("os");
        result.setAttr("name", this.getPartName());
        if (this.getVersion().getVendor().trim().length() > 0) {
            result.setAttr("vendor", this.getVersion().getVendor());
        }
        if (this.getVersion().getBajaVersionString().trim().length() > 0) {
            result.setAttr("bajaVersion", this.getVersion().getBajaVersionString());
        }
        if (this.getVersion().getVendorVersionString().trim().length() > 0) {
            result.setAttr("version", this.getVersion().getVendorVersionString());
        }
        if (this.getDescription().trim().length() > 0) {
            result.setAttr("description", this.getDescription());
        }
        return result;
    }

    public String toString(Context context) {
        return "OS Part: " + this.getPartName() + " " + (Object)((Object)this.getVersion());
    }

    public boolean isNull() {
        return this.getPartName().equals("nullos");
    }

    @Override
    public boolean isInstallable() {
        return this.isInstallable;
    }

    public boolean allowGlobalFileAccess() {
        return this.getPartName().startsWith("qnx-jace") || this.getPartName().startsWith("tridium-qnx7");
    }

    public static BOsPart makeNull() {
        return new BOsPart("nullos", "", BVersion.makeZero(), null, false);
    }

    public BIcon getIcon() {
        return icon;
    }
}

