/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install.installable;

import com.tridium.install.BDependency;
import com.tridium.install.BVersion;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.part.BBrandPart;
import com.tridium.install.part.BGenericPart;
import com.tridium.install.part.BPart;
import com.tridium.platform.SystemFilePaths;
import com.tridium.sys.license.LicenseUtil;
import com.tridium.util.ArrayUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Optional;
import javax.baja.file.FilePath;
import javax.baja.nre.util.TextUtil;
import javax.baja.platform.install.BFileReconciler;
import javax.baja.platform.install.BVersionRelation;
import javax.baja.sys.BAbsTime;
import javax.baja.util.BTypeSpec;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XWriter;

public abstract class BundleManifest {
    protected XElem rootElem;
    protected XElem fileHandlingElem;
    protected XElem depsElem;
    protected XElem exclElem;
    protected XElem providesElem;
    protected XElem resourcesElem;
    public static final int REPLACE_DEFAULT = -1;
    public static final int REPLACE_NEVER = 0;
    public static final int REPLACE_ALWAYS = 1;
    public static final int REPLACE_CRC = 2;
    public static final int DO_NOT_COPY = 3;
    public static final int REPLACE_HOSTID = 4;
    private static String[] replaceString = new String[]{"never", "always", "crc", "nocopy", "hostid"};
    public static final String NIAGARA_HOME_RELATIVE_PATH = "niagara_home";
    public static final String NIAGARA_USER_HOME_RELATIVE_PATH = "niagara_user_home";

    protected BundleManifest(XElem rootElem) throws Exception {
        this.rootElem = rootElem.copy();
        this.fileHandlingElem = this.rootElem.elem("fileHandling");
        if (this.fileHandlingElem == null) {
            this.fileHandlingElem = new XElem("fileHandling");
            this.rootElem.addContent((XContent)this.fileHandlingElem);
        }
        this.depsElem = this.rootElem.elem("dependencies");
        if (this.depsElem == null) {
            this.depsElem = new XElem("dependencies");
            rootElem.addContent((XContent)this.depsElem);
        }
        this.providesElem = this.rootElem.elem("provides");
        if (this.providesElem == null) {
            this.providesElem = new XElem("provides");
            this.rootElem.addContent((XContent)this.providesElem);
        }
        this.exclElem = this.rootElem.elem("exclusions");
        if (this.exclElem == null) {
            this.exclElem = new XElem("exclusions");
            rootElem.addContent((XContent)this.exclElem);
        }
        this.resourcesElem = this.rootElem.elem("resources");
        if (this.resourcesElem == null) {
            this.resourcesElem = new XElem("resources");
            rootElem.addContent((XContent)this.resourcesElem);
        }
    }

    protected BundleManifest() {
        this.rootElem = new XElem("dist");
        this.fileHandlingElem = new XElem("fileHandling");
        this.rootElem.addContent((XContent)this.fileHandlingElem);
        this.depsElem = new XElem("dependencies");
        this.rootElem.addContent((XContent)this.depsElem);
        this.exclElem = new XElem("exclusions");
        this.rootElem.addContent((XContent)this.exclElem);
        this.providesElem = new XElem("provides");
        this.rootElem.addContent((XContent)this.providesElem);
        this.resourcesElem = new XElem("resources");
        this.rootElem.addContent((XContent)this.resourcesElem);
    }

    public void write(OutputStream out) throws IOException {
        XWriter xwriter = new XWriter(out);
        this.rootElem.write(xwriter);
        xwriter.flush();
    }

    public String getBuildDate() {
        return this.rootElem.get("buildDate", "");
    }

    public void setBuildDate(BAbsTime value) {
        if (value != null) {
            this.rootElem.setAttr("buildDate", value.toString());
        }
    }

    public String getBuildHost() {
        return this.rootElem.get("buildHost", "");
    }

    public void setBuildHost(String value) {
        this.rootElem.setAttr("buildHost", value);
    }

    public String getDescription() {
        return this.rootElem.get("description", "");
    }

    public void setDescription(String value) {
        this.rootElem.setAttr("description", value);
    }

    public String getInstallableName() {
        return this.rootElem.get("name", "");
    }

    public void setInstallableName(String value) {
        this.rootElem.setAttr("name", value);
    }

    public BVersion getInstallableVersion() {
        return new BVersion(this.rootElem.get("vendor", ""), this.rootElem.get("version", ""));
    }

    public void setInstallableVersion(BVersion value) {
        this.rootElem.setAttr("vendor", value.getVendor());
        this.rootElem.setAttr("version", value.getVendorVersionString());
    }

    public boolean useAbsoluteElementPaths() {
        return this.rootElem.getb("absoluteElementPaths", false);
    }

    public void setUseAbsoluteElementPaths(boolean value) {
        this.rootElem.setAttr("absoluteElementPaths", String.valueOf(value));
    }

    public Optional<Long> getReleaseDate() {
        return LicenseUtil.getDateAttributeValue((XElem)this.rootElem, (String)"releaseDate", (boolean)true);
    }

    public void setReleaseDate(Optional<Long> value) {
        if (value.isPresent()) {
            this.rootElem.setAttr("releaseDate", LicenseUtil.formatDate((long)value.get()));
        } else {
            this.rootElem.removeAttr("releaseDate");
        }
    }

    public int getDefaultReplaceRule() {
        String tag = this.fileHandlingElem.get("replace", "crc");
        for (int i = 0; i < replaceString.length; ++i) {
            if (!replaceString[i].equals(tag)) continue;
            return i;
        }
        return 2;
    }

    public void setDefaultReplaceRule(int value) {
        this.fileHandlingElem.setAttr("replace", replaceString[value]);
    }

    public FileHandlingRule[] getFileHandlingRules() {
        ArrayList<FileHandlingRule> result = new ArrayList<FileHandlingRule>();
        block10: for (XElem elem : this.fileHandlingElem.elems()) {
            switch (elem.name()) {
                case "dir": {
                    result.add(new DirHandlingRule(elem.get("name"), elem.get("replace", null), elem.getb("clean", false)));
                    continue block10;
                }
                case "file": {
                    result.add(new FileHandlingRule(elem.get("name"), elem.get("replace", null)));
                    continue block10;
                }
                case "remove": {
                    result.add(new RemoveRule(elem.get("name")));
                    continue block10;
                }
                default: {
                    throw new IllegalStateException("unrecognized file handling rule type '" + elem.name() + "'");
                }
            }
        }
        for (XElem elem : this.resourcesElem.elems()) {
            if (elem.get("content", null) == null) continue;
            result.add(new FileHandlingRule(elem.get("content"), "nocopy"));
        }
        return (FileHandlingRule[])ArrayUtil.arrayFromCollection(result, FileHandlingRule[]::new);
    }

    public void addFileToRemove(String entryPath) {
        XElem elem = new XElem("remove");
        elem.setAttr("name", entryPath);
        this.fileHandlingElem.addContent((XContent)elem);
    }

    public void addDir(String entryPath, boolean clean) {
        this.addDir(entryPath, -1, clean);
    }

    public void addDir(String entryPath, int replaceRule) {
        this.addDir(entryPath, replaceRule, false);
    }

    public void addDir(String entryPath, int replaceRule, boolean clean) {
        XElem elem = new XElem("dir");
        elem.setAttr("name", entryPath);
        if (replaceRule >= 0) {
            elem.setAttr("replace", replaceString[replaceRule]);
        }
        if (clean) {
            elem.setAttr("clean", "true");
        }
        this.fileHandlingElem.addContent((XContent)elem);
    }

    public void addFile(String entryPath) {
        this.addFile(entryPath, -1);
    }

    public void addFile(String entryPath, int replaceRule) {
        XElem elem = new XElem("file");
        elem.setAttr("name", entryPath);
        if (replaceRule >= 0) {
            elem.setAttr("replace", replaceString[replaceRule]);
        }
        this.fileHandlingElem.addContent((XContent)elem);
    }

    public void addFile(String entryPath, BTypeSpec reconcilerSpec, int noAgentRule) {
        XElem elem = new XElem("file");
        elem.setAttr("name", entryPath);
        if (noAgentRule == -1) {
            elem.setAttr("replace", "reconcile:" + reconcilerSpec.toString());
        } else {
            elem.setAttr("replace", "reconcile:" + reconcilerSpec.toString() + ":" + replaceString[noAgentRule]);
        }
        this.fileHandlingElem.addContent((XContent)elem);
    }

    public BDependency[] getDependencies() {
        ArrayList<BDependency> result = new ArrayList<BDependency>();
        for (XElem elem : this.depsElem.elems()) {
            BDependency d = BDependency.make(elem);
            if (d == null || d.getPartTypeSpec().equals((Object)BBrandPart.TYPE.getTypeSpec()) && (d.getPartName().equals("noBrand") || d.getPartName().equals("nullos") || d.getPartName().equals("disabled"))) continue;
            if (d.getVersionRelation() == BVersionRelation.exact && d.getPartTypeSpec().equals((Object)BGenericPart.TYPE.getTypeSpec()) && this.providesElem.elems().length == 0) {
                d.setVersion(BVersion.makeZero());
                d.setVersionRelation(BVersionRelation.minimum);
            }
            result.add(d);
        }
        return (BDependency[])ArrayUtil.arrayFromCollection(result, BDependency[]::new);
    }

    public BDependency[] getExclusions() {
        ArrayList<BDependency> result = new ArrayList<BDependency>();
        for (XElem elem : this.exclElem.elems()) {
            BDependency d = BDependency.make(elem);
            if (d == null) continue;
            result.add(d);
        }
        return (BDependency[])ArrayUtil.arrayFromCollection(result, BDependency[]::new);
    }

    public void addDependency(BDependency value) {
        this.depsElem.addContent((XContent)value.getXml());
    }

    public void addExclusion(BDependency value) {
        this.exclElem.addContent((XContent)value.getXml());
    }

    public InstallableResourceMetadata[] getInstallableResources() {
        XElem[] elems = this.resourcesElem.elems("installable");
        InstallableResourceMetadata[] result = new InstallableResourceMetadata[elems.length];
        for (int i = 0; i < elems.length; ++i) {
            result[i] = new InstallableResourceMetadata(elems[i]);
        }
        return result;
    }

    public BPart[] getProvidedParts(BDistribution dist) {
        ArrayList<BPart> result = new ArrayList<BPart>();
        for (XElem elem : this.providesElem.elems()) {
            BPart p = BPart.makePart(elem, dist);
            if (p == null) continue;
            result.add(p);
        }
        return (BPart[])ArrayUtil.arrayFromCollection(result, BPart[]::new);
    }

    public void addProvidedPart(BPart part) {
        this.providesElem.addContent((XContent)part.getXml());
    }

    public String getEntryPath(FilePath filePath, String stationName, boolean targetIsNiagara4) {
        FilePath normalPath = this.getNormalFilePath(filePath, stationName, targetIsNiagara4);
        return normalPath == null ? null : this.getEntryPath(normalPath, targetIsNiagara4);
    }

    public String getEntryPath(FilePath filePath) {
        return this.getEntryPath(filePath, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getEntryPath(FilePath filePath, boolean targetIsNiagara4) {
        StringBuilder result = new StringBuilder();
        if (filePath.isSysHomeAbsolute()) {
            if (this.useAbsoluteElementPaths()) {
                result.append("niagara");
            } else if (targetIsNiagara4) {
                result.append(NIAGARA_HOME_RELATIVE_PATH);
            }
            for (int i = 0; i < filePath.depth(); ++i) {
                if (result.length() > 0) {
                    result.append('/');
                }
                result.append(filePath.nameAt(i));
                if (i != 0 || !filePath.nameAt(i).equals("bin")) continue;
                result.append("/stage");
            }
            return result.toString();
        } else if (filePath.isUserHomeAbsolute()) {
            if (!targetIsNiagara4) {
                throw new IllegalArgumentException("error with path " + filePath.getBody() + ": user home paths unsupported for Niagara AX target hosts");
            }
            if (!this.useAbsoluteElementPaths()) {
                result.append(NIAGARA_USER_HOME_RELATIVE_PATH);
            }
            for (int i = 0; i < filePath.depth(); ++i) {
                if (result.length() > 0) {
                    result.append('/');
                }
                result.append(filePath.nameAt(i));
            }
            return result.toString();
        } else {
            if (!filePath.isLocalAbsolute()) throw new IllegalArgumentException("error with path " + filePath.getBody() + ": only local, user and system home absolute paths supported");
            if (!this.useAbsoluteElementPaths()) throw new IllegalArgumentException("error with path " + filePath.getBody() + ": local absolute paths unsupported");
            for (int i = 0; i < filePath.depth(); ++i) {
                if (result.length() > 0) {
                    result.append('/');
                }
                result.append(filePath.nameAt(i));
            }
        }
        return result.toString();
    }

    public FilePath getNormalFilePath(FilePath origPath, boolean targetIsNiagara4) {
        return this.getNormalFilePath(origPath, null, targetIsNiagara4);
    }

    public FilePath getNormalFilePath(FilePath origPath, String stationName, boolean targetIsNiagara4) {
        if (origPath.isStationHomeAbsolute()) {
            if (stationName == null) {
                return null;
            }
            FilePath result = SystemFilePaths.getStationsDirPath(targetIsNiagara4);
            result = result.merge(stationName);
            result = result.merge("shared");
            for (int ixLevel = 0; ixLevel < origPath.depth(); ++ixLevel) {
                result = result.merge(origPath.nameAt(ixLevel));
            }
            return result;
        }
        if (origPath.isProtectedStationHomeAbsolute()) {
            if (stationName == null) {
                return null;
            }
            FilePath result = SystemFilePaths.getStationsDirPath(targetIsNiagara4);
            result = result.merge(stationName);
            for (int ixLevel = 0; ixLevel < origPath.depth(); ++ixLevel) {
                result = result.merge(origPath.nameAt(ixLevel));
            }
            return result;
        }
        if (origPath.isSysHomeAbsolute()) {
            return origPath;
        }
        if (origPath.isUserHomeAbsolute()) {
            return origPath;
        }
        if (origPath.isLocalAbsolute()) {
            if (this.useAbsoluteElementPaths()) {
                return origPath;
            }
            return null;
        }
        return null;
    }

    public static class InstallableResourceMetadata {
        public XElem elem;

        public InstallableResourceMetadata(XElem elem) {
            this.elem = elem;
        }

        public String getContentEntryPath() {
            return this.elem.get("content");
        }

        public String getInstallableName() {
            return this.elem.get("name");
        }

        public String getProvidedPartType() {
            return this.elem.get("type");
        }

        public BVersion getVersion() {
            return new BVersion(this.elem.get("vendor", ""), this.elem.get("vendorVersion"));
        }

        public XElem makeDependencyElem() {
            return new XElem(this.elem.get("type")).addAttr("name", this.elem.get("name")).addAttr("vendor", this.elem.get("vendor", "")).addAttr("version", this.elem.get("vendorVersion")).addAttr("rel", "exact");
        }
    }

    public static class DirHandlingRule
    extends FileHandlingRule {
        public boolean clean;

        public DirHandlingRule(String entryPath, String replaceRule, boolean clean) {
            super(entryPath, replaceRule);
            this.clean = clean;
        }

        public DirHandlingRule(String entryPath, int replaceRule, boolean clean) {
            super(entryPath, replaceRule);
            this.clean = clean;
        }
    }

    public static class RemoveRule
    extends FileHandlingRule {
        public RemoveRule(String entryPath) {
            super(entryPath, -1);
        }
    }

    public static class FileHandlingRule {
        public String entryPath;
        public int replaceRule;
        public BFileReconciler reconciler;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public FileHandlingRule(String entryPath, String replaceRule) {
            this.entryPath = entryPath;
            this.replaceRule = -1;
            if (replaceRule == null || replaceRule.trim().length() <= 0) return;
            String[] replaceTokens = TextUtil.split((String)replaceRule, (char)':');
            if (replaceTokens[0].equals("reconcile")) {
                try {
                    this.reconciler = (BFileReconciler)BTypeSpec.make((String)replaceTokens[1], (String)replaceTokens[2]).getInstance();
                    return;
                }
                catch (Exception e) {
                    if (replaceTokens.length <= 3) return;
                    for (int i = 0; i < replaceString.length; ++i) {
                        if (!replaceString[i].equals(replaceTokens[3])) continue;
                        this.replaceRule = i;
                        return;
                    }
                    return;
                }
            } else {
                for (int i = 0; i < replaceString.length; ++i) {
                    if (!replaceString[i].equals(replaceRule)) continue;
                    this.replaceRule = i;
                    return;
                }
            }
        }

        public FileHandlingRule(String entryPath, int replaceRule) {
            this.entryPath = entryPath;
            this.replaceRule = replaceRule;
        }
    }
}

