/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BVersion;
import com.tridium.install.part.BNrePart;
import com.tridium.install.part.BOsPart;
import com.tridium.install.part.BPart;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.task.CancelableDaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import java.net.SocketException;
import javax.baja.nre.util.Array;
import javax.baja.platform.ICancelHint;
import javax.baja.util.Lexicon;

public class DaemonPlatformUtil {
    private static final BDependency fixedNre = new BDependency("nre-core-qnx-ppc", new BVersion(null, "3.0.103"), BNrePart.TYPE.getTypeSpec());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doExtraStationShutdownTasks(BDaemonPlatform target, DaemonSessionTaskListener listener, ICancelHint cancelHint) throws Exception {
        BNrePart nrePart;
        BOsPart osPart = target.getOsPart();
        if ((osPart.getPartName().startsWith("qnx-jace") || osPart.getPartName().startsWith("tridium-qnx7")) && ((nrePart = target.getNrePart()).isNull() || !((BPart)nrePart).meets(fixedNre))) {
            if (listener == null) {
                listener = DaemonSessionTaskListener.NULL_TASK_LISTENER;
            }
            BDaemonSession session = target.getDaemonSession();
            String sessionTimestamp = session.getHostProperties().getSessionTimestamp();
            Lexicon lex = Lexicon.make((String)"platform");
            Array autoStartStations = new Array(BStationSurrogate.class);
            DaemonSessionTask task = new DaemonSessionTask(lex, "DaemonPlatformUtil.settingAutoStart.title", "DaemonPlatformUtil.settingAutoStart.message");
            listener.taskStarted(task);
            try {
                BStationSurrogate[] stations;
                for (BStationSurrogate station : stations = BStationSurrogate.makeAll(session)) {
                    DaemonPlatformUtil.checkCanceled(cancelHint);
                    if (!station.getIsAutoStart()) continue;
                    station.updateSettings(false, station.getIsAutoRestart());
                    autoStartStations.add((Object)station);
                }
            }
            finally {
                listener.taskFinished(task);
            }
            try {
                task = new DaemonSessionTask(lex, "DaemonPlatformUtil.sendingReboot.title", "DaemonPlatformUtil.sendingReboot.message");
                listener.taskStarted(task);
                try {
                    if (!session.sendRebootRequest(false)) {
                        DaemonPlatformUtil.checkCanceled(cancelHint);
                        session.sendForceRebootRequest();
                    }
                }
                finally {
                    listener.taskFinished(task);
                }
                task = new CancelableDaemonSessionTask(lex, "DaemonPlatformUtil.reconnecting.title", "DaemonPlatformUtil.reconnecting.message", cancelHint);
                listener.taskStarted(task);
                try {
                    session.getHostProperties().reset();
                    while (true) {
                        DaemonPlatformUtil.checkCanceled(cancelHint);
                        try {
                            session.reloadHostProperties(15000);
                            if (session.getHostProperties().getSessionTimestamp().equals(sessionTimestamp)) continue;
                            task.setMessage(lex.getText("DaemonPlatformUtil.reconnecting.successMessage"));
                            listener.taskUpdated(task);
                        }
                        catch (SocketException stations) {
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    listener.taskFinished(task);
                }
            }
            finally {
                task = new DaemonSessionTask(lex, "DaemonPlatformUtil.restoringAutoStart.title", "DaemonPlatformUtil.restoringAutoStart.message");
                listener.taskStarted(task);
                try {
                    for (int i = 0; i < autoStartStations.size(); ++i) {
                        BStationSurrogate station = (BStationSurrogate)((Object)autoStartStations.get(i));
                        station.updateSettings(true, station.getIsAutoRestart());
                    }
                }
                finally {
                    listener.taskFinished(task);
                }
            }
        }
    }

    private static void checkCanceled(ICancelHint cancelHint) {
        if (cancelHint != null && cancelHint.isCanceled()) {
            throw new ICancelHint.CanceledException();
        }
    }
}

