/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install;

import com.tridium.install.BDependency;
import com.tridium.install.part.BPart;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.io.BIEncodable;
import javax.baja.nre.util.TextUtil;
import javax.baja.platform.install.BVersionRelation;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BObject;
import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;
import javax.baja.util.Version;

public class BVersion
extends BStruct
implements BIComparable,
BIEncodable {
    public static final Property bajaVersionString = BVersion.newProperty((int)1, (String)"", null);
    public static final Property vendor = BVersion.newProperty((int)1, (String)"", null);
    public static final Property vendorVersionString = BVersion.newProperty((int)1, (String)"", null);
    public static final Type TYPE = Sys.loadType(BVersion.class);
    private Version vendorVersionObject = null;
    private boolean setting = false;
    private final String settingMonitor = new String("Setting");
    public static final LexiconText nameVersionText = LexiconText.make((String)"platform", (String)"Version.nameVersion");
    public static final BVersion ZERO = new BVersion();
    public static final int LATER_VERSION = 1;
    public static final int SAME_VERSION = 2;
    public static final int EARLIER_VERSION = 4;
    public static final int DIFFERENT_VERSION = 8;
    public static final int EQUIVALENT_VERSION = 16;
    public static final int MORE_SPECIFIC_VERSION = 32;
    public static final int LESS_SPECIFIC_VERSION = 64;
    public static final int MEETS_MINIMUM = 115;
    public static final int MEETS_MAXIMUM = 118;

    public String getBajaVersionString() {
        return this.getString(bajaVersionString);
    }

    public void setBajaVersionString(String v) {
        this.setString(bajaVersionString, v, null);
    }

    public String getVendor() {
        return this.getString(vendor);
    }

    public void setVendor(String v) {
        this.setString(vendor, v, null);
    }

    public String getVendorVersionString() {
        return this.getString(vendorVersionString);
    }

    public void setVendorVersionString(String v) {
        this.setString(vendorVersionString, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BVersion() {
    }

    public BVersion(String vVersion) {
        this(null, vVersion);
    }

    public BVersion(String vVendor, String vVersion) {
        if (vVendor != null && vVendor.trim().length() > 0) {
            this.setVendor(vVendor);
        } else {
            this.setVendor("");
        }
        if (vVersion != null && vVersion.trim().length() > 0) {
            this.setVendorVersionString(vVersion);
        } else {
            this.setVendorVersionString("");
        }
    }

    public int compareTo(Object secondVersion) {
        BVersion sv = (BVersion)((Object)secondVersion);
        if (sv == null) {
            return 1;
        }
        int result = TextUtil.toLowerCase((String)this.getVendor()).compareTo(TextUtil.toLowerCase((String)sv.getVendor()));
        if (result == 0) {
            if (sv.getVendorVersion() == null) {
                return this.getVendorVersion() == null ? 0 : 1;
            }
            if (this.getVendorVersion() == null) {
                return -1;
            }
            result = this.getVendorVersion().compareTo(sv.getVendorVersion());
        }
        return result;
    }

    public static boolean meets(Version v, BDependency depend) {
        return BVersion.meetsVersionRequirement(v, depend.getVersion().getVendorVersion(), depend.getVersionRelation());
    }

    public static boolean meetsVersionRequirement(Version v, Version required, BVersionRelation relation) {
        int c = BVersion.checkVersionRequirement(v, required);
        if (relation == BVersionRelation.minimum) {
            return (c & 0x73) > 0;
        }
        if (relation == BVersionRelation.maximum) {
            return (c & 0x76) > 0;
        }
        return (c & 2) > 0;
    }

    public boolean meets(BDependency depend) {
        return this.meetsVersionRequirement(depend.getVersion(), depend.getVersionRelation());
    }

    public boolean meetsVersionRequirement(BVersion required, BVersionRelation relation) {
        int c = this.checkVersionRequirement(required);
        if (relation == BVersionRelation.minimum) {
            return (c & 0x73) > 0;
        }
        if (relation == BVersionRelation.maximum) {
            return (c & 0x76) > 0;
        }
        return (c & 2) > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int checkVersionRequirement(BVersion required) {
        int result;
        if (!required.getVendor().equalsIgnoreCase(this.getVendor()) && required.getVendor().trim().length() != 0 && this.getVendor().trim().length() != 0) return 8;
        if (required.getVendorVersion() == null) {
            if (this.getVendorVersion() != null) return 32;
            result = 0;
        } else {
            if (this.getVendorVersion() == null) {
                return 64;
            }
            result = this.getVendorVersion().compareTo(required.getVendorVersion());
        }
        if (result == 0) {
            if (!required.getVendor().equalsIgnoreCase(this.getVendor())) return 16;
            return 2;
        }
        if (result >= 0) return 1;
        return 4;
    }

    public static int checkVersionRequirement(Version check, Version required) {
        int result = required == null ? 0 : (check == null ? -1 : check.compareTo(required));
        if (result == 0) {
            return 2;
        }
        if (result < 0) {
            return 4;
        }
        return 1;
    }

    public synchronized boolean equivalent(Object obj) {
        if (obj instanceof BVersion) {
            BVersion v = (BVersion)((Object)obj);
            if (this.getVendorVersion() == null) {
                if (v.getVendorVersion() != null) {
                    return false;
                }
            } else {
                if (v.getVendorVersion() == null) {
                    return false;
                }
                if (!this.getVendorVersion().equals((Object)v.getVendorVersion())) {
                    return false;
                }
            }
            return v.getVendor().equalsIgnoreCase(this.getVendor());
        }
        return false;
    }

    public String toString(Context context) {
        StringBuffer result = new StringBuffer();
        if (this.getVendor().length() > 0) {
            result.append(this.getVendor()).append(" ");
        }
        if (this.getVendorVersion() != null) {
            result.append(this.getVendorVersion());
        }
        return result.toString().trim();
    }

    public Version getBajaVersion() {
        if (this.getVersionString(this.getBajaVersionString()).trim().length() > 0) {
            return new Version(this.getVersionString(this.getBajaVersionString()));
        }
        return null;
    }

    public Version getVendorVersion() {
        if (this.vendorVersionObject == null && this.getVersionString(this.getVendorVersionString()).trim().length() > 0) {
            this.vendorVersionObject = new Version(this.getVersionString(this.getVendorVersionString()));
        }
        return this.vendorVersionObject;
    }

    public void setVendorVersion(Version value) {
        if (this.setting) {
            return;
        }
        this.vendorVersionObject = value;
        if (value == null) {
            this.setVendorVersionString("");
        } else {
            this.setVendorVersionString(value.toString());
        }
    }

    private String getVersionString(String value) {
        if (value == null) {
            return "";
        }
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) == '.' || Character.isDigit(value.charAt(i))) continue;
            return value.substring(0, i);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed(Property prop, Context context) {
        String string = this.settingMonitor;
        synchronized (string) {
            this.setting = true;
            if (prop == vendorVersionString) {
                String propValue = this.propertyValueToString(prop, context);
                this.vendorVersionObject = propValue.trim().length() == 0 ? null : new Version(this.getVersionString(propValue));
            }
            this.setting = false;
        }
    }

    public static String formatNameVersion(BPart part, Context cx) {
        return BVersion.formatNameVersion(part.getPartName(), part.getVersion(), cx);
    }

    public static String formatNameVersion(String name, BVersion version, Context cx) {
        String versionText = version.toString(cx);
        if (versionText.trim().length() == 0 || versionText.equals("0")) {
            return name;
        }
        return nameVersionText.getText(cx, new Object[]{name, versionText});
    }

    public static BVersion makeZero() {
        return new BVersion();
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.getBajaVersionString());
        out.writeUTF(this.getVendor());
        out.writeUTF(this.getVendorVersionString());
    }

    public BObject decode(DataInput in) throws IOException {
        BVersion result = new BVersion();
        result.setBajaVersionString(in.readUTF());
        result.setVendor(in.readUTF());
        result.setVendorVersionString(in.readUTF());
        return result;
    }

    public String encodeToString() throws IOException {
        StringBuffer result = new StringBuffer(128);
        result.append(this.getBajaVersionString());
        result.append(';');
        result.append(this.getVendor());
        result.append(';');
        result.append(this.getVendorVersionString());
        return result.toString();
    }

    public BObject decodeFromString(String s) throws IOException {
        BVersion result = new BVersion();
        String[] values = TextUtil.split((String)s, (char)';');
        result.setBajaVersionString(values[0]);
        result.setVendor(values[1]);
        result.setVendorVersionString(values[2]);
        return result;
    }
}

