/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.points;

import com.tridium.nrio.BNrio16Module;
import com.tridium.nrio.BNrioNetwork;
import com.tridium.nrio.points.BNrio16WriteProxyExt;
import javax.baja.control.BNumericWritable;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

public class BNrioVoltageOutputProxyExt
extends BNrio16WriteProxyExt {
    public static final Property deviceFacets = BNrioVoltageOutputProxyExt.newProperty((int)1, (BValue)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"volt")));
    public static final Type TYPE = Sys.loadType(BNrioVoltageOutputProxyExt.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return super.isParentLegal(parent) && parent instanceof BNumericWritable;
    }

    @Override
    public BReadWriteMode getMode() {
        return BReadWriteMode.readWrite;
    }

    @Override
    public void writeData(BStatusValue out) {
        BNrioNetwork network = (BNrioNetwork)this.getNetwork();
        if (network == null) {
            return;
        }
        if (!(this.device() instanceof BNrio16Module)) {
            return;
        }
        int wrValue = this.getVoltageValue((BStatusNumeric)out);
        int wrStatus = ((BNrio16Module)this.device()).setAoValue(wrValue, this.getInstance());
        if (wrStatus == 0) {
            this.writeOk(out);
        } else {
            this.writeFail("writeError: " + wrStatus);
        }
    }

    protected int getVoltageValue(BStatusNumeric out) {
        float max = 10.0f;
        float min = 0.0f;
        float value = (float)out.getValue();
        if (value > max) {
            value = max;
        } else if (value < min) {
            value = min;
        }
        int ivalue = (int)(value / max * 4095.0f) & 0xFFF;
        return ivalue;
    }
}

