/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.points;

import com.tridium.nrio.BNrio16Module;
import com.tridium.nrio.components.BINrioIoStatus;
import com.tridium.nrio.enums.BUniversalInputTypeEnum;
import com.tridium.nrio.points.BUiProxyExt;
import javax.baja.control.BNumericPoint;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

public class BNrioVoltageInputProxyExt
extends BUiProxyExt {
    public static final Property uiType = BNrioVoltageInputProxyExt.newProperty((int)1, (BValue)BUniversalInputTypeEnum.ai_0to10_vdc, null);
    public static final Property deviceFacets = BNrioVoltageInputProxyExt.newProperty((int)1, (BValue)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"volt")));
    public static final Type TYPE = Sys.loadType(BNrioVoltageInputProxyExt.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return super.isParentLegal(parent) && parent instanceof BNumericPoint;
    }

    @Override
    public BReadWriteMode getMode() {
        return BReadWriteMode.readonly;
    }

    @Override
    public void ioValueChanged() {
        BINrioIoStatus ioStatus = (BINrioIoStatus)((BNrio16Module)this.getDevice()).getIoStatus();
        int maxUiInstance = ioStatus.getMaxUiInstance();
        if (this.getUiType().getOrdinal() != 5 || this.getInstance() < 1 || this.getInstance() > maxUiInstance) {
            this.readFail("readFail.invalidInstanceOrData");
        } else {
            try {
                float value = ioStatus.getAi(this.getInstance());
                value = value * 10.0f / 4095.0f;
                if (value < 0.0f) {
                    value = 0.0f;
                }
                BStatusNumeric svalue = new BStatusNumeric((double)value);
                this.readOk((BStatusValue)svalue);
            }
            catch (Exception e) {
                this.readFail(e.getMessage());
            }
        }
    }
}

