/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.points;

import com.tridium.nrio.BNrio16Module;
import com.tridium.nrio.BNrio34Module;
import com.tridium.nrio.components.BINrioIoStatus;
import com.tridium.nrio.enums.BNrio16CounterSelectEnum;
import com.tridium.nrio.enums.BUniversalInputTypeEnum;
import com.tridium.nrio.points.BUiProxyExt;
import com.tridium.nrio.types.BAbstractRateType;
import com.tridium.nrio.types.BFixedWindowRateType;
import javax.baja.control.BNumericPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLong;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class BNrioCounterInputProxyExt
extends BUiProxyExt {
    public static final Property uiType = BNrioCounterInputProxyExt.newProperty((int)1, (BValue)BUniversalInputTypeEnum.di_HighSpeed, null);
    public static final Property outputSelect = BNrioCounterInputProxyExt.newProperty((int)0, (BValue)BNrio16CounterSelectEnum.count, null);
    public static final Property total = BNrioCounterInputProxyExt.newProperty((int)1, (int)-1, null);
    public static final Property rate = BNrioCounterInputProxyExt.newProperty((int)3, (int)0, null);
    public static final Property rateCalcType = BNrioCounterInputProxyExt.newProperty((int)0, (BValue)BTypeSpec.make((String)"nrio:FixedWindowRateType"), (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"nrio:AbstractRateType")));
    public static final Property rateCalc = BNrioCounterInputProxyExt.newProperty((int)1, (BValue)new BFixedWindowRateType(), null);
    public static final Property rateCalcTime = BNrioCounterInputProxyExt.newProperty((int)3, (BValue)BAbsTime.DEFAULT, null);
    public static final Action reset = BNrioCounterInputProxyExt.newAction((int)0, null);
    public static final Action set = BNrioCounterInputProxyExt.newAction((int)0, (BValue)BLong.make((long)0L), null);
    public static final Action recalculateRate = BNrioCounterInputProxyExt.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BNrioCounterInputProxyExt.class);

    public BNrio16CounterSelectEnum getOutputSelect() {
        return (BNrio16CounterSelectEnum)this.get(outputSelect);
    }

    public void setOutputSelect(BNrio16CounterSelectEnum v) {
        this.set(outputSelect, (BValue)v, null);
    }

    public long getTotal() {
        return this.getLong(total);
    }

    public void setTotal(long v) {
        this.setLong(total, v, null);
    }

    public double getRate() {
        return this.getDouble(rate);
    }

    public void setRate(double v) {
        this.setDouble(rate, v, null);
    }

    public BTypeSpec getRateCalcType() {
        return (BTypeSpec)this.get(rateCalcType);
    }

    public void setRateCalcType(BTypeSpec v) {
        this.set(rateCalcType, (BValue)v, null);
    }

    public BAbstractRateType getRateCalc() {
        return (BAbstractRateType)this.get(rateCalc);
    }

    public void setRateCalc(BAbstractRateType v) {
        this.set(rateCalc, (BValue)v, null);
    }

    public BAbsTime getRateCalcTime() {
        return (BAbsTime)this.get(rateCalcTime);
    }

    public void setRateCalcTime(BAbsTime v) {
        this.set(rateCalcTime, (BValue)v, null);
    }

    public void reset() {
        this.invoke(reset, null, null);
    }

    public void set(BLong param) {
        this.invoke(set, (BValue)param, null);
    }

    public void recalculateRate() {
        this.invoke(recalculateRate, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        super.started();
        if (this.isRunning()) {
            if (this.getTotal() < 0L) {
                return;
            }
            BNrio16Module device = (BNrio16Module)this.getDevice();
            int instance = this.getInstance();
            BINrioIoStatus ioStatus = (BINrioIoStatus)device.getIoStatus();
            if (device instanceof BNrio34Module && instance > 8) {
                ioStatus = (BINrioIoStatus)((BNrio34Module)device).getIo34Sec().getIoStatus();
                instance -= 8;
            }
            ioStatus.setTotalCounts(instance, this.getTotal());
            this.doRecalculateRate();
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return super.isParentLegal(parent) && parent instanceof BNumericPoint;
    }

    @Override
    public BReadWriteMode getMode() {
        return BReadWriteMode.readonly;
    }

    @Override
    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (this.isRunning()) {
            if (prop.equals(rateCalcType)) {
                BAbstractRateType type = (BAbstractRateType)this.getRateCalcType().getInstance();
                this.getRateCalc().cleanupType();
                this.setRateCalc(type);
                this.getRateCalc().initType();
                this.setStale(true, null);
            } else if (prop.equals(outputSelect)) {
                this.setStale(true, null);
            } else if (prop.equals(total)) {
                this.doRecalculateRate();
            }
        }
    }

    @Override
    public void ioValueChanged() {
        BINrioIoStatus ioStatus = (BINrioIoStatus)((BNrio16Module)this.getDevice()).getIoStatus();
        int maxUiInstance = ioStatus.getMaxUiInstance();
        if (this.getUiType().getOrdinal() != 2 || this.getInstance() < 1 || this.getInstance() > maxUiInstance) {
            this.readFail("readFail.invalidInstanceOrData");
        } else {
            try {
                long value = ioStatus.getTotalCounts(this.getInstance());
                if (value == this.getTotal()) {
                    this.recalculateRate();
                } else {
                    this.setTotal(value);
                }
            }
            catch (Exception e) {
                this.readFail(e.getMessage());
            }
        }
    }

    public void doReset() {
        this.doSet(BLong.make((long)0L));
    }

    public synchronized void doSet(BLong param) {
        long setValue = param.getLong();
        BNrio16Module device = (BNrio16Module)this.getDevice();
        BINrioIoStatus ioStatus = (BINrioIoStatus)device.getIoStatus();
        int instance = this.getInstance();
        if (device instanceof BNrio34Module && instance > 8) {
            ioStatus = (BINrioIoStatus)((BNrio34Module)device).getIo34Sec().getIoStatus();
            instance -= 8;
        }
        ioStatus.setTotalCounts(instance, setValue);
        this.getRateCalc().resetRate();
        this.setTotal(setValue);
    }

    public void doRecalculateRate() {
        try {
            BStatusNumeric value = this.getRateCalc().calculateRate(this.getTotal());
            if (value != null) {
                this.setRate(value.getValue());
                if (this.getOutputSelect() == BNrio16CounterSelectEnum.rate) {
                    this.readOk((BStatusValue)value);
                } else {
                    this.readOk((BStatusValue)new BStatusNumeric((double)this.getTotal()));
                }
            } else if (this.getOutputSelect() == BNrio16CounterSelectEnum.rate) {
                this.setStale(true, null);
            }
        }
        catch (Exception e) {
            this.readFail(e.getMessage());
        }
    }
}

