/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.messages;

import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.nrio.messages.NrioMessage;
import com.tridium.nrio.messages.NrioMessageConst;
import com.tridium.nrio.messages.NrioOutputStream;
import com.tridium.nrio.messages.NrioReceivedMessage;

public class WriteDownLoadData
extends NrioMessage
implements NrioMessageConst {
    protected int memAddress;
    protected int offset;
    protected byte[] memData;

    public WriteDownLoadData() {
    }

    public WriteDownLoadData(int address, byte[] memData, int memAddress, int offset) {
        this.address = address;
        this.type = 12;
        this.status = 0;
        this.memData = memData;
        this.memAddress = memAddress;
        this.offset = offset;
    }

    @Override
    public byte[] getByteArray() {
        int i;
        int length = 64;
        int padLength = 128 - length;
        if (this.memData.length - this.offset < 64) {
            length = this.memData.length - this.offset;
            padLength = 128 - length;
        }
        NrioOutputStream packet = new NrioOutputStream();
        packet.writeIntRev((length + 1) / 2);
        packet.writeIntRev(this.memAddress + this.offset);
        for (i = this.offset; i < this.offset + length; ++i) {
            packet.write(this.memData[i]);
        }
        for (i = 0; i < padLength; ++i) {
            packet.write(0);
        }
        this.data = packet.toByteArray();
        return super.getByteArray();
    }

    @Override
    public Message toResponse(ReceivedMessage resp) {
        NrioReceivedMessage accessResp = (NrioReceivedMessage)resp;
        NrioMessage respMessage = new NrioMessage();
        respMessage.readResponse(accessResp);
        return respMessage;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }
}

