/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.messages;

import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.nrio.messages.NrioInputStream;
import com.tridium.nrio.messages.NrioMessageConst;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.TextUtil;

public class NrioResponse
extends ReceivedMessage
implements NrioMessageConst {
    protected int transactionId;
    protected int classId;
    protected int classInstance;
    protected int opCode;
    protected byte[] data = new byte[0];

    public void readResponse(byte[] response, int len) {
        NrioInputStream in = new NrioInputStream(response, 0, len);
        in.read();
        int length = in.read() & 0xFF;
        this.transactionId = in.read() & 0xFF;
        this.classId = in.read() & 0xFF;
        this.classInstance = in.read() & 0xFF;
        this.opCode = in.readInt();
        this.data = new byte[in.available()];
        int i = 0;
        while (in.available() > 0) {
            this.data[i++] = (byte)(in.read() & 0xFF);
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public String toString() {
        return this.toDebugString();
    }

    public String toDebugString() {
        StringBuffer sb = new StringBuffer();
        sb.append("NrioMessage       = " + TextUtil.getClassName(this.getClass()));
        sb.append("\n  Tag           = " + this.getTag());
        sb.append("\n  transactionId = " + this.transactionId);
        sb.append("\n  classId       = " + this.classId);
        sb.append("\n  classInstance = " + this.classInstance);
        sb.append("\n  opCode        = " + this.opCode);
        sb.append("\n  data          = " + ByteArrayUtil.toHexString((byte[])this.data));
        return sb.toString();
    }
}

