/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.ext;

import javax.baja.control.BControlPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BPointExtension;
import javax.baja.data.BIDataValue;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

public class BLinearCalibrationExt
extends BPointExtension {
    public static final Property scale = BLinearCalibrationExt.newProperty((int)0, (float)1.0f, (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)5)));
    public static final Property offset = BLinearCalibrationExt.newProperty((int)0, (float)0.0f, (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)5)));
    public static final Property units = BLinearCalibrationExt.newProperty((int)0, (BValue)BUnit.DEFAULT, null);
    public static final Property faultCause = BLinearCalibrationExt.newProperty((int)3, (String)"", null);
    public static final Type TYPE = Sys.loadType(BLinearCalibrationExt.class);

    public float getScale() {
        return this.getFloat(scale);
    }

    public void setScale(float v) {
        this.setFloat(scale, v, null);
    }

    public float getOffset() {
        return this.getFloat(offset);
    }

    public void setOffset(float v) {
        this.setFloat(offset, v, null);
    }

    public BUnit getUnits() {
        return (BUnit)this.get(units);
    }

    public void setUnits(BUnit v) {
        this.set(units, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BLinearCalibrationExt() {
    }

    public BLinearCalibrationExt(BUnit units) {
        this.setUnits(units);
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BNumericPoint;
    }

    public void changed(Property p, Context cx) {
        BControlPoint parent;
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if ((p.equals(scale) || p.equals(offset) || p.equals(units)) && (parent = this.getParentPoint()) != null) {
            this.getParentPoint().execute();
        }
    }

    public void onExecute(BStatusValue o, Context cx) {
        BStatusNumeric out = (BStatusNumeric)o;
        BUnit proxyUnit = (BUnit)this.getPointFacets().get("units", (BObject)BUnit.NULL);
        if (proxyUnit.isConvertible(this.getUnits())) {
            double value = out.getValue();
            double calval = proxyUnit.convertTo(this.getUnits(), value);
            calval = (double)this.getFloat(scale) * calval + (double)this.getFloat(offset);
            value = this.getUnits().convertTo(proxyUnit, calval);
            o.setValueValue((BValue)BDouble.make((double)value));
            this.setFaultCause("");
        } else if (proxyUnit.isNull() || this.getUnits().isNull()) {
            double value = out.getValue();
            value = (double)this.getFloat(scale) * value + (double)this.getFloat(offset);
            o.setValueValue((BValue)BDouble.make((double)value));
            this.setFaultCause("");
        } else {
            o.setStatusFault(true);
            this.setFaultCause("Units between point and extension are not convertible.");
        }
    }
}

