/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.comm;

import com.tridium.basicdriver.UnsolicitedMessageListener;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.nrio.BNrio16Module;
import com.tridium.nrio.BNrio34Module;
import com.tridium.nrio.BNrio34PriModule;
import com.tridium.nrio.BNrio34SecModule;
import com.tridium.nrio.BNrioDevice;
import com.tridium.nrio.BNrioInputOutputModule;
import com.tridium.nrio.BNrioNetwork;
import com.tridium.nrio.comm.MessageElement;
import com.tridium.nrio.comm.NrioComm;
import com.tridium.nrio.comm.TLinkedListManager;
import com.tridium.nrio.components.BIoStatus;
import com.tridium.nrio.components.BNrio16Status;
import com.tridium.nrio.components.BNrio34PriStatus;
import com.tridium.nrio.components.BNrio34SecStatus;
import com.tridium.nrio.messages.NrioMessage;
import com.tridium.nrio.messages.NrioMessageConst;
import com.tridium.nrio.messages.NrioReceivedMessage;
import javax.baja.log.Log;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Clock;
import javax.baja.sys.NotRunningException;

public class NrioUnsolicitedReceive
implements Runnable,
UnsolicitedMessageListener,
NrioMessageConst {
    private static Integer DEFAULT_TAG = new Integer(-1);
    private TLinkedListManager unsolicitedMessageManager = null;
    private BNrioNetwork host;
    private long msgCount = 0L;
    private long rateTicks = 0L;
    private long rateCount = 0L;
    private long processedRateCount = 0L;
    private long droppedByteCount = 0L;
    private long totalProcessTime = 0L;
    private long startTicks = 0L;
    private long invalidMessageCount = 0L;
    private boolean timeToDie = true;
    private Thread myThread;
    private volatile boolean myThreadWaitingForStatusChange = false;
    private static final int UNSOLICITED_THREAD_STOP_TIMEOUT = 10000;

    public NrioUnsolicitedReceive(BNrioNetwork host) {
        this.host = host;
    }

    public final void init() {
    }

    public final void cleanup() {
    }

    public final void start() {
        if (this.host != null && this.host.isFatalFault()) {
            return;
        }
        this.timeToDie = false;
        this.myThread = new Thread((Runnable)this, "NrioUnsolicitedReceive" + this.host.getTrunk());
        this.myThread.setPriority(this.host.getReadThreadPriority());
        this.myThread.start();
        this.startTicks = Clock.ticks();
    }

    public final void stop() {
        if (this.myThread == null) {
            return;
        }
        this.getUnsolicitedLog().trace("Requesting termination of NrioUnsolicitedReceive thread");
        this.timeToDie = true;
        this.myThread.interrupt();
        if (!this.myThreadWaitingForStatusChange) {
            try {
                this.myThread.join(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.myThread.isAlive()) {
                this.getUnsolicitedLog().warning(this.myThread.getName() + " did not terminate in a timely manner, abandoning thread");
            }
        } else {
            this.getUnsolicitedLog().trace(this.myThread.getName() + " blocked on status change, not waiting for thread termination");
        }
        this.myThread = null;
    }

    public boolean isDying() {
        return this.timeToDie;
    }

    public void setThreadPriority(int priority) {
        if (this.myThread == null) {
            return;
        }
        if (priority != this.myThread.getPriority()) {
            this.getUnsolicitedLog().message(this.myThread.getName() + " thread priority changed from " + this.myThread.getPriority() + " to " + priority);
            this.myThread.setPriority(priority);
        }
    }

    public void receiveMessage(ReceivedMessage message) {
        MessageElement msgElement = new MessageElement((NrioReceivedMessage)message);
        if (this.unsolicitedMessageManager != null) {
            this.unsolicitedMessageManager.addToTail(msgElement);
        }
    }

    public Object getUnsolicitedListenerCode() {
        return DEFAULT_TAG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            long lastTicks;
            this.getUnsolicitedLog().message("NrioUnsolicitedReceive thread started.");
            NrioMessage statusMessage = new NrioMessage();
            NrioComm comm = (NrioComm)this.host.getComm();
            byte[] ioStatusBytes = new byte[128];
            byte[] lastIoStatusBytes = new byte[128];
            this.rateTicks = lastTicks = Clock.ticks();
            this.rateCount = this.msgCount;
            this.processedRateCount = this.host.getProcessedUnsolicitedMsgCount();
            while (!this.timeToDie) {
                boolean isPushToPoints = this.host.getPushToPoints();
                comm = (NrioComm)this.host.getComm();
                try {
                    if (this.host.isDownLoadInProcess()) {
                        try {
                            Thread.sleep(500L);
                            continue;
                        }
                        catch (Exception e) {
                            if (!this.timeToDie) continue;
                            break;
                        }
                    }
                    long nowTicks = Clock.ticks();
                    long processTime = nowTicks - lastTicks;
                    if (nowTicks - this.rateTicks > 5000L) {
                        this.host.setUnsolicitedMessageRate((float)(this.msgCount - this.rateCount) * 1000.0f / (float)(nowTicks - this.rateTicks));
                        this.rateCount = this.msgCount;
                        long processedUnsolicitedMsgCount = this.host.getUnsolicitedProcessedCount();
                        this.host.setPushedUnsolicitedMessageRate((float)(processedUnsolicitedMsgCount - this.processedRateCount) * 1000.0f / (float)(nowTicks - this.rateTicks));
                        this.processedRateCount = processedUnsolicitedMsgCount;
                        this.rateTicks = nowTicks;
                    }
                    this.host.setUnsolicitedProcessTime((int)processTime);
                    this.totalProcessTime += processTime;
                    this.getUnsolicitedLog().trace("NrioUnsolicitedReceive processing time = " + processTime);
                    ByteArrayUtil.copy((byte[])ioStatusBytes, (byte[])lastIoStatusBytes);
                    try {
                        this.myThreadWaitingForStatusChange = true;
                        comm.waitForStatusChange(comm.getHandle(), ioStatusBytes);
                    }
                    finally {
                        this.myThreadWaitingForStatusChange = false;
                    }
                    this.host.setUnsolicitedMsgCount(++this.msgCount);
                    lastTicks = Clock.ticks();
                    if (this.host.isDownLoadInProcess()) {
                        this.getUnsolicitedLog().trace("NrioUnsolicitedReceive: wakeup with downLoadInProcess");
                        continue;
                    }
                    int length = (ioStatusBytes[1] & 0xFF) + 2;
                    statusMessage.decodeFromBytes(ioStatusBytes, length);
                    this.getUnsolicitedLog().trace("ioStatusMessage: " + ByteArrayUtil.toHexString((byte[])ioStatusBytes, (int)0, (int)length));
                    if (length < 4 || statusMessage.getType() != 8) {
                        block39: {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Exception e) {
                                if (!this.timeToDie) break block39;
                                break;
                            }
                        }
                        ++this.invalidMessageCount;
                        this.getUnsolicitedLog().trace("received invalid message: " + ByteArrayUtil.toHexString((byte[])ioStatusBytes, (int)0, (int)length));
                        this.getUnsolicitedLog().trace("            last message: " + ByteArrayUtil.toHexString((byte[])lastIoStatusBytes));
                        continue;
                    }
                    BNrioDevice device = this.host.getDevice(statusMessage.getAddress());
                    if (device != null) {
                        if (statusMessage.getStatus() != 0) {
                            device.pingFail("nrioService reports device is down");
                            continue;
                        }
                        if (!device.getFirstPing()) {
                            device.pingOk();
                        }
                        if (device instanceof BNrio34SecModule) {
                            BNrio34SecModule io34Sec = (BNrio34SecModule)device;
                            this.getUnsolicitedLog().trace("IO34.2 module ioStatusMessage: " + ByteArrayUtil.toHexString((byte[])ioStatusBytes, (int)0, (int)length));
                            if (!((BNrio34SecStatus)io34Sec.getIoStatus()).readIoStatus(ioStatusBytes, 0, statusMessage.getLength() + 2)) {
                                ++this.droppedByteCount;
                            }
                            if (!isPushToPoints) continue;
                            BNrio34Module io34Pri = io34Sec.getParentModule();
                            if (io34Pri != null) {
                                io34Sec.getPoints().doPushToPoints();
                                continue;
                            }
                            this.getUnsolicitedLog().error("IO34.2 module ioStatusMessage: IO34.1 module not found!");
                            continue;
                        }
                        if (device instanceof BNrio34Module) {
                            BNrio34PriModule io34Pri = (BNrio34PriModule)device;
                            this.getUnsolicitedLog().trace("IO34.1 module ioStatusMessage: " + ByteArrayUtil.toHexString((byte[])ioStatusBytes, (int)0, (int)length));
                            if (!((BNrio34PriStatus)io34Pri.getIoStatus()).readIoStatus(ioStatusBytes, 0, statusMessage.getLength() + 2)) {
                                ++this.droppedByteCount;
                            }
                            if (!isPushToPoints) continue;
                            io34Pri.getPoints().doPushToPoints();
                            continue;
                        }
                        if (device instanceof BNrio16Module) {
                            BNrio16Module io16Device = (BNrio16Module)device;
                            this.getUnsolicitedLog().trace("Io16 module ioStatusMessage: " + ByteArrayUtil.toHexString((byte[])ioStatusBytes, (int)0, (int)length));
                            if (!((BNrio16Status)io16Device.getIoStatus()).readIoStatus(ioStatusBytes, 0, statusMessage.getLength() + 2)) {
                                ++this.droppedByteCount;
                            }
                            if (!isPushToPoints) continue;
                            io16Device.getPoints().doPushToPoints();
                            continue;
                        }
                        if (device instanceof BNrioInputOutputModule) {
                            this.getUnsolicitedLog().trace("GpIo module ioStatusMessage: " + ByteArrayUtil.toHexString((byte[])ioStatusBytes, (int)0, (int)length));
                            device.setIoStatus(new BIoStatus(ioStatusBytes, 0, statusMessage.getLength() + 2));
                            device.getPoints().setDynamicPoints();
                            continue;
                        }
                        this.getUnsolicitedLog().trace("Other module ioStatusMessage: " + ByteArrayUtil.toHexString((byte[])ioStatusBytes, (int)0, (int)length));
                        device.setIoStatus(new BIoStatus(ioStatusBytes, 0, statusMessage.getLength() + 2));
                        device.getPoints().setDynamicPoints();
                        device.processIoStatusMessage(statusMessage);
                        continue;
                    }
                    this.getUnsolicitedLog().message("nrioService reports unknown device is down: " + statusMessage.getAddress());
                }
                catch (Exception e) {
                    if (this.host == null || this.host.getName() == null) {
                        this.timeToDie = true;
                    }
                    if (this.timeToDie) {
                        break;
                    }
                    if (this.host.isDownLoadInProcess()) {
                        this.getUnsolicitedLog().trace("NrioUnsolicitedReceive: wakeup with downLoadInProcess");
                    } else if (e instanceof NotRunningException) {
                        this.getUnsolicitedLog().message("NotRunningException " + this.host.getName() + ": point just added or removed. ");
                    } else {
                        this.getUnsolicitedLog().error("Exception with " + this.host.getName() + "-NrioUnsolicitedReceive : " + e);
                        String eMessage = e.getMessage();
                        if (eMessage != null && eMessage.equals("wait for status change failed")) {
                            this.host.configFatal("FatalFault! actrld is not running at " + BAbsTime.now());
                            this.timeToDie = true;
                        }
                        e.printStackTrace();
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception e1) {
                        if (!this.timeToDie) continue;
                        break;
                    }
                }
            }
        }
        finally {
            this.getUnsolicitedLog().message("NrioUnsolicitedReceive thread stopped.");
        }
    }

    public BNrioDevice getDevice(NrioReceivedMessage message) {
        int length = message.getLength();
        if (length <= 0) {
            return null;
        }
        int address = message.getBytes()[0] & 0xFF;
        return this.host.getDevice(address);
    }

    public Log getUnsolicitedLog() {
        return Log.getLog((String)(this.host.getName() + ".unsolicited"));
    }

    public long getInvalidMessageCount() {
        return this.invalidMessageCount;
    }

    public long getDroppedByteCount() {
        return this.droppedByteCount;
    }

    public long getTotalProcessTime() {
        return this.totalProcessTime;
    }

    public long getRunTime() {
        return Clock.ticks() - this.startTicks;
    }
}

