/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.comm;

import com.tridium.basicdriver.comm.CommReceiver;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.nrio.messages.NrioMessageConst;
import com.tridium.nrio.messages.NrioReceivedMessage;
import javax.baja.nre.util.ByteBuffer;

public class NrioCommReceiver
extends CommReceiver
implements NrioMessageConst {
    private static final int IDLE = 0;
    private static final int WAIT_FOR_SOH = 1;
    private static final int READ_LENGTH = 2;
    private static final int READ_XID = 3;
    private static final int READ_DATA = 4;
    private int transactionId = 0;
    private int state = 0;
    private int length = 0;
    private ByteBuffer rcvBuffer = new ByteBuffer();
    private NrioReceivedMessage msg = null;

    public void initReceiveState(Message msg) {
        this.rcvBuffer.reset();
        this.state = 1;
    }

    protected ReceivedMessage receive() throws Exception {
        this.state = 1;
        boolean done = false;
        while (!done) {
            int charIn = this.getInputStream().read();
            boolean newChar = charIn != -1;
            charIn &= 0xFF;
            if (!newChar) continue;
            switch (this.state) {
                case 0: {
                    break;
                }
                case 1: {
                    if (charIn != 2) break;
                    this.rcvBuffer.reset();
                    this.rcvBuffer.write((int)((byte)charIn));
                    this.state = 2;
                    break;
                }
                case 2: {
                    this.length = charIn;
                    this.rcvBuffer.write((int)((byte)charIn));
                    this.state = 3;
                    break;
                }
                case 3: {
                    this.rcvBuffer.write((int)((byte)charIn));
                    this.transactionId = charIn;
                    --this.length;
                    this.state = 4;
                    break;
                }
                case 4: {
                    this.rcvBuffer.write((int)((byte)charIn));
                    if (--this.length > 0) break;
                    done = true;
                }
            }
        }
        Integer tag = new Integer(-1);
        if (this.msg == null) {
            this.msg = new NrioReceivedMessage(this.rcvBuffer.getBytes(), this.rcvBuffer.getLength(), tag);
        } else {
            this.msg.setBytes(this.rcvBuffer.getBytes());
            this.msg.setLength(this.rcvBuffer.getLength());
            this.msg.setTag(tag);
        }
        this.state = 1;
        return this.msg;
    }
}

