/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.comm;

import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.comm.CommReceiver;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.basicdriver.util.BasicException;
import com.tridium.nrio.BNrioNetwork;
import com.tridium.nrio.comm.NrioCommReceiver;
import com.tridium.nrio.messages.NrioMessageConst;
import com.tridium.platNrio.BNrioPlatformService;
import java.util.Vector;
import javax.baja.log.Log;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.serial.BISerialPort;
import javax.baja.serial.BISerialService;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class NrioComm
extends Comm
implements NrioMessageConst {
    private static final long MIN_SLEEP_TIME = 10L;
    private boolean localCommStarted = false;
    private String commInitError = null;
    private long lastRecvMessageTicks = 0L;
    private int handle;
    protected BISerialPort port;
    BNrioPlatformService nrioService;
    private long replyTicks = 0L;

    public NrioComm(BNrioNetwork accessNetwork) {
        super((BBasicNetwork)accessNetwork, (CommReceiver)new NrioCommReceiver());
    }

    public boolean isCommStarted() {
        return this.localCommStarted;
    }

    protected boolean started() throws Exception {
        this.localCommStarted = false;
        BNrioNetwork network = (BNrioNetwork)this.getNetwork();
        this.commInitError = null;
        try {
            BISerialService serialService = (BISerialService)Sys.getService((Type)BISerialService.TYPE);
            serialService.checkPropertiesLoaded();
            this.port = serialService.openPort(network.getPortName(), network.getName());
        }
        catch (Exception e) {
            this.commInitError = "Check for duplicate or invalid Port Name";
            this.getNetwork().getLog().error(this.commInitError, (Throwable)e);
            try {
                if (this.port != null) {
                    this.port.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.port = null;
            throw e;
        }
        try {
            String osName = this.port.getOsPortName();
            this.nrioService = (BNrioPlatformService)Sys.getService((Type)BNrioPlatformService.TYPE);
            if (this.nrioService != null) {
                this.handle = this.nrioService.open(network.getTrunk());
                this.nrioService.setPortParams(this.handle, osName, network.getBaudRate().getOrdinal());
            }
            network.getLog().message("Opened " + network.getPortName());
        }
        catch (Exception e) {
            this.commInitError = "Check for duplicate or invalid Trunk assignment.";
            this.getNetwork().getLog().error(this.commInitError, (Throwable)e);
            try {
                if (this.port != null) {
                    this.port.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.nrioService != null) {
                    this.nrioService.close(this.handle);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.port = null;
            this.nrioService = null;
            throw e;
        }
        this.localCommStarted = true;
        return true;
    }

    protected void stopped() throws Exception {
        this.getCommReceiver().setAlive(false);
        try {
            if (this.nrioService != null) {
                this.nrioService.close(this.handle);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.port != null) {
                this.port.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.nrioService = null;
        this.port = null;
        this.localCommStarted = false;
    }

    public void resetCommPort() {
        try {
            ((BNrioNetwork)this.getNetwork()).stopUnsolicitedReceive();
            this.stopped();
            this.started();
            ((BNrioNetwork)this.getNetwork()).startUnsolicitedReceive();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            String error = this.getCommInitError();
            if (error == null) {
                this.getNetwork().configOk();
            } else {
                this.getNetwork().configFail(error);
            }
        }
    }

    public Vector<byte[]> discover() {
        if (this.nrioService != null) {
            return this.nrioService.discover(this.getHandle());
        }
        return null;
    }

    public void enablePolling(int address) {
        if (this.nrioService != null) {
            this.nrioService.enablePolling(this.getHandle(), address);
        }
    }

    public void disablePolling(int address) {
        if (this.nrioService != null) {
            this.nrioService.disablePolling(this.getHandle(), address);
        }
    }

    public void waitForStatusChange(int handle, byte[] reply) {
        if (this.nrioService != null) {
            this.nrioService.waitForStatusChange(this.getHandle(), reply);
        }
    }

    public byte[] sendRequest(byte[] request) {
        try {
            if (this.nrioService == null) {
                return NULL_BA;
            }
            String thread = Thread.currentThread().getName();
            if (this.getLog().isTraceOn()) {
                this.getLog().trace("<" + thread + "> request: " + (Clock.ticks() - this.replyTicks) + " ms " + ByteArrayUtil.toHexString((byte[])request));
            }
            byte[] response = new byte[128];
            long sendTicks = Clock.ticks();
            this.getNetwork().incrementSent();
            this.getNetwork().incrementReceived();
            this.nrioService.sendRequest(this.getHandle(), request, response);
            this.replyTicks = Clock.ticks();
            int respSize = (response[1] & 0xFF) + 2;
            if (respSize > 128) {
                respSize = 128;
            }
            this.getLog().trace("response: " + (this.replyTicks - sendTicks) + " ms " + ByteArrayUtil.toHexString((byte[])response, (int)0, (int)respSize));
            if (response[3] != 0) {
                this.getLog().trace("<" + thread + ">***> request: " + ByteArrayUtil.toHexString((byte[])request));
                this.getLog().trace("<" + thread + ">***> response: " + ByteArrayUtil.toHexString((byte[])response, (int)0, (int)respSize));
                this.getNetwork().incrementTimeouts();
            }
            return response;
        }
        catch (Exception e) {
            this.getLog().error("sendRequest caught Exception: " + e);
            return NULL_BA;
        }
    }

    public Message transmit(Message msg, BRelTime responseTimeout, int retryCount) throws BasicException {
        if (msg == null) {
            return null;
        }
        if (!msg.getResponseExpected()) {
            this.transmitNoResponse(msg);
            return null;
        }
        return super.transmit(msg, responseTimeout, retryCount);
    }

    public void transmitNoResponse(Message msg) throws BasicException {
        if (msg == null) {
            return;
        }
        if (!this.isCommStarted()) {
            throw new BasicException("Communication handler service not started.");
        }
        super.transmitNoResponse(msg);
    }

    public void receive(ReceivedMessage msg) {
        if (msg == null) {
            return;
        }
        this.setReceivedMessageTicks(Clock.ticks());
        super.receive(msg);
    }

    protected void setReceivedMessageTicks(long ticks) {
        this.lastRecvMessageTicks = ticks;
    }

    public String getCommInitError() {
        return this.commInitError;
    }

    public int getHandle() {
        return this.handle;
    }

    public Log getLog() {
        return this.getNetwork().getLog();
    }
}

