/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio;

import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.basicdriver.UnsolicitedMessageListener;
import com.tridium.basicdriver.comm.Comm;
import com.tridium.nrio.BNrio16Module;
import com.tridium.nrio.BNrioDevice;
import com.tridium.nrio.BNrioDeviceFolder;
import com.tridium.nrio.comm.NrioComm;
import com.tridium.nrio.comm.NrioUnsolicitedReceive;
import com.tridium.nrio.components.BIOutputDefaultValues;
import com.tridium.nrio.components.BNrioLearnDeviceEntry;
import com.tridium.nrio.components.BOutputFailsafeConfig;
import com.tridium.nrio.components.BSdiValueConfig;
import com.tridium.nrio.enums.BNrioDeviceTypeEnum;
import com.tridium.nrio.job.BNrioLearnDevicesJob;
import com.tridium.nrio.job.BUpgradeFirmwareJob;
import com.tridium.nrio.messages.NrioMessage;
import com.tridium.nrio.messages.NrioMessageConst;
import com.tridium.nrio.messages.NrioReceivedMessage;
import com.tridium.nrio.messages.PingMessage;
import com.tridium.nrio.messages.ReadBuildInfoMessage;
import com.tridium.nrio.messages.ReadInfoMemoryMessage;
import com.tridium.nrio.messages.ResetMessage;
import com.tridium.nrio.messages.WriteConfigMessage;
import com.tridium.nrio.messages.WriteDOMessage;
import com.tridium.nrio.points.BNrioPointDeviceExt;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Vector;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.ping.BPingMonitor;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.serial.BBaudRate;
import javax.baja.serial.BSerialBaudRate;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BModule;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="portName", type="String", defaultValue="COM2", flags=64), @NiagaraProperty(name="trunk", type="int", defaultValue="1", flags=64), @NiagaraProperty(name="baudRate", type="BBaudRate", defaultValue="BSerialBaudRate.baud115200", flags=1), @NiagaraProperty(name="sdiValueConfig", type="BSdiValueConfig", defaultValue="new BSdiValueConfig()", flags=0), @NiagaraProperty(name="maxDevices", type="int", defaultValue="0", flags=7), @NiagaraProperty(name="writeThreadSleepTime", type="long", defaultValue="100", flags=4), @NiagaraProperty(name="pushToPoints", type="boolean", defaultValue="true", flags=0), @NiagaraProperty(name="minPushTime", type="long", defaultValue="300", flags=4, facets={@Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"millisecond\")")}), @NiagaraProperty(name="maxFailsUntilDown", type="int", defaultValue="3", flags=4), @NiagaraProperty(name="wrPriority", type="boolean", defaultValue="false", flags=4), @NiagaraProperty(name="outputFailsafeConfig", type="BOutputFailsafeConfig", defaultValue="new BOutputFailsafeConfig(8, 180)"), @NiagaraProperty(name="unsolicitedMsgCount", type="long", defaultValue="0L", flags=3), @NiagaraProperty(name="unsolicitedProcessTime", type="int", defaultValue="0", flags=3), @NiagaraProperty(name="unsolicitedMessageRate", type="float", defaultValue="0.0f", flags=3), @NiagaraProperty(name="processedUnsolicitedMsgCount", type="long", defaultValue="0L", flags=7), @NiagaraProperty(name="pushedUnsolicitedMessageRate", type="float", defaultValue="0.0f", flags=3)})
@NiagaraActions(value={@NiagaraAction(name="submitDeviceDiscoveryJob", returnType="BOrd", flags=4), @NiagaraAction(name="upgradeFirmware", returnType="BOrd", flags=4), @NiagaraAction(name="winkDevice", parameterType="BInteger", defaultValue="BInteger.make(0)", flags=4), @NiagaraAction(name="enableWinking", parameterType="BNrioLearnDeviceEntry", defaultValue="new BNrioLearnDeviceEntry()", flags=4), @NiagaraAction(name="disableWinking", parameterType="BNrioLearnDeviceEntry", defaultValue="new BNrioLearnDeviceEntry()", flags=4)})
public class BNrioNetwork
extends BBasicNetwork
implements Runnable,
NrioMessageConst {
    public static final Property monitor = BNrioNetwork.newProperty((int)0, (BValue)BNrioNetwork.makePingMonitor(BRelTime.makeSeconds((int)30)), null);
    private static final BFacets holdTimeFacets = BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"second"), (int)5, (int)120);
    public static final Property portName = BNrioNetwork.newProperty((int)64, (String)"COM2", null);
    public static final Property trunk = BNrioNetwork.newProperty((int)64, (int)1, null);
    public static final Property baudRate = BNrioNetwork.newProperty((int)1, (BValue)BSerialBaudRate.baud115200, null);
    public static final Property sdiValueConfig = BNrioNetwork.newProperty((int)0, (BValue)new BSdiValueConfig(), null);
    public static final Property maxDevices = BNrioNetwork.newProperty((int)7, (int)0, null);
    public static final Property writeThreadSleepTime = BNrioNetwork.newProperty((int)4, (int)100, null);
    public static final Property pushToPoints = BNrioNetwork.newProperty((int)0, (boolean)true, null);
    public static final Property minPushTime = BNrioNetwork.newProperty((int)4, (int)300, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")));
    public static final Property maxFailsUntilDown = BNrioNetwork.newProperty((int)4, (int)3, null);
    public static final Property wrPriority = BNrioNetwork.newProperty((int)4, (boolean)false, null);
    public static final Property outputFailsafeConfig = BNrioNetwork.newProperty((int)0, (BValue)new BOutputFailsafeConfig(8, 180), null);
    public static final Property unsolicitedMsgCount = BNrioNetwork.newProperty((int)3, (long)0L, null);
    public static final Property unsolicitedProcessTime = BNrioNetwork.newProperty((int)3, (int)0, null);
    public static final Property unsolicitedMessageRate = BNrioNetwork.newProperty((int)3, (float)0.0f, null);
    public static final Property processedUnsolicitedMsgCount = BNrioNetwork.newProperty((int)7, (long)0L, null);
    public static final Property pushedUnsolicitedMessageRate = BNrioNetwork.newProperty((int)3, (float)0.0f, null);
    public static final Action submitDeviceDiscoveryJob = BNrioNetwork.newAction((int)4, null);
    public static final Action upgradeFirmware = BNrioNetwork.newAction((int)4, null);
    public static final Action winkDevice = BNrioNetwork.newAction((int)4, (BValue)BInteger.make((int)0), null);
    public static final Action enableWinking = BNrioNetwork.newAction((int)4, (BValue)new BNrioLearnDeviceEntry(), null);
    public static final Action disableWinking = BNrioNetwork.newAction((int)4, (BValue)new BNrioLearnDeviceEntry(), null);
    public static final Type TYPE = Sys.loadType(BNrioNetwork.class);
    public Vector<BNrioDevice> devices = new Vector();
    private NrioUnsolicitedReceive unsolicitedReceive = null;
    private NrioComm nrioComm = null;
    private Thread wrThread;
    public boolean isSecurityLicensed = false;
    public boolean isNrioLicensed = false;
    private boolean downLoadInProcess = false;
    private boolean timeToDie = true;
    private boolean isStarted = false;
    public int logicalAddressMap = 0;
    private TypeUid[] logicalTypeUidMap = new TypeUid[16];
    private long replyTicks = 0L;
    private long unsolicitedProcessedCount = 0L;
    protected static byte[] NULL_BA = new byte[0];
    public static Lexicon lex = Lexicon.make(BNrioNetwork.class);

    public static BPingMonitor makePingMonitor(BRelTime pingTime) {
        BPingMonitor pm = new BPingMonitor();
        pm.setPingFrequency(pingTime);
        return pm;
    }

    public String getPortName() {
        return this.getString(portName);
    }

    public void setPortName(String v) {
        this.setString(portName, v, null);
    }

    public int getTrunk() {
        return this.getInt(trunk);
    }

    public void setTrunk(int v) {
        this.setInt(trunk, v, null);
    }

    public BBaudRate getBaudRate() {
        return (BBaudRate)this.get(baudRate);
    }

    public void setBaudRate(BBaudRate v) {
        this.set(baudRate, (BValue)v, null);
    }

    public BSdiValueConfig getSdiValueConfig() {
        return (BSdiValueConfig)this.get(sdiValueConfig);
    }

    public void setSdiValueConfig(BSdiValueConfig v) {
        this.set(sdiValueConfig, (BValue)v, null);
    }

    public int getMaxDevices() {
        return this.getInt(maxDevices);
    }

    public void setMaxDevices(int v) {
        this.setInt(maxDevices, v, null);
    }

    public long getWriteThreadSleepTime() {
        return this.getLong(writeThreadSleepTime);
    }

    public void setWriteThreadSleepTime(long v) {
        this.setLong(writeThreadSleepTime, v, null);
    }

    public boolean getPushToPoints() {
        return this.getBoolean(pushToPoints);
    }

    public void setPushToPoints(boolean v) {
        this.setBoolean(pushToPoints, v, null);
    }

    public long getMinPushTime() {
        return this.getLong(minPushTime);
    }

    public void setMinPushTime(long v) {
        this.setLong(minPushTime, v, null);
    }

    public int getMaxFailsUntilDown() {
        return this.getInt(maxFailsUntilDown);
    }

    public void setMaxFailsUntilDown(int v) {
        this.setInt(maxFailsUntilDown, v, null);
    }

    public boolean getWrPriority() {
        return this.getBoolean(wrPriority);
    }

    public void setWrPriority(boolean v) {
        this.setBoolean(wrPriority, v, null);
    }

    public BOutputFailsafeConfig getOutputFailsafeConfig() {
        return (BOutputFailsafeConfig)this.get(outputFailsafeConfig);
    }

    public void setOutputFailsafeConfig(BOutputFailsafeConfig v) {
        this.set(outputFailsafeConfig, (BValue)v, null);
    }

    public long getUnsolicitedMsgCount() {
        return this.getLong(unsolicitedMsgCount);
    }

    public void setUnsolicitedMsgCount(long v) {
        this.setLong(unsolicitedMsgCount, v, null);
    }

    public int getUnsolicitedProcessTime() {
        return this.getInt(unsolicitedProcessTime);
    }

    public void setUnsolicitedProcessTime(int v) {
        this.setInt(unsolicitedProcessTime, v, null);
    }

    public float getUnsolicitedMessageRate() {
        return this.getFloat(unsolicitedMessageRate);
    }

    public void setUnsolicitedMessageRate(float v) {
        this.setFloat(unsolicitedMessageRate, v, null);
    }

    public long getProcessedUnsolicitedMsgCount() {
        return this.getLong(processedUnsolicitedMsgCount);
    }

    public void setProcessedUnsolicitedMsgCount(long v) {
        this.setLong(processedUnsolicitedMsgCount, v, null);
    }

    public float getPushedUnsolicitedMessageRate() {
        return this.getFloat(pushedUnsolicitedMessageRate);
    }

    public void setPushedUnsolicitedMessageRate(float v) {
        this.setFloat(pushedUnsolicitedMessageRate, v, null);
    }

    public BOrd submitDeviceDiscoveryJob() {
        return (BOrd)this.invoke(submitDeviceDiscoveryJob, null, null);
    }

    public BOrd upgradeFirmware() {
        return (BOrd)this.invoke(upgradeFirmware, null, null);
    }

    public void winkDevice(BInteger parameter) {
        this.invoke(winkDevice, (BValue)parameter, null);
    }

    public void enableWinking(BNrioLearnDeviceEntry parameter) {
        this.invoke(enableWinking, (BValue)parameter, null);
    }

    public void disableWinking(BNrioLearnDeviceEntry parameter) {
        this.invoke(disableWinking, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(portName) || p.equals(trunk)) {
            if (this.getComm() != null) {
                ((NrioComm)this.getComm()).resetCommPort();
            }
        } else if (p.equals(outputFailsafeConfig)) {
            BDevice[] devices = this.getDevices();
            for (int i = 0; i < devices.length; ++i) {
                if (!(devices[i] instanceof BNrio16Module)) continue;
                BNrio16Module io16 = (BNrio16Module)devices[i];
                ((BIOutputDefaultValues)io16.getOutputDefaultValues()).setCommLossTimeout(this.getOutputFailsafeConfig().getCommLossTimeout());
                ((BIOutputDefaultValues)io16.getOutputDefaultValues()).setStartupTimeout(this.getOutputFailsafeConfig().getStartupTimeout());
                io16.postWriteOutputDefaults();
            }
        }
    }

    public int getWriteThreadPriority() {
        return this.getWrPriority() ? 7 : 5;
    }

    public int getReadThreadPriority() {
        return 5;
    }

    public void setWriteThreadPriority(int priority) {
        if (this.wrThread.getPriority() != priority) {
            this.getLog().message(this.wrThread.getName() + " thread priority changed from " + this.wrThread.getPriority() + " to " + priority);
            this.wrThread.setPriority(priority);
        }
    }

    public void setReadThreadPriority(int priority) {
        this.getUnsolicitedReceive().setThreadPriority(priority);
    }

    public BINavNode[] getNavChildren() {
        this.loadSlots();
        BComponent[] temp = new BComponent[this.getSlotCount()];
        SlotCursor c = this.getProperties();
        int count = 0;
        while (c.nextComponent()) {
            BComponent kid = (BComponent)c.get();
            if (Flags.isHidden((BComplex)this, (Slot)c.property()) || !kid.isNavChild() || kid.getPropertyInParent().isFrozen() && !(kid instanceof BNrioDevice)) continue;
            temp[count++] = kid;
            kid = null;
        }
        BComponent[] result = new BComponent[count];
        System.arraycopy(temp, 0, result, 0, count);
        temp = null;
        c = null;
        return result;
    }

    public Type getDeviceType() {
        return BNrioDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BNrioDeviceFolder.TYPE;
    }

    public final Feature getLicenseFeature() {
        Feature feature = null;
        if (this.getType().getModule().getModuleName().equals("accessDriver")) {
            try {
                feature = Sys.getLicenseManager().getFeature("tridium", "accessControl");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (feature != null) {
                this.isSecurityLicensed = true;
                return feature;
            }
            this.isSecurityLicensed = false;
            throw new FeatureNotLicensedException("accessControl");
        }
        try {
            feature = Sys.getLicenseManager().getFeature("tridium", "nrio");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (feature != null) {
            this.isNrioLicensed = true;
            return feature;
        }
        this.isNrioLicensed = false;
        throw new FeatureNotLicensedException("nrio");
    }

    protected Comm makeComm() {
        return new NrioComm(this);
    }

    public void started() throws Exception {
        BIFile[] downLoadFiles;
        if (!this.isSecurityLicensed && !this.isNrioLicensed) {
            this.getLog().error("network not starting because it is not licensed!");
            return;
        }
        super.started();
        BModule module = TYPE.getModule();
        BIFile downLoadDir = module.findFile(new FilePath("/download"));
        if (downLoadDir == null) {
            this.getLog().message("could not find down load directory");
        }
        if ((downLoadFiles = module.getChildren(downLoadDir)) != null) {
            for (int i = 0; i < downLoadFiles.length; ++i) {
                String fileName = downLoadFiles[i].getFileName();
                try {
                    String type = fileName.substring(1, 5);
                    String tail = fileName.substring(6, fileName.indexOf(46));
                    int delimit = tail.indexOf(95);
                    String interfaceNo = tail.substring(0, delimit);
                    String buildNo = tail.substring(delimit + 1);
                    if (this.get("T" + type) == null) {
                        this.add("T" + type, (BValue)BString.make((String)(interfaceNo + "." + buildNo)), 5);
                        continue;
                    }
                    this.set("T" + type, (BValue)BString.make((String)(interfaceNo + "." + buildNo)));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.timeToDie = false;
        this.wrThread = new Thread((Runnable)this, "NrioWrThread" + this.getTrunk());
        this.wrThread.setPriority(this.getWriteThreadPriority());
        this.wrThread.start();
        this.setMaxDevices(this.getLicenseMaxDevices());
        this.isStarted = true;
    }

    public void stopped() throws Exception {
        this.isStarted = false;
        this.timeToDie = true;
        this.wrThread.interrupt();
        super.stopped();
    }

    public final int getLicenseMaxDevices() {
        Feature feature = this.getLicenseFeature();
        String deviceLimit = feature.get("device.limit");
        if (deviceLimit == null) {
            return 0;
        }
        if (deviceLimit.equals("none")) {
            return 16;
        }
        return feature.geti("device.limit", 0);
    }

    public void startComm() throws Exception {
        try {
            super.startComm();
            this.nrioComm = (NrioComm)this.getComm();
            this.startUnsolicitedReceive();
            this.initLogicalAddressMapV2();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            String error = ((NrioComm)this.getComm()).getCommInitError();
            if (error == null) {
                this.configOk();
            } else {
                this.configFail(error);
            }
        }
    }

    public void stopComm() throws Exception {
        this.stopUnsolicitedReceive();
        super.stopComm();
    }

    public NrioUnsolicitedReceive getUnsolicitedReceive() {
        return this.unsolicitedReceive;
    }

    public void startUnsolicitedReceive() {
        if (this.isDisabled()) {
            return;
        }
        this.unsolicitedReceive = new NrioUnsolicitedReceive(this);
        this.unsolicitedReceive.init();
        this.getComm().registerListener((UnsolicitedMessageListener)this.unsolicitedReceive);
        this.unsolicitedReceive.start();
    }

    public void stopUnsolicitedReceive() {
        try {
            if (this.unsolicitedReceive != null) {
                this.unsolicitedReceive.stop();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initNetwork() {
    }

    public Vector<byte[]> discover() {
        return ((NrioComm)this.getComm()).discover();
    }

    public void enablePolling(int address) {
        if (address == 0) {
            this.getLog().message("cannot enable polling on address 0 !!!");
            return;
        }
        ((NrioComm)this.getComm()).enablePolling(address);
    }

    public void disablePolling(int address) {
        if (address == 0) {
            this.getLog().message("cannot disable polling on address 0 !!!");
            return;
        }
        ((NrioComm)this.getComm()).disablePolling(address);
    }

    public NrioMessage sendReset(int address) {
        return this.sendNrioMessage(new ResetMessage(address));
    }

    public String readBuildInfo(int deviceAddress) {
        StringBuffer version = new StringBuffer();
        ReadBuildInfoMessage req = new ReadBuildInfoMessage(deviceAddress);
        NrioMessage rsp = this.sendNrioMessage(req);
        if (rsp.getStatus() != 0) {
            rsp = this.sendNrioMessage(req);
        }
        if (rsp.getStatus() == 0) {
            version.append(rsp.getData()[0] & 0xFF);
            version.append('.');
            version.append(rsp.getData()[1] & 0xFF);
        }
        return version.toString();
    }

    public void readInfoMemory(int deviceAddress) {
        ReadInfoMemoryMessage req = new ReadInfoMemoryMessage(deviceAddress);
        NrioMessage rsp = this.sendNrioMessage(req);
        if (rsp.getStatus() != 0) {
            return;
        }
        byte[] infoData = rsp.getData();
        System.out.println("             nodeAddr = " + (infoData[0] & 0xFF));
        System.out.println("       numMsgsOurAddr = " + (infoData[1] & 0xFF));
        System.out.println("          numMsgsRcvd = " + (infoData[2] & 0xFF));
        System.out.println("       numBadMsgsRcvd = " + (infoData[3] & 0xFF));
        System.out.println("   numMsgsTransmitted = " + (infoData[4] & 0xFF));
        System.out.println(" numIOStatusCrcErrors = " + (infoData[5] & 0xFF));
        System.out.println("numCardReadsProcessed = " + (infoData[6] & 0xFF));
        System.out.println("  numCardReadsXmitted = " + (infoData[7] & 0xFF));
        System.out.println("    numCardReadErrors = " + (infoData[8] & 0xFF));
        System.out.println("    num485ResetsOnRcv = " + (infoData[9] & 0xFF));
        System.out.println("       lastResetState = " + (infoData[10] & 0xFF));
    }

    public byte[] sendRequest(byte[] request) {
        return ((NrioComm)this.getComm()).sendRequest(request);
    }

    public NrioMessage sendNrioMessage(NrioMessage request) {
        Log configLog;
        if (this.downLoadInProcess) {
            request.setStatus(255);
            return request;
        }
        byte[] msgData = request.getByteArray();
        BNrioDevice device = this.getDevice(msgData[0]);
        int msgType = request.getType();
        if (device != null && device.isWriteOutputDefaultsInProgress() && msgType != 20 && msgType != 21) {
            this.getConfigLog().trace(msgData[0] + ": WriteOutputDefaultsInProgress blocking nrio msgType: 0x" + Integer.toHexString(msgType));
            request.setStatus(255);
            return request;
        }
        if (msgType == 6 && (configLog = this.getConfigLog()).isTraceOn()) {
            configLog.trace("Writing config data to device: " + msgData[0]);
        }
        byte[] response = this.sendRequest(msgData);
        return (NrioMessage)request.toResponse(new NrioReceivedMessage(response, response.length, null));
    }

    public NrioMessage sendDownLoadMessage(NrioMessage request, int retry) {
        for (int i = 0; i <= retry; ++i) {
            BUpgradeFirmwareJob.logger.finer("request: " + ByteArrayUtil.toHexString((byte[])request.getByteArray()));
            byte[] response = this.sendRequest(request.getByteArray());
            BUpgradeFirmwareJob.logger.finer("response: " + ByteArrayUtil.toHexString((byte[])response));
            NrioMessage responseMsg = (NrioMessage)request.toResponse(new NrioReceivedMessage(response, response.length, null));
            if (responseMsg != null && responseMsg.isOk()) {
                return responseMsg;
            }
            if (retry - i > 0) {
                BUpgradeFirmwareJob.logger.finer("sendDownLoadMessage error - retrying " + i + " times");
                continue;
            }
            if (retry <= 0) continue;
            BUpgradeFirmwareJob.logger.finer("sendDownLoadMessage error - returning null");
        }
        return null;
    }

    public static BNrioPointDeviceExt getDeviceExt(BComponent c) {
        BComplex parent = c.getParent();
        while (!(parent instanceof BNrioPointDeviceExt)) {
            if ((parent = parent.getParent()) != null) continue;
            return null;
        }
        return (BNrioPointDeviceExt)parent;
    }

    public BNrioDevice[] getNrioDevices() {
        return (BNrioDevice[])this.getDevices();
    }

    public BNrioDevice getDevice(byte[] uid) {
        BBlob inUid = BBlob.make((byte[])uid);
        BDevice[] devices = this.getDevices();
        for (int i = 0; i < devices.length; ++i) {
            if (!(devices[i] instanceof BNrioDevice) || !((BNrioDevice)devices[i]).getUid().equals((Object)inUid)) continue;
            return (BNrioDevice)devices[i];
        }
        return null;
    }

    public void addDevice(BNrioDevice newDevice) {
        if (newDevice.getAddress() <= 0) {
            this.getLog().message(" adding a device with an invalid address: " + newDevice.getSlotPath());
        } else if (!this.devices.contains((Object)newDevice)) {
            this.devices.add(newDevice);
            this.logicalAddressMap |= 1 << newDevice.getAddress();
            this.logicalTypeUidMap[newDevice.getAddress() - 1] = new TypeUid(newDevice.getDeviceType().getRawInt(), newDevice.getUid().copyBytes());
        }
    }

    public void removeDevice(int address) {
        for (int i = 0; i < this.devices.size(); ++i) {
            if (!(this.devices.elementAt(i) instanceof BNrioDevice) || this.devices.elementAt(i).getAddress() != address) continue;
            this.devices.remove(i);
            this.logicalAddressMap &= ~(1 << address);
            this.logicalTypeUidMap[address - 1] = null;
            return;
        }
        this.getLog().message("could not find device to remove: address = " + address + ", size = " + this.devices.size());
    }

    public BNrioDevice getDevice(int address) {
        for (int i = 0; i < this.devices.size(); ++i) {
            if (!(this.devices.elementAt(i) instanceof BNrioDevice) || this.devices.elementAt(i).getAddress() != address) continue;
            return this.devices.elementAt(i);
        }
        return null;
    }

    public void doEnableWinking(BNrioLearnDeviceEntry learnDevice) {
        if (this.isDownLoadInProcess()) {
            return;
        }
        this.getLog().trace(">>> BNrioDevice(" + this.getName() + ").doEnableWinking");
        int secAddrInt = learnDevice.getSecAddrInt();
        PingMessage req = new PingMessage(learnDevice.getAddress(), learnDevice.getUid().copyBytes(), learnDevice.getDeviceType());
        this.sendNrioMessage(req);
        if (secAddrInt > 0) {
            req = new PingMessage(secAddrInt, learnDevice.getUid().copyBytes(), BNrioDeviceTypeEnum.io34sec);
            this.sendNrioMessage(req);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        WriteConfigMessage cReq = new WriteConfigMessage(learnDevice.getAddress(), 514);
        this.sendNrioMessage(cReq);
        if (secAddrInt > 0) {
            cReq.setAddress(secAddrInt);
            this.sendNrioMessage(cReq);
        }
    }

    public void doDisableWinking(BNrioLearnDeviceEntry learnDevice) {
        WriteDOMessage req = new WriteDOMessage(learnDevice.getAddress(), 0);
        this.sendNrioMessage(req);
        this.disablePolling(learnDevice.getAddress());
    }

    public void doWinkDevice(BInteger value) {
        int address = value.getInt() >> 8;
        int wrValue = (value.getInt() & 0xFF) << 8;
        WriteDOMessage req = new WriteDOMessage(address, wrValue);
        this.sendNrioMessage(req);
    }

    public BOrd doSubmitDeviceDiscoveryJob() {
        if (this.getStatus().isDisabled()) {
            return null;
        }
        BNrioLearnDevicesJob job = new BNrioLearnDevicesJob(this);
        return job.submit(null);
    }

    public BOrd doUpgradeFirmware() {
        if (this.getStatus().isDisabled()) {
            return null;
        }
        BUpgradeFirmwareJob job = new BUpgradeFirmwareJob(this);
        return job.submit(null);
    }

    public void setDownLoadInProcess(boolean value) {
        this.downLoadInProcess = value;
        BDevice[] devices = this.getDevices();
        for (int i = 0; i < devices.length; ++i) {
            if (!(devices[i] instanceof BNrioDevice)) continue;
            if (value) {
                ((BNrioDevice)devices[i]).doDisablePolling();
                continue;
            }
            if (((BNrioDevice)devices[i]).isDisabled()) continue;
            ((BNrioDevice)devices[i]).doEnablePolling();
        }
    }

    public boolean isDownLoadInProcess() {
        return this.downLoadInProcess;
    }

    public void initLogicalAddressMapV2() {
        for (int i = 1; i <= 16; ++i) {
            BNrioDevice device = this.getDevice(i);
            if (device == null) continue;
            int index = i - 1;
            this.logicalTypeUidMap[index] = new TypeUid(device.getDeviceType().getRawInt(), device.getUid().copyBytes());
        }
    }

    public void initLogicalAddressMap() {
        for (int i = 1; i <= 16; ++i) {
            BNrioDevice device = this.getDevice(i);
            if (device != null) {
                this.logicalAddressMap |= 1 << i;
                this.logicalTypeUidMap[i - 1] = new TypeUid(device.getDeviceType().getRawInt(), device.getUid().copyBytes());
                continue;
            }
            this.logicalAddressMap &= ~(1 << i);
            this.logicalTypeUidMap[i - 1] = null;
        }
    }

    public int getLogicalAddress(byte[] uid) {
        BNrioDevice temp = this.getDevice(uid);
        if (temp == null) {
            return -1;
        }
        return temp.getAddress();
    }

    public int getFreeAddressV2(int moduleType, byte[] uid) {
        boolean isReader = moduleType == 7 || moduleType == 6;
        int freeAddress = this.getFreeAddress(isReader);
        if (freeAddress > 0) {
            TypeUid thisTypeUid;
            this.logicalTypeUidMap[freeAddress - 1] = thisTypeUid = new TypeUid(moduleType, uid);
        }
        return freeAddress;
    }

    private int getFreeAddress(boolean isReader) {
        int i;
        int start = 1;
        int maxAddress = 16;
        for (i = start; i <= maxAddress; ++i) {
            if ((this.logicalAddressMap & 1 << i) != 0) continue;
            this.logicalAddressMap |= 1 << i;
            return i;
        }
        maxAddress = 16;
        for (i = start; i <= maxAddress; ++i) {
            if (this.getDevice(i) == null) {
                return -1;
            }
            if (!this.getDevice(i).isDown()) continue;
            return i;
        }
        return -1;
    }

    public int getIo34OtherAddr(int type, byte[] uid) {
        int otherType = type == 11 ? 12 : 11;
        for (int i = 0; i < this.logicalTypeUidMap.length; ++i) {
            TypeUid typeUid = this.logicalTypeUidMap[i];
            if (typeUid == null || !ByteArrayUtil.equals((byte[])uid, (byte[])typeUid.uid) || typeUid.type != otherType) continue;
            return i + 1;
        }
        return -1;
    }

    public void clearAddressUsedV2(int address) {
        int index = address - 1;
        if (index >= this.logicalTypeUidMap.length || index < 0) {
            this.getLog().message(this.getName() + ": clearAddressUsedV2 invalid address: " + address);
            return;
        }
        if (this.logicalTypeUidMap[index] != null) {
            int otherAddr;
            int existingType = this.logicalTypeUidMap[index].type;
            byte[] existingUid = this.logicalTypeUidMap[index].uid;
            this.logicalTypeUidMap[index] = null;
            this.logicalAddressMap &= ~(1 << address);
            if ((existingType == 11 || existingType == 12) && (otherAddr = this.getIo34OtherAddr(existingType, existingUid)) > 0) {
                this.logicalTypeUidMap[otherAddr - 1] = null;
                this.logicalAddressMap &= ~(1 << otherAddr);
            }
        }
    }

    public void clearAddressUsed(int address) {
        this.clearAddressUsedV2(address);
    }

    public BIFile getFirmwareFile(BNrioDeviceTypeEnum type) {
        BIFile[] files = this.getFirmwareFiles(type);
        if (files == null || files.length == 0) {
            return null;
        }
        return files[0];
    }

    public BIFile[] getFirmwareFiles(BNrioDeviceTypeEnum type) {
        BModule module = TYPE.getModule();
        BIFile downLoadDir = module.findFile(new FilePath("/download"));
        if (downLoadDir == null) {
            this.getLog().message("could not find download directory");
            return null;
        }
        BIFile[] downLoadFiles = module.getChildren(downLoadDir);
        String fileName = null;
        if (type.equals((Object)BNrioDeviceTypeEnum.remoteReader)) {
            fileName = "2030";
        } else if (type.equals((Object)BNrioDeviceTypeEnum.remoteInputOutput)) {
            fileName = "2034";
        } else if (type.equals((Object)BNrioDeviceTypeEnum.baseBoardReader)) {
            fileName = "2029";
        } else if (type.equals((Object)BNrioDeviceTypeEnum.io16)) {
            fileName = "2041";
        } else if (type.equals((Object)BNrioDeviceTypeEnum.io16V1)) {
            fileName = "2101";
        } else if (type.equals((Object)BNrioDeviceTypeEnum.io34)) {
            fileName = "2102";
        } else if (type.equals((Object)BNrioDeviceTypeEnum.io34sec)) {
            fileName = "2102";
        }
        if (fileName == null) {
            return null;
        }
        Vector<BIFile> v = new Vector<BIFile>();
        for (int i = 0; i < downLoadFiles.length; ++i) {
            if (downLoadFiles[i].getFileName().indexOf(fileName) <= 0) continue;
            v.add(downLoadFiles[i]);
        }
        if (v.size() > 0) {
            BIFile[] rtnFiles = v.toArray(new BIFile[v.size()]);
            return rtnFiles;
        }
        return null;
    }

    @Override
    public void run() {
        while (!Sys.atSteadyState()) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
        try {
            Thread.sleep(30000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getWrIoLog().message("wrThread running");
        BDevice[] devices = this.getDevices();
        long updateDevicesTicks = Clock.ticks();
        while (!this.timeToDie) {
            try {
                if (Clock.ticks() - updateDevicesTicks > 30000L) {
                    devices = this.getDevices();
                    updateDevicesTicks = Clock.ticks();
                    if (this.wrThread.getPriority() != this.getWriteThreadPriority()) {
                        this.setWriteThreadPriority(this.getWriteThreadPriority());
                    }
                }
                for (int i = 0; i < devices.length; ++i) {
                    if (devices[i] == null || !(devices[i] instanceof BNrioDevice) || !devices[i].isRunning() || devices[i].isDown() || devices[i].isFault() || devices[i].isDisabled()) continue;
                    ((BNrioDevice)devices[i]).doWriteDoValues();
                }
            }
            catch (Exception e) {
                this.getLog().message("WriteDoValues caught Exception: " + e);
            }
            try {
                Thread.sleep(this.getWriteThreadSleepTime());
            }
            catch (Exception exception) {}
        }
    }

    public void interruptWriteThread() {
        this.wrThread.interrupt();
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        try {
            int i;
            long totalProcessTime = this.getUnsolicitedReceive().getTotalProcessTime();
            long runTime = this.getUnsolicitedReceive().getRunTime();
            out.startProps();
            out.trTitle((Object)"NrioUnsolicited", 1);
            out.prop((Object)"Message Count", (Object)new Long(this.getUnsolicitedMsgCount()));
            out.prop((Object)"Avg Process Time(ms)", (Object)new Float((double)totalProcessTime / (double)this.getUnsolicitedMsgCount()));
            out.prop((Object)"Total Process Time(ms)", (Object)new Long(totalProcessTime));
            out.prop((Object)"Total Run Time(ms)", (Object)BRelTime.make((long)runTime));
            out.prop((Object)"Process Usage(%)", (double)new Float((double)totalProcessTime).floatValue() / (double)runTime * 100.0);
            out.prop((Object)"Message Rate", (Object)new Float(this.getUnsolicitedMessageRate()));
            out.prop((Object)"DroppedByteCount", (Object)new Long(this.getUnsolicitedReceive().getDroppedByteCount()));
            out.prop((Object)"InvalidMsgCount", (Object)new Long(this.getUnsolicitedReceive().getInvalidMessageCount()));
            out.endProps();
            out.startProps();
            out.trTitle((Object)"NrioNetwork Device Cache", 1);
            for (i = 0; i < this.devices.size(); ++i) {
                BNrioDevice device = this.devices.elementAt(i);
                String name = "logicalAddr " + device.getAddress() + ": ";
                out.prop((Object)name, (Object)device.getSlotPath());
            }
            out.endProps();
            out.startProps();
            out.trTitle((Object)"LogicalAddressUsedMap", 1);
            out.prop((Object)"map", (Object)Integer.toBinaryString(this.logicalAddressMap));
            out.endProps();
            out.startTable(true);
            out.trTitle((Object)"NrioDevice Info", 3);
            out.w((Object)"<tr>").th((Object)"Addr").th((Object)"Type").th((Object)"UID").w((Object)"</tr>\n");
            for (i = 0; i < this.logicalTypeUidMap.length; ++i) {
                TypeUid typeUid = this.logicalTypeUidMap[i];
                if (typeUid == null) {
                    out.tr((Object)(i + 1), (Object)"", (Object)"");
                    continue;
                }
                int type = typeUid.type;
                byte[] uid = typeUid.uid;
                out.tr((Object)(i + 1), (Object)BNrioDeviceTypeEnum.makeFromRaw(type), (Object)ByteArrayUtil.toHexString((byte[])uid));
            }
            out.endTable();
            out.startProps();
            out.trTitle((Object)"NrioNetwork Device Polling Data", 1);
            out.endProps();
            try {
                AccessController.doPrivileged(() -> {
                    Runtime runtime = Runtime.getRuntime();
                    Process process = runtime.exec("/proc/boot/cat /dev/actrl" + this.getTrunk());
                    InputStream in = process.getInputStream();
                    InputStreamReader inr = new InputStreamReader(in);
                    BufferedReader br = new BufferedReader(inr);
                    out.w((Object)"<pre>\n");
                    String line = br.readLine();
                    while (line != null) {
                        line = this.convertBogusChars(line);
                        out.safe((Object)line).w((Object)"\n");
                        line = br.readLine();
                    }
                    out.w((Object)"</pre>\n");
                    br.close();
                    inr.close();
                    in.close();
                    return null;
                });
            }
            catch (PrivilegedActionException pae) {
                pae.printStackTrace();
                throw pae.getException();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            out.safe((Object)e.getLocalizedMessage());
        }
        out.endProps();
    }

    private String convertBogusChars(String src) {
        StringBuffer buf = new StringBuffer();
        char[] chars = src.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '\t') {
                buf.append("        ");
                continue;
            }
            if (chars[i] == '\u0000') continue;
            buf.append(chars[i]);
        }
        return buf.toString();
    }

    public void dumpLogicalTypeUidMap() {
        for (int i = 0; i < 16; ++i) {
            StringBuffer sb = new StringBuffer();
            sb.append(i + 1).append(": ");
            if (this.logicalTypeUidMap[i] != null) {
                sb.append((Object)BNrioDeviceTypeEnum.makeFromRaw(this.logicalTypeUidMap[i].type)).append(", ");
                sb.append(ByteArrayUtil.toHexString((byte[])this.logicalTypeUidMap[i].uid));
            }
            System.out.println(sb.toString());
        }
        System.out.println();
    }

    public Log getConfigLog() {
        return Log.getLog((String)(this.getName() + ".config"));
    }

    public Log getWrIoLog() {
        return Log.getLog((String)(this.getName() + ".wrIo"));
    }

    public Log getAddressLog() {
        return Log.getLog((String)(this.getName() + ".addrMap"));
    }

    public long getUnsolicitedProcessedCount() {
        return this.unsolicitedProcessedCount;
    }

    public long incUnsolicitedProcessedCount() {
        return ++this.unsolicitedProcessedCount;
    }

    private class TypeUid {
        int type = 0;
        byte[] uid = new byte[0];

        TypeUid(int type, byte[] uid) {
            this.type = type;
            this.uid = uid;
        }

        private boolean isPrimary() {
            return this.type == 11;
        }

        private boolean isSecondary() {
            return this.type == 12;
        }
    }
}

