/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opc.client.ui;

import com.tridium.opc.client.BOpcDASecurity;
import com.tridium.opc.client.BOpcDaClient;
import com.tridium.workbench.propsheet.BFieldEditorSheet;
import javax.baja.gx.BInsets;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BFrame;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbComponentView;

public class BOpcDASecurityView
extends BWbComponentView {
    public static final Type TYPE = Sys.loadType(BOpcDASecurityView.class);
    BFieldEditorSheet sheet;
    final BFrame mainFrame = new BFrame();

    public Type getType() {
        return TYPE;
    }

    public void build() {
        this.sheet = new BFieldEditorSheet();
        this.linkTo((BComponent)this.sheet, (Slot)BFieldEditorSheet.pluginModified, (Slot)setModified);
        this.linkTo((BComponent)this.sheet, (Slot)BFieldEditorSheet.actionPerformed, (Slot)actionPerformed);
        BWbShell shell = this.getWbShell();
        if (shell != null) {
            BGridPane buttons = new BGridPane(2);
            buttons.setColumnAlign(BHalign.fill);
            buttons.setUniformColumnWidth(true);
            buttons.add(null, (BValue)new BButton(shell.getRefreshCommand()));
            buttons.add(null, (BValue)new BButton(shell.getSaveCommand()));
            BEdgePane edge = new BEdgePane();
            edge.setCenter((BWidget)new BBorderPane((BWidget)this.sheet, BBorder.inset, BInsets.DEFAULT));
            edge.setBottom((BWidget)new BBorderPane((BWidget)buttons, 5.0, 5.0, 0.0, 5.0));
            this.setContent((BWidget)edge);
        } else {
            this.setContent((BWidget)this.sheet);
        }
    }

    public void doLoadValue(BObject value, Context cx) {
        this.build();
        this.sheet.loadValue(value, cx);
    }

    public BObject doSaveValue(BObject value, Context cx) throws Exception {
        BObject newValue = this.sheet.saveValue(cx);
        if (newValue instanceof BOpcDASecurity) {
            BOpcDASecurity tempObj = (BOpcDASecurity)newValue;
            this.Validate(tempObj);
        }
        return newValue;
    }

    public void deactivated() {
        super.deactivated();
    }

    public boolean Validate(BOpcDASecurity obj) {
        boolean returnVal = false;
        long result = 0L;
        BLong blnValue = (BLong)((BOpcDaClient)obj.getParent()).invoke(BOpcDaClient.setSecurity, null);
        result = blnValue != null ? blnValue.getLong() : 0L;
        if (result == 0L) {
            returnVal = true;
        } else if (result == 1L) {
            BDialog.error((BWidget)this.sheet, (Object)"NT security interface is not supported by the server");
        } else if (result == 2L) {
            BDialog.error((BWidget)this.sheet, (Object)"Private security interface is not supported by the server");
        } else if (result == -1L) {
            BDialog.error((BWidget)this.sheet, (Object)"NT security logon failed - security interface may not be available currently");
        } else if (result == -2L) {
            BDialog.error((BWidget)this.sheet, (Object)"NT security logon failed");
        } else if (result == -3L) {
            BDialog.error((BWidget)this.sheet, (Object)"Private security logon is currently active");
        } else if (result == -4L) {
            BDialog.error((BWidget)this.sheet, (Object)"Low impersonation level set for NT security logon");
        } else if (result == -5L) {
            BDialog.error((BWidget)this.sheet, (Object)"NT Access denied for the given credentials");
        } else if (result == -6L) {
            BDialog.error((BWidget)this.sheet, (Object)"Private security logon failed. Security interface may not be avilable currently");
        } else if (result == -7L) {
            BDialog.error((BWidget)this.sheet, (Object)"Private security logon failed");
        } else if (result == -8L) {
            BDialog.error((BWidget)this.sheet, (Object)"Access denied for the given private credentials");
        } else if (result == -9L) {
            BDialog.error((BWidget)this.sheet, (Object)"Low authentication level set for private security logon");
        } else if (result == -10L) {
            BDialog.error((BWidget)this.sheet, (Object)"Low impersonation level set for private security logon");
        } else if (result == -11L) {
            BDialog.error((BWidget)this.sheet, (Object)"Private security logoff failed");
        }
        return returnVal;
    }

    public void handleComponentEvent(BComponentEvent event) {
        if (this.sheet != null) {
            this.sheet.handleComponentEvent(event);
        }
    }
}

