/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opc.client.point.ui;

import com.tridium.opc.client.point.BOpcPointDeviceExt;
import com.tridium.opc.client.point.BOpcPointDiscoveryJob;
import com.tridium.opc.client.point.BOpcPointDiscoveryResult;
import com.tridium.opc.client.point.BOpcPointFolder;
import com.tridium.opc.client.point.BOpcProxyExt;
import com.tridium.opc.client.point.ui.BOpcPointManager;
import com.tridium.opc.client.point.ui.OpcPointModel;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.BStringPoint;
import javax.baja.control.BStringWritable;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class OpcPointLearn
extends MgrLearn {
    private static BImage folderImg = BImage.make((BIcon)BIcon.std((String)"folder.png"));
    private static BImage objectImg = BImage.make((BIcon)BIcon.std((String)"object.png"));
    BOpcPointDiscoveryJob job;

    public OpcPointLearn(BOpcPointManager mgr) {
        super((BAbstractManager)mgr);
    }

    public Object[] getChildren(Object discovered) {
        BOpcPointDiscoveryResult r = OpcPointLearn.x(discovered);
        if (!r.getKidCheck()) {
            BWidget.getApplication().enterBusy();
            try {
                r.discover();
                r.lease(10, 10000L);
            }
            finally {
                BWidget.getApplication().exitBusy();
            }
        }
        return r.getChildren(BOpcPointDiscoveryResult.class);
    }

    public final BImage getIcon(Object discovered) {
        if (OpcPointLearn.x(discovered).getFolder()) {
            return folderImg;
        }
        return objectImg;
    }

    public final boolean hasChildren(Object discovered) {
        BOpcPointDiscoveryResult r = OpcPointLearn.x(discovered);
        if (!r.getFolder()) {
            return false;
        }
        boolean b = r.getKidCheck();
        if (!b) {
            return true;
        }
        Object[] o = r.getChildren(BOpcPointDiscoveryResult.class);
        return o.length > 0;
    }

    public final boolean isDepthExpandable(int depth) {
        return true;
    }

    public final boolean isExisting(Object discovered, BComponent db) {
        BOpcPointDiscoveryResult res = OpcPointLearn.x(discovered);
        if (db instanceof BControlPoint) {
            if (res.getFolder()) {
                return false;
            }
            return OpcPointLearn.ext(db).getId().equals(res.getId());
        }
        if (!res.getFolder()) {
            return false;
        }
        return OpcPointLearn.fol(db).getName().equals(res.getName());
    }

    public final boolean isGroup(Object discovered) {
        return OpcPointLearn.x(discovered).getFolder();
    }

    public final boolean isMatchable(Object discovered, BComponent db) {
        BOpcPointDiscoveryResult res = OpcPointLearn.x(discovered);
        if (res.getFolder()) {
            return db instanceof BOpcPointFolder;
        }
        if (res.getMode().isWrite()) {
            if (res.getDataType().isNumeric()) {
                return db instanceof BNumericWritable;
            }
            if (res.getDataType().isBoolean()) {
                return db instanceof BBooleanWritable;
            }
            return db instanceof BStringWritable;
        }
        if (res.getDataType().isNumeric()) {
            return db instanceof BNumericPoint;
        }
        if (res.getDataType().isBoolean()) {
            return db instanceof BBooleanPoint;
        }
        return db instanceof BStringPoint;
    }

    public final void jobComplete(BJob job) {
        this.job = (BOpcPointDiscoveryJob)job;
        job.lease(Integer.MAX_VALUE);
        this.updateRoots(job.getChildComponents());
    }

    public void toRow(Object discovered, MgrEditRow row) throws Exception {
        BObject obj = this.getManager().getCurrentValue();
        BOpcPointDeviceExt dext = null;
        dext = obj instanceof BOpcPointDeviceExt ? (BOpcPointDeviceExt)obj : ((BOpcPointFolder)obj).getOpcPointDeviceExt();
        BOpcPointDiscoveryResult res = OpcPointLearn.x(discovered);
        OpcPointModel m = (OpcPointModel)this.getManager().getModel();
        row.setCell(m.name, (BValue)BString.make((String)res.getName()));
        row.setCell(m.id, (BValue)BString.make((String)res.getId()));
        row.setCell(m.datatype, (BValue)res.getDataType());
        OpcPointLearn.ext(row.getTarget()).setMode(res.getMode());
        BFacets defFacets = dext.getDefaultPointFacets();
        if (!defFacets.isNull() || !res.getFacets().isNull()) {
            BFacets orig = (BFacets)row.getCell(m.deviceFacets);
            BFacets df = BFacets.make((BFacets)orig, (BFacets)defFacets);
            df = BFacets.make((BFacets)df, (BFacets)res.getFacets());
            row.setCell(m.deviceFacets, (BValue)df);
            orig = (BFacets)row.getCell(m.facets);
            BFacets cf = BFacets.make((BFacets)orig, (BFacets)df);
            row.setCell(m.facets, (BValue)cf);
        }
    }

    public final MgrTypeInfo[] toTypes(Object discovered) {
        BOpcPointDiscoveryResult res = OpcPointLearn.x(discovered);
        boolean write = res.getMode().isWrite();
        if (res.getFolder()) {
            return null;
        }
        if (res.getDataType().isNumeric()) {
            if (write) {
                return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BNumericWritable.TYPE), MgrTypeInfo.make((Type)BNumericPoint.TYPE), MgrTypeInfo.make((Type)BStringWritable.TYPE), MgrTypeInfo.make((Type)BStringPoint.TYPE)};
            }
            return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BNumericPoint.TYPE), MgrTypeInfo.make((Type)BStringPoint.TYPE)};
        }
        if (res.getDataType().isBoolean()) {
            if (write) {
                return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BBooleanWritable.TYPE), MgrTypeInfo.make((Type)BBooleanPoint.TYPE), MgrTypeInfo.make((Type)BStringWritable.TYPE), MgrTypeInfo.make((Type)BStringPoint.TYPE)};
            }
            return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BBooleanPoint.TYPE), MgrTypeInfo.make((Type)BStringPoint.TYPE)};
        }
        if (write) {
            return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BStringWritable.TYPE), MgrTypeInfo.make((Type)BStringPoint.TYPE)};
        }
        return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BStringPoint.TYPE)};
    }

    protected MgrColumn[] makeColumns() {
        return new MgrColumn[]{new MgrColumn.Name(), new MgrColumn.Prop(BOpcPointDiscoveryResult.id), new MgrColumn.Prop(BOpcPointDiscoveryResult.dataType), new MgrColumn.Prop(BOpcPointDiscoveryResult.mode), new MgrColumn.Prop(BOpcPointDiscoveryResult.facets)};
    }

    private static BOpcProxyExt ext(Object o) {
        return (BOpcProxyExt)((BControlPoint)o).getProxyExt();
    }

    private static BOpcPointFolder fol(Object o) {
        return (BOpcPointFolder)o;
    }

    private static BOpcPointDiscoveryResult x(Object discovered) {
        return (BOpcPointDiscoveryResult)discovered;
    }
}

