/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.exporttags.util;

import com.tridium.exporttags.BNiagaraExportTag;
import com.tridium.exporttags.util.ExportTagException;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Type;
import javax.baja.util.BNameMap;

public final class ExportTagUtil {
    public static final Log log = Log.getLog((String)BNiagaraExportTag.TYPE.getModule().getModuleName());

    public static String getRelativeSlotPath(BComponent base, BComponent sel) {
        if (base == null || sel == null) {
            return null;
        }
        Array slots = new Array(String.class);
        if (sel != base) {
            while (sel != null && sel != base) {
                slots.add((Object)sel.getName());
                sel = (BComponent)sel.getParent();
            }
        }
        slots = slots.reverse();
        String[] slotStrs = (String[])slots.trim();
        StringBuffer buff = new StringBuffer();
        buff.append("slot:");
        for (int i = 0; i < slotStrs.length; ++i) {
            if (i > 0) {
                buff.append("/");
            }
            buff.append(slotStrs[i]);
        }
        return buff.toString();
    }

    public static String filterInvalidSlashesFromPath(String path) {
        if (path.length() == 0) {
            return path;
        }
        if (path.equals("slot:/")) {
            return path;
        }
        StringBuffer buff = new StringBuffer(path.trim());
        while (buff.indexOf("//") > -1) {
            TextUtil.replace((StringBuffer)buff, (String)"//", (String)"/");
        }
        if (buff.toString().equals("slot:/")) {
            return buff.toString();
        }
        if (buff.charAt(buff.length() - 1) == '/') {
            buff.deleteCharAt(buff.length() - 1);
        }
        return buff.toString();
    }

    public static BComponent createFolderPath(BComponent base, BComponent source, BOrd slotPathOrd, Type folderType, Context cx) throws Exception {
        if (slotPathOrd.isNull()) {
            return base;
        }
        OrdQuery[] queries = slotPathOrd.parse();
        if (queries.length != 1) {
            throw new ExportTagException("expTag.shouldUseSlot", new String[]{slotPathOrd.toString(), source.toPathString()});
        }
        if (!(queries[0] instanceof SlotPath)) {
            throw new ExportTagException("expTag.shouldUseSlot", new String[]{slotPathOrd.toString(), source.toPathString()});
        }
        SlotPath path = (SlotPath)queries[0];
        String[] names = path.getNames();
        BComponent currentParent = base;
        for (int i = 0; i < names.length; ++i) {
            BComponent comp = (BComponent)currentParent.get(names[i]);
            if (comp == null) {
                ExportTagUtil.updateDisplayNames(currentParent, names[i], SlotPath.unescape((String)names[i]));
                comp = (BComponent)folderType.getInstance();
                currentParent.add(names[i], (BValue)comp, cx);
            }
            currentParent = comp;
        }
        return currentParent;
    }

    public static void updateDisplayNames(BComponent comp, String name, String displayName) {
        BNameMap displayNamesMap = (BNameMap)comp.get("displayNames");
        if (displayNamesMap != null) {
            displayNamesMap = BNameMap.remove((BNameMap)displayNamesMap, (String)name);
            if (!name.equals(displayName) && displayName.length() > 0) {
                displayNamesMap = BNameMap.make((BNameMap)displayNamesMap, (String)name, (String)displayName);
                comp.set("displayNames", (BValue)displayNamesMap);
            } else if (!displayNamesMap.isNull()) {
                comp.set("displayNames", (BValue)displayNamesMap);
            } else {
                comp.remove("displayNames");
            }
        } else if (!name.equals(displayName) && displayName.length() > 0) {
            displayNamesMap = BNameMap.make((BNameMap)BNameMap.DEFAULT, (String)name, (String)displayName);
            comp.add("displayNames", (BValue)displayNamesMap, 261);
        }
    }
}

