/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.exporttags.tags;

import com.tridium.exporttags.BNiagaraExportTag;
import com.tridium.exporttags.util.ExportTagException;
import com.tridium.exporttags.util.OrdVariableProcessor;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.file.BFileOverwritePolicy;
import com.tridium.nd.file.BNiagaraFileDeviceExt;
import com.tridium.nd.file.BNiagaraFileImport;
import com.tridium.nd.util.BSimpleMap;
import com.tridium.nv.NiagaraVirtualUtil;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BCategoryService;
import javax.baja.control.trigger.BManualTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.data.BIDataValue;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.nd.BINiagaraStation;
import javax.baja.nre.util.FileUtil;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

public final class BFileImportTag
extends BNiagaraExportTag {
    public static final Property stationSlotPath = BFileImportTag.newProperty((int)0, (BValue)BOrd.make((String)"slot:files"), (BFacets)BFileImportTag.makeStationSlotPathFacets());
    public static final Property fileImportName = BFileImportTag.newProperty((int)0, (BValue)BFormat.make((String)"%defaultFileImportName%"), null);
    public static final Property file = BFileImportTag.newProperty((int)0, (BValue)BOrd.make((String)"file:^"), null);
    public static final Property supervisorDirectory = BFileImportTag.newProperty((int)0, (BValue)BOrd.make((String)"file:^nstations$(stationName)$(currentLocation)"), (BFacets)BFacets.make((String)"fieldEditor", (String)"exportTags:OrdVariableFE"));
    public static final Property fileOverwritePolicy = BFileImportTag.newProperty((int)0, (BValue)BFileOverwritePolicy.checksum, null);
    public static final Property executionTime = BFileImportTag.newProperty((int)0, (BValue)BManualTriggerMode.make(), null);
    public static final Property useCategoryMask = BFileImportTag.newProperty((int)0, (boolean)true, null);
    public static final Type TYPE = Sys.loadType(BFileImportTag.class);
    private String cachedDefaultFileName = "";

    public BFormat getFileImportName() {
        return (BFormat)this.get(fileImportName);
    }

    public void setFileImportName(BFormat v) {
        this.set(fileImportName, (BValue)v, null);
    }

    public BOrd getFile() {
        return (BOrd)this.get(file);
    }

    public void setFile(BOrd v) {
        this.set(file, (BValue)v, null);
    }

    public BOrd getSupervisorDirectory() {
        return (BOrd)this.get(supervisorDirectory);
    }

    public void setSupervisorDirectory(BOrd v) {
        this.set(supervisorDirectory, (BValue)v, null);
    }

    public BFileOverwritePolicy getFileOverwritePolicy() {
        return (BFileOverwritePolicy)this.get(fileOverwritePolicy);
    }

    public void setFileOverwritePolicy(BFileOverwritePolicy v) {
        this.set(fileOverwritePolicy, (BValue)v, null);
    }

    public BTriggerMode getExecutionTime() {
        return (BTriggerMode)this.get(executionTime);
    }

    public void setExecutionTime(BTriggerMode v) {
        this.set(executionTime, (BValue)v, null);
    }

    public boolean getUseCategoryMask() {
        return this.getBoolean(useCategoryMask);
    }

    public void setUseCategoryMask(boolean v) {
        this.setBoolean(useCategoryMask, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    protected void doJoin(BINiagaraStation station, BJob job, Subscriber sub, BCategoryMask mask, Context cx) throws Exception {
        if (this.getFile().isNull()) {
            throw new ExportTagException("fileImpExpTag.noFileOrd");
        }
        OrdQuery[] fileQueries = this.getFile().parse();
        if (fileQueries.length > 1) {
            throw new ExportTagException("fileImpExpTag.invalidFileOrd", this.getFile().toString());
        }
        if (!(fileQueries[0] instanceof FilePath)) {
            throw new ExportTagException("fileImpExpTag.invalidFileOrd", this.getFile().toString());
        }
        BIFile sourceFile = (BIFile)this.getFile().get((BObject)this);
        this.cachedDefaultFileName = FileUtil.getBase((String)sourceFile.getFileName());
        if (this.getSupervisorDirectory().isNull()) {
            throw new ExportTagException("fileImpExpTag.noSupOrd");
        }
        BNiagaraStation niagaraStation = (BNiagaraStation)station;
        OrdVariableProcessor processor = new OrdVariableProcessor();
        processor.add(new OrdVariableProcessor.Replace("stationName", "/" + niagaraStation.getName()));
        processor.add(new CurrentLocationHandler(sourceFile));
        BOrd newSupOrd = BOrd.make((String)processor.process(this.getSupervisorDirectory()).toString());
        OrdQuery[] dirQueries = newSupOrd.parse();
        if (dirQueries.length != 1) {
            throw new ExportTagException("fileImpExpTag.invalidSupDirOrd", newSupOrd.toString());
        }
        if (!(dirQueries[0] instanceof FilePath)) {
            throw new ExportTagException("fileImpExpTag.invalidSupDirOrd", newSupOrd.toString());
        }
        if (!sourceFile.isDirectory()) {
            newSupOrd = BOrd.make((OrdQuery)((FilePath)dirQueries[0]).merge(sourceFile.getFileName()));
        }
        BNiagaraFileDeviceExt deviceExt = niagaraStation.getFiles();
        sub.subscribe((BComponent)deviceExt);
        String fileImpName = this.getFileImportName().format((Object)this);
        if (!SlotPath.isValidName((String)fileImpName)) {
            fileImpName = SlotPath.escape((String)fileImpName);
        }
        BNiagaraFileImport fileImp = (BNiagaraFileImport)NiagaraVirtualUtil.findInstance((BComponent)deviceExt, (String)fileImpName, (Type)BNiagaraFileImport.TYPE);
        fileImp.getExecutionTime().set(BTimeTrigger.triggerMode, (BValue)this.getExecutionTime(), cx);
        fileImp.set(BNiagaraFileImport.files, (BValue)BSimpleMap.make((BSimpleMap)BSimpleMap.DEFAULT, (BSimple)newSupOrd, (BSimple)this.getFile()), cx);
        fileImp.set(BNiagaraFileImport.fileOverwritePolicy, (BValue)this.getFileOverwritePolicy(), cx);
        if (this.getUseCategoryMask()) {
            BCategoryService categorySrv = (BCategoryService)Sys.getService((Type)BCategoryService.TYPE);
            categorySrv.setOrdMap(categorySrv.getOrdMap().setCategoryMask(newSupOrd, mask));
        }
        this.addTarget(fileImpName, (BComplex)fileImp, cx);
        fileImp.doExecute();
    }

    public String getDefaultFileImportName() {
        return this.cachedDefaultFileName + "Import";
    }

    public static final class CurrentLocationHandler
    implements OrdVariableProcessor.IVarHandler {
        private BIFile sourceFile;

        public CurrentLocationHandler(BIFile sourceFile) {
            this.sourceFile = sourceFile;
        }

        @Override
        public boolean accept(String var) {
            return var.equals("currentLocation");
        }

        @Override
        public BFacets get() {
            String pathStr;
            FilePath path = this.sourceFile.getFilePath().getParent();
            if (path == null) {
                path = this.sourceFile.getFilePath();
            }
            if ((pathStr = path.getBody()).startsWith("^")) {
                pathStr = pathStr.substring(1, pathStr.length());
            }
            if (pathStr.startsWith("!")) {
                pathStr = pathStr.substring(1, pathStr.length());
            }
            if (pathStr.startsWith("/")) {
                pathStr = pathStr.substring(1, pathStr.length());
            }
            if (pathStr.length() > 0) {
                pathStr = "/" + pathStr;
            }
            return BFacets.make((String)"currentLocation", (BIDataValue)BString.make((String)pathStr));
        }
    }
}

