/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.hierarchy;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import javax.baja.hierarchy.BHierarchy;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.role.BIRole;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BModule;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"baja:IRole"})})
@NiagaraProperty(name="hierarchyNames", type="String", defaultValue="", flags=5)
public class BRoleHierarchies
extends BComponent
implements BIMixIn {
    public static final Property hierarchyNames = BRoleHierarchies.newProperty((int)5, (String)"", null);
    public static final Type TYPE = Sys.loadType(BRoleHierarchies.class);
    private final Object LIST_LOCK;
    private static final String NAMES_DELIMITER = ",";

    public String getHierarchyNames() {
        return this.getString(hierarchyNames);
    }

    public void setHierarchyNames(String v) {
        this.setString(hierarchyNames, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BRoleHierarchies() {
        this.LIST_LOCK = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BRoleHierarchies(BHierarchy[] hierarchies) {
        Object object = this.LIST_LOCK = new Object();
        synchronized (object) {
            TreeSet<String> set = new TreeSet<String>();
            for (BHierarchy hierarchy : hierarchies) {
                set.add(hierarchy.getName());
            }
            this.setHierarchyNames(BRoleHierarchies.delimitHierarchies(set));
        }
    }

    public String getDisplayNameInParent(Context cx) {
        return Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getText("roleHierarchies");
    }

    public boolean isNavChild() {
        return false;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BIRole;
    }

    public BIRole getRole() {
        return (BIRole)this.getParent();
    }

    public Set<String> getHierarchySet() {
        return BRoleHierarchies.splitHierarchies(this.getHierarchyNames());
    }

    public boolean hasHierarchy(BHierarchy hierarchy) {
        return this.hasHierarchy(hierarchy.getName());
    }

    public boolean hasHierarchy(String hierarchyName) {
        return this.getHierarchySet().contains(hierarchyName);
    }

    public void addHierarchy(BHierarchy hierarchy) {
        this.addHierarchy(hierarchy.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHierarchy(String hierarchyName) {
        Object object = this.LIST_LOCK;
        synchronized (object) {
            Set<String> set = this.getHierarchySet();
            set.add(hierarchyName);
            this.setHierarchyNames(BRoleHierarchies.delimitHierarchies(set));
        }
    }

    public synchronized boolean equivalent(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        return this.getHierarchySet().equals(((BRoleHierarchies)((Object)obj)).getHierarchySet());
    }

    public void removeHierarchy(BHierarchy hierarchy) {
        this.removeHierarchy(hierarchy.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHierarchy(String hierarchyName) {
        Object object = this.LIST_LOCK;
        synchronized (object) {
            Set<String> set = this.getHierarchySet();
            set.remove(hierarchyName);
            this.setHierarchyNames(BRoleHierarchies.delimitHierarchies(set));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameHierarchy(String oldName, String newName) {
        Object object = this.LIST_LOCK;
        synchronized (object) {
            Set<String> set = this.getHierarchySet();
            if (set.remove(oldName)) {
                set.add(newName);
                this.setHierarchyNames(BRoleHierarchies.delimitHierarchies(set));
            }
        }
    }

    private static Set<String> splitHierarchies(String hierarchies) {
        String[] hierarchyArray = hierarchies.split(NAMES_DELIMITER);
        if (hierarchyArray.length > 0) {
            TreeSet<String> set = new TreeSet<String>();
            for (String hierarchy : hierarchyArray) {
                if (hierarchy == null || hierarchy.isEmpty()) continue;
                set.add(hierarchy);
            }
            return set;
        }
        return Collections.emptySet();
    }

    public static String delimitHierarchies(Set<String> hierarchies) {
        StringBuilder hierarchyString = new StringBuilder();
        hierarchies.stream().filter(hierarchy -> hierarchy != null).forEach(hierarchy -> hierarchyString.append((String)hierarchy).append(NAMES_DELIMITER));
        int len = hierarchyString.length();
        if (len > 1) {
            hierarchyString.deleteCharAt(len - 1);
        }
        return hierarchyString.toString();
    }

    public String toString(Context cx) {
        StringBuilder buf = new StringBuilder();
        for (String s : this.getHierarchySet()) {
            buf.append(SlotPath.unescape((String)s) + ", ");
        }
        int len = buf.length();
        if (len > 2) {
            buf.delete(len - 2, len - 1);
        }
        return buf.toString();
    }
}

