/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hierarchy.fox;

import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.BIFoxProxySpace;
import com.tridium.hierarchy.fox.BFoxHierarchyChannel;
import com.tridium.history.BIHistoryNavSupport;
import javax.baja.hierarchy.BHierarchySpace;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;

@NiagaraType(agent={@AgentOn(types={"fox:FoxSession"})})
public class BFoxHierarchySpace
extends BHierarchySpace
implements BIFoxProxySpace {
    public static final Type TYPE = Sys.loadType(BFoxHierarchySpace.class);
    private BOrd ord;
    private BFoxHierarchyChannel channel;
    private BINavNode[] navChildCache;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BFoxHierarchySpace() {
        super("hierarchy", LexiconText.make((String)"hierarchy", (String)"space.hierarchy"));
    }

    public BOrd getNavOrd() {
        if (this.ord == null) {
            this.ord = BOrd.make((String)(this.getFoxSession().getNavOrd() + "|hierarchy:"));
        }
        return this.ord;
    }

    @Override
    public BINavNode[] getNavChildren() {
        if (this.navChildCache == null || BIHistoryNavSupport.getHistoryNavSupport() != null && BIHistoryNavSupport.getHistoryNavSupport().performingRefresh((BINavNode)this)) {
            this.navChildCache = super.getNavChildren();
        }
        return this.navChildCache;
    }

    public void init(BFoxSession foxSession) throws Exception {
        BFoxChannelRegistry channels = foxSession.getConnection().getChannels();
        this.channel = (BFoxHierarchyChannel)channels.get("hierarchy", BFoxHierarchyChannel.TYPE);
    }

    public void cleanup(BFoxSession foxSession) throws Exception {
    }

    public BFoxHierarchyChannel channel() {
        return this.channel;
    }

    public BFoxSession getFoxSession() {
        return (BFoxSession)this.getNavParent();
    }
}

