/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hierarchy;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.baja.data.BIDataValue;
import javax.baja.hierarchy.BGroupLevelDef;
import javax.baja.hierarchy.BHierarchy;
import javax.baja.hierarchy.BIGroupingLevelDef;
import javax.baja.hierarchy.BLevelDef;
import javax.baja.hierarchy.BLevelElem;
import javax.baja.hierarchy.BLevelSort;
import javax.baja.hierarchy.BListLevelDef;
import javax.baja.hierarchy.BNamedGroupDef;
import javax.baja.hierarchy.BQueryLevelDef;
import javax.baja.hierarchy.BRelationLevelDef;
import javax.baja.hierarchy.BRoleHierarchies;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.role.BIRole;
import javax.baja.sys.BFacets;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;

public final class HierarchyUtil {
    private static final Logger LOGGER = Logger.getLogger("hierarchy");
    public static final Pattern RELATION_ID_SPLIT = Pattern.compile("\\s*,\\s*");

    private HierarchyUtil() {
    }

    public static boolean canCurrentUserViewHierarchy(BHierarchy hierarchy) {
        if (hierarchy == null) {
            return false;
        }
        BUser user = HierarchyUtil.getUser();
        if (user == null) {
            return true;
        }
        if (user.getPermissions().isSuperUser()) {
            return true;
        }
        String name = hierarchy.getName();
        for (BIRole role : user.getRoleSet()) {
            BRoleHierarchies roleHierarchies = (BRoleHierarchies)role.asObject().asComponent().getMixIn(BRoleHierarchies.TYPE);
            if (!roleHierarchies.hasHierarchy(name)) continue;
            return true;
        }
        return false;
    }

    public static BUser getUser() {
        BUser user = BUser.getCurrentAuthenticatedUser();
        if (user == null) {
            return null;
        }
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        if (!userService.canLogin(user)) {
            throw new IllegalStateException("Error using user to resolve hierarchy permissions");
        }
        return user;
    }

    @SafeVarargs
    public static Context createQueryContext(BUser user, Context context, BLevelElem parent, Map.Entry<String, BIDataValue> ... additionalFacets) {
        if (context == null && parent == null && (additionalFacets == null || additionalFacets.length <= 0)) {
            return user;
        }
        HashMap<String, BIDataValue> map = new HashMap<String, BIDataValue>();
        if (context != null) {
            HierarchyUtil.addFacetsToMap(context.getFacets(), map);
        }
        if (parent != null) {
            HierarchyUtil.addFacetsToMap(parent.getContextParams(), map);
        }
        if (additionalFacets != null) {
            for (Map.Entry<String, BIDataValue> additionalFacet : additionalFacets) {
                map.put(additionalFacet.getKey(), additionalFacet.getValue());
            }
        }
        return new BasicContext(user, BFacets.make(map));
    }

    private static void addFacetsToMap(BFacets facets, Map<String, BIDataValue> facetMap) {
        if (facets != null) {
            for (String key : facets.list()) {
                facetMap.put(key, (BIDataValue)facets.getFacet(key));
            }
        }
    }

    public static BLevelSort getDefSort(BLevelDef def) {
        Type type = def.getType();
        if (type == BGroupLevelDef.TYPE) {
            return ((BGroupLevelDef)def).getSort();
        }
        if (type == BListLevelDef.TYPE) {
            return ((BListLevelDef)def).getSort();
        }
        if (type == BQueryLevelDef.TYPE) {
            return ((BQueryLevelDef)def).getSort();
        }
        if (type == BRelationLevelDef.TYPE) {
            return ((BRelationLevelDef)def).getSort();
        }
        throw new IllegalStateException("Child level def type " + type + " not supported");
    }

    public static String getGroupingBase(BLevelDef levelDef, boolean areGroupingQueriesEnabled, BLevelElem parentElem) {
        String result = "";
        if (levelDef.getPrevious() instanceof BIGroupingLevelDef && areGroupingQueriesEnabled) {
            String parentPredicate;
            String string = parentPredicate = parentElem != null ? parentElem.getChildPredicate() : null;
            if (parentPredicate != null) {
                result = parentPredicate + " and ";
            }
        }
        return result;
    }

    public static Optional<String> getExcludeEmptyGroupsQuery(BGroupLevelDef levelDef) {
        StringBuilder query = new StringBuilder();
        boolean foundQueryDef = false;
        for (BLevelDef nextDef = levelDef.getNext(); nextDef != null; nextDef = nextDef.getNext()) {
            Type nextDefType = nextDef.getType();
            if (nextDefType == BGroupLevelDef.TYPE) {
                if (HierarchyUtil.appendGroupDefQuery((BGroupLevelDef)nextDef, query)) continue;
                return Optional.empty();
            }
            if (nextDefType == BListLevelDef.TYPE) {
                if (HierarchyUtil.appendListDefQueries((BListLevelDef)nextDef, query)) continue;
                return Optional.empty();
            }
            if (nextDefType == BQueryLevelDef.TYPE) {
                if (!HierarchyUtil.appendQueryDefQuery((BQueryLevelDef)nextDef, query)) {
                    return Optional.empty();
                }
                foundQueryDef = true;
                break;
            }
            if (nextDefType == BRelationLevelDef.TYPE) {
                BRelationLevelDef relationDef = (BRelationLevelDef)nextDef;
                LOGGER.fine(() -> "Subsequent relation level def " + relationDef.getName() + " is not supported with a grouping level def.");
                return Optional.empty();
            }
            BLevelDef unknownDef = nextDef;
            LOGGER.fine(() -> "Subsequent level def " + unknownDef.getName() + " of type " + unknownDef.getType() + " is not supported with a grouping level def.");
            return Optional.empty();
        }
        if (foundQueryDef) {
            return Optional.of(query.toString());
        }
        return Optional.empty();
    }

    private static boolean appendGroupDefQuery(BGroupLevelDef groupDef, StringBuilder query) {
        String groupBy = groupDef.getGroupBy().trim();
        if (groupBy.isEmpty()) {
            LOGGER.fine(() -> "Subsequent group level def " + groupDef.getName() + " has no groupBy value.");
            return false;
        }
        query.append(" and (").append(groupBy).append(')');
        return true;
    }

    private static boolean appendListDefQueries(BListLevelDef listDef, StringBuilder query) {
        int namedQueryCount = 0;
        StringJoiner namedGroupQueries = new StringJoiner(") or (", "(", ")");
        for (BNamedGroupDef namedGroupDef : (BNamedGroupDef[])listDef.getChildren(BNamedGroupDef.class)) {
            String namedQuery = namedGroupDef.getQuery().trim();
            if (namedQuery.isEmpty()) continue;
            namedGroupQueries.add(namedQuery);
            ++namedQueryCount;
        }
        if (namedQueryCount > 0) {
            query.append(" and (").append(namedGroupQueries).append(')');
            return true;
        }
        LOGGER.fine(() -> "Subsequent list level def " + listDef.getName() + " has no named group defs with non-empty queries.");
        return false;
    }

    private static boolean appendQueryDefQuery(BQueryLevelDef queryDef, StringBuilder query) {
        if (!queryDef.getIncludeGroupingQueries()) {
            return true;
        }
        String queryDefQuery = queryDef.getQuery().trim();
        if (queryDefQuery.isEmpty()) {
            LOGGER.fine(() -> "Subsequent query level def " + queryDef.getName() + " query is empty.");
            return false;
        }
        query.append(" and (").append(queryDefQuery).append(')');
        return true;
    }

    public static BOrd getTraverseBaseOrd(BLevelElem parent) {
        BOrd parentOrd;
        if (parent != null && !(parentOrd = parent.getEntityOrd()).isNull()) {
            return parentOrd;
        }
        return null;
    }

    public static Optional<String> getTraverseNeqlPredicate(String relationId, boolean inbound, String filterExpression) {
        if ((relationId = relationId.trim()).isEmpty()) {
            return Optional.empty();
        }
        String neql = "neql:traverse " + relationId + (inbound ? "<-" : "->");
        if (!filterExpression.isEmpty()) {
            neql = neql + " where (" + filterExpression + ')';
        }
        return Optional.of(neql);
    }

    public static BLevelElem findElem(String name, BLevelElem[] elems) {
        for (BLevelElem elem : elems) {
            if (!SlotPath.escape((String)elem.getElemName()).equals(name)) continue;
            return elem;
        }
        return null;
    }
}

