/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.server.point;

import com.tridium.modbusCore.datatypes.BFlexAddress;
import com.tridium.modbusCore.enums.BRegisterTypeEnum;
import com.tridium.modbusCore.enums.BRegisterTypesEnum;
import com.tridium.modbusCore.messages.ModbusResponse;
import com.tridium.modbusCore.point.BIModbusRegisterBitProxyExt;
import com.tridium.modbusCore.server.BModbusServerDevice;
import com.tridium.modbusCore.server.BModbusServerNetwork;
import com.tridium.modbusCore.server.point.BModbusServerProxyExt;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BModbusServerRegisterBitProxyExt
extends BModbusServerProxyExt
implements BIModbusRegisterBitProxyExt {
    public static final Property regType = BModbusServerRegisterBitProxyExt.newProperty((int)0, (BValue)BRegisterTypeEnum.holding, null);
    public static final Property bitNumber = BModbusServerRegisterBitProxyExt.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)15));
    public static final Type TYPE = Sys.loadType(BModbusServerRegisterBitProxyExt.class);

    @Override
    public BRegisterTypeEnum getRegType() {
        return (BRegisterTypeEnum)this.get(regType);
    }

    @Override
    public void setRegType(BRegisterTypeEnum v) {
        this.set(regType, (BValue)v, null);
    }

    @Override
    public int getBitNumber() {
        return this.getInt(bitNumber);
    }

    @Override
    public void setBitNumber(int v) {
        this.setInt(bitNumber, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void read() {
        if (this.configFault) {
            return;
        }
        BModbusServerDevice device = (BModbusServerDevice)this.getDevice();
        int numRegisters = 1;
        ModbusResponse rsp = new ModbusResponse(this.modbusNet().getModbusMode(), device);
        int pointAddress = this.getDataAddress().getDataAddress();
        try {
            rsp.data = this.isHoldingRegisterType() ? device.getHoldingRegisterValues(pointAddress, numRegisters) : device.getInputRegisterValues(pointAddress, numRegisters);
        }
        catch (Exception e) {
            if (this.modbusNet() != null && this.modbusNet().getModbusLog().isTraceOn()) {
                this.modbusNet().getModbusLog().trace(this.getParent().getName() + ": BModbusServerRegisterBitProxyExt.read() caught exception: ", (Throwable)e);
            }
            this.readFail("Exception during read (" + e + ")");
            return;
        }
        rsp.exceptionCode = 0;
        rsp.byteCount = (byte)rsp.data.length;
        rsp.numberPoints = numRegisters;
        this.setOutValues(rsp);
    }

    private void setOutValues(ModbusResponse rec) {
        if (!rec.isError()) {
            this.setBinaryOutValues(rec);
        } else {
            this.readFail(rec.getExceptionString());
        }
    }

    private void setBinaryOutValues(ModbusResponse rec) {
        int regValue = rec.data[1] & 0xFF | (rec.data[0] & 0xFF) << 8;
        int mask = 1;
        boolean binaryValue = (regValue & (mask <<= this.getBitNumber())) != 0;
        BStatusBoolean val = new BStatusBoolean(binaryValue);
        if (this.getStatus().isValid() && this.lastReadValue != null && this.lastReadValue.equivalent((Object)val)) {
            this.getTuning().readOk();
        } else {
            this.readOk((BStatusValue)val);
        }
    }

    @Override
    public BRegisterTypesEnum determineRegisterType() {
        if (this.getRegType().equals((Object)BRegisterTypeEnum.holding)) {
            return BRegisterTypesEnum.holdingRegister;
        }
        return BRegisterTypesEnum.inputRegister;
    }

    @Override
    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(bitNumber)) {
            this.setStale(true, null);
            if (this.getParentPoint().isWritablePoint()) {
                this.getTuning().writeDesired();
            }
        } else if (prop.equals(regType) && context != noAddressCheck) {
            this.setStale(true, null);
            if (this.getDataAddress().isModbusFormat()) {
                if (this.getDataAddress().isModbusHoldingAddress()) {
                    if (!this.isHoldingRegisterType()) {
                        this.set(regType, (BValue)BRegisterTypeEnum.holding, noAddressCheck);
                    }
                } else if (this.isHoldingRegisterType()) {
                    this.set(regType, (BValue)BRegisterTypeEnum.input, noAddressCheck);
                }
            }
            this.checkConfiguration();
            if (this.getParentPoint().isWritablePoint()) {
                this.getTuning().writeDesired();
            }
        }
    }

    @Override
    protected boolean isValidAddress(BFlexAddress addr) {
        if (!addr.isModbusFormat()) {
            BModbusServerDevice device = (BModbusServerDevice)this.getDevice();
            int numRegs = 1;
            if (this.isHoldingRegisterType()) {
                return device.isHoldingRegisterAddressValid(addr.getDataAddress(), numRegs);
            }
            return device.isInputRegisterAddressValid(addr.getDataAddress(), numRegs);
        }
        if (addr.isModbusAnalogAddress()) {
            BRegisterTypeEnum rType = BRegisterTypeEnum.holding;
            if (addr.isModbusHoldingAddress()) {
                this.set(regType, (BValue)BRegisterTypeEnum.holding, noAddressCheck);
            } else {
                this.set(regType, (BValue)BRegisterTypeEnum.input, noAddressCheck);
                rType = BRegisterTypeEnum.input;
            }
            BModbusServerDevice device = (BModbusServerDevice)this.getDevice();
            int numRegs = 1;
            if (rType.equals((Object)BRegisterTypeEnum.holding)) {
                return device.isHoldingRegisterAddressValid(addr.getDataAddress(), numRegs);
            }
            return device.isInputRegisterAddressValid(addr.getDataAddress(), numRegs);
        }
        return false;
    }

    private boolean isHoldingRegisterType() {
        return this.getRegType().equals((Object)BRegisterTypeEnum.holding);
    }

    public void doWrite(BStatusValue out) {
        if (this.getParentPoint().isWritablePoint() && !this.configFault) {
            if (this.modbusNet() != null) {
                if (out == null) {
                    this.updateOutput(this.getWriteValue());
                    if (this.getParentPoint().isSubscribed()) {
                        this.read();
                    }
                } else {
                    this.updateOutput(out);
                    if (this.getParentPoint().isSubscribed()) {
                        this.read();
                    }
                }
            }
        } else if (!this.getParentPoint().isWritablePoint() && this.modbusNet().getModbusLog().isTraceOn()) {
            this.modbusNet().getModbusLog().trace(this.getParent().getName() + "- This ModbusServer register bit point is not writable, disregarding write request.");
        }
        super.doWrite(out);
    }

    private boolean updateOutput(BStatusValue out) {
        boolean bValue = ((BStatusBoolean)out).getValue();
        if (!this.isValidAddress(this.getDataAddress())) {
            this.writeFail("Illegal Modbus address");
            return false;
        }
        try {
            BModbusServerDevice device = (BModbusServerDevice)this.getDevice();
            BModbusServerNetwork network = (BModbusServerNetwork)this.modbusNet();
            int count = 1;
            int address = device.getDeviceAddress();
            int pointAddress = this.getDataAddress().getDataAddress();
            ModbusResponse rsp = new ModbusResponse(network.getModbusMode(), device);
            try {
                rsp.data = this.isHoldingRegisterType() ? device.getHoldingRegisterValues(pointAddress, count) : device.getInputRegisterValues(pointAddress, count);
            }
            catch (Exception e) {
                if (this.modbusNet() != null && this.modbusNet().getModbusLog().isTraceOn()) {
                    this.modbusNet().getModbusLog().trace(this.getParent().getName() + ": BModbusServerRegisterBitProxyExt.read() caught exception: ", (Throwable)e);
                }
                this.writeFail("Error when writing (" + e + ")");
                return false;
            }
            int regValue = rsp.data[1] & 0xFF | (rsp.data[0] & 0xFF) << 8;
            byte[] dataOut = new byte[2];
            int mask = 1;
            regValue = bValue ? (regValue |= mask) : (regValue &= ~(mask <<= this.getBitNumber()));
            dataOut[0] = (byte)(regValue >> 8 & 0xFF);
            dataOut[1] = (byte)(regValue & 0xFF);
            if (this.isHoldingRegisterType()) {
                device.setHoldingRegisterValues(pointAddress, dataOut);
            } else {
                device.setInputRegisterValues(pointAddress, dataOut);
            }
        }
        catch (Exception e) {
            this.writeFail("Error when writing (" + e + ")");
            return false;
        }
        this.writeOk(out);
        return true;
    }
}

