/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.server.messages;

import com.tridium.modbusCore.BModbusDevice;
import com.tridium.modbusCore.messages.ModbusInputStream;
import com.tridium.modbusCore.messages.ModbusWriteRequest;

public class ModbusServerWriteReadRequest
extends ModbusWriteRequest {
    public int transactionIdentifier = 0;
    public int wrAddress;
    public int wrNumberPoints;

    public ModbusServerWriteReadRequest(int comType, BModbusDevice modDevice, byte[] data) {
        super(comType, modDevice);
        ModbusInputStream in = new ModbusInputStream(data);
        this.deviceAddress = in.read() & 0xFF;
        this.functionCode = in.read() & 0xFF;
        this.startAddress = in.readWord();
        this.numberPoints = in.readWord();
        this.wrAddress = in.readWord();
        this.wrNumberPoints = in.readWord();
        this.byteCount = in.read() & 0xFF;
        this.data = new byte[this.byteCount];
        for (int i = 0; i < this.byteCount; ++i) {
            this.data[i] = (byte)(in.read() & 0xFF);
        }
    }

    @Override
    public float getFloat(int index, int dataSize, boolean bigEndian) {
        if (index >= this.numberPoints) {
            throw new IllegalArgumentException("Point not returned: " + index);
        }
        int byteOffset = index * dataSize;
        if (byteOffset >= this.byteCount) {
            throw new IllegalArgumentException("Point not returned: " + index);
        }
        long bits = bigEndian ? (long)(this.data[byteOffset + 3] & 0xFF | (this.data[byteOffset + 2] & 0xFF) << 8 | (this.data[byteOffset + 1] & 0xFF) << 16 | (this.data[byteOffset + 0] & 0xFF) << 24) : (long)(this.data[byteOffset + 1] & 0xFF | (this.data[byteOffset + 0] & 0xFF) << 8 | (this.data[byteOffset + 3] & 0xFF) << 16 | (this.data[byteOffset + 2] & 0xFF) << 24);
        return Float.intBitsToFloat((int)bits);
    }

    @Override
    public int getRegister(int index, int dataSize, boolean bigEndian) {
        long value = 0L;
        if (index >= this.numberPoints) {
            throw new IllegalArgumentException("Point not returned: " + index);
        }
        int byteOffset = index * dataSize;
        if (byteOffset >= this.byteCount) {
            throw new IllegalArgumentException("Point not returned: " + index);
        }
        switch (dataSize) {
            case 2: {
                return this.data[byteOffset + 1] & 0xFF | (this.data[byteOffset] & 0xFF) << 8;
            }
            case 4: {
                value = bigEndian ? (long)(this.data[byteOffset + 3] & 0xFF | (this.data[byteOffset + 2] & 0xFF) << 8 | (this.data[byteOffset + 1] & 0xFF) << 16 | (this.data[byteOffset + 0] & 0xFF) << 24) : (long)(this.data[byteOffset + 1] & 0xFF | (this.data[byteOffset + 0] & 0xFF) << 8 | (this.data[byteOffset + 3] & 0xFF) << 16 | (this.data[byteOffset + 2] & 0xFF) << 24);
                return (int)(value &= 0xFFFFFFFFFFFFFFFFL);
            }
        }
        throw new IllegalArgumentException("Unsupported data size: " + dataSize);
    }

    public void setTransactionIdentifier(int ti) {
        this.transactionIdentifier = ti;
    }
}

