/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.point;

import com.tridium.basicdriver.point.BBasicProxyExt;
import com.tridium.modbusCore.BModbusDevice;
import com.tridium.modbusCore.BModbusNetwork;
import com.tridium.modbusCore.datatypes.BFlexAddress;
import com.tridium.modbusCore.messages.ModbusMessageConst;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public abstract class BModbusProxyExt
extends BBasicProxyExt
implements ModbusMessageConst,
BIPollable {
    public static final Property pollFrequency = BModbusProxyExt.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Property dataAddress = BModbusProxyExt.newProperty((int)0, (BValue)new BFlexAddress(), null);
    public static final Action forceRead = BModbusProxyExt.newAction((int)16, null);
    public static final Action forceWrite = BModbusProxyExt.newAction((int)16, null);
    public static final Type TYPE = Sys.loadType(BModbusProxyExt.class);
    protected static Context noAddressCheck = new BasicContext(){

        public boolean equals(Object o) {
            return this == o;
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }

        public String toString() {
            return "Modbus:noAddressCheck";
        }
    };

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    public BFlexAddress getDataAddress() {
        return (BFlexAddress)this.get(dataAddress);
    }

    public void setDataAddress(BFlexAddress v) {
        this.set(dataAddress, (BValue)v, null);
    }

    public void forceRead() {
        this.invoke(forceRead, null, null);
    }

    public void forceWrite() {
        this.invoke(forceWrite, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected synchronized BModbusNetwork modbusNet() {
        if (this.getDevice() == null) {
            return null;
        }
        return ((BModbusDevice)this.getDevice()).modbusNet();
    }

    protected int getDevAddr() {
        return ((BModbusDevice)this.getDevice()).getDeviceAddress();
    }

    public void poll() {
        if (this.isUnoperational()) {
            return;
        }
        this.read();
    }

    public void read() {
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        if (action.equals(forceRead) || action.equals(forceWrite)) {
            return this.modbusNet().postAsync((Runnable)new Invocation((BComponent)this, action, arg, cx));
        }
        return super.post(action, arg, cx);
    }

    public void doForceRead() {
        this.poll();
    }

    public void doForceWrite() {
        try {
            this.write(null);
        }
        catch (Exception e) {
            this.modbusNet().getModbusLog().error("Exception during forceWrite for " + this.getParentPoint().getName(), (Throwable)e);
        }
    }

    public void writablePointActionInvoked() {
        super.writablePointActionInvoked();
        this.getParentPoint().execute();
    }
}

