/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.messages;

import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.modbusCore.BModbusDevice;
import com.tridium.modbusCore.messages.ModbusMessage;
import com.tridium.modbusCore.messages.ModbusOutputStream;
import com.tridium.modbusCore.messages.ModbusReadExceptionStatusResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.baja.nre.util.ByteArrayUtil;

public class ModbusReadExceptionStatusRequest
extends ModbusMessage {
    int returnBytes;

    public ModbusReadExceptionStatusRequest(int comType, BModbusDevice modDevice, int addr, int returnBytes) {
        super(comType, modDevice);
        this.deviceAddress = addr;
        this.functionCode = 7;
        this.returnBytes = returnBytes;
    }

    @Override
    public final void writeRtu(OutputStream out) throws IOException {
        ModbusOutputStream modOut = new ModbusOutputStream();
        modOut.write((byte)this.deviceAddress);
        modOut.write((byte)this.functionCode);
        modOut.writeCRC();
        out.write(modOut.toByteArray());
    }

    @Override
    public final void writeAscii(OutputStream out) throws IOException {
        byte[] msgArray;
        msgArray = new byte[]{(byte)this.deviceAddress, (byte)this.functionCode, (byte)ModbusReadExceptionStatusRequest.calcLRC(msgArray)};
        ModbusOutputStream modOut = new ModbusOutputStream();
        modOut.write(msgArray);
        out.write(modOut.toAsciiHexByteArray());
    }

    @Override
    public final void writeTcp(OutputStream out) throws IOException {
        byte[] msgArray = new byte[]{0, 0, 0, 0, 0, 2, (byte)this.deviceAddress, (byte)this.functionCode};
        out.write(msgArray);
    }

    @Override
    public int getResponseMsgSize() {
        return 4 + this.returnBytes;
    }

    @Override
    public Message toResponse(ReceivedMessage response) {
        ModbusReadExceptionStatusResponse respMessage = new ModbusReadExceptionStatusResponse(this.comType, this.modbusDevice, response, this.returnBytes, this.comType == 0);
        return respMessage;
    }

    @Override
    public String toDebugString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toDebugString());
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.write(out);
            sb.append("\n  Raw Bytes = " + ByteArrayUtil.toHexString((byte[])out.toByteArray()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }
}

