/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.datatypes;

import com.tridium.modbusCore.enums.BAddressFormatEnum;
import javax.baja.sys.BComplex;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BFlexAddress
extends BStruct {
    public static final Property addressFormat = BFlexAddress.newProperty((int)0, (BValue)BAddressFormatEnum.hex, null);
    public static final Property address = BFlexAddress.newProperty((int)0, (String)"0", null);
    public static final Type TYPE = Sys.loadType(BFlexAddress.class);

    public BAddressFormatEnum getAddressFormat() {
        return (BAddressFormatEnum)this.get(addressFormat);
    }

    public void setAddressFormat(BAddressFormatEnum v) {
        this.set(addressFormat, (BValue)v, null);
    }

    public String getAddress() {
        return this.getString(address);
    }

    public void setAddress(String v) {
        this.setString(address, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BFlexAddress() {
    }

    public BFlexAddress(BAddressFormatEnum addressFormat, String address) {
        this.setAddressFormat(addressFormat);
        this.setAddress(address);
    }

    public BFlexAddress(String addressString) {
        this.setAddressFormat((BAddressFormatEnum)BAddressFormatEnum.modbus.getRange().get(addressString.substring(0, addressString.indexOf(58))));
        this.setAddress(addressString.substring(addressString.indexOf(58) + 1, addressString.length()));
    }

    public BFlexAddress(BFlexAddress src) {
        this.copyFrom((BComplex)src);
    }

    public boolean isHexFormat() {
        return this.getAddressFormat() == BAddressFormatEnum.hex;
    }

    public boolean isDecimalFormat() {
        return this.getAddressFormat() == BAddressFormatEnum.decimal;
    }

    public boolean isModbusFormat() {
        return this.getAddressFormat() == BAddressFormatEnum.modbus;
    }

    public boolean isValid() {
        int temp = this.isHexFormat() ? Integer.valueOf(this.getAddress(), 16).intValue() : Integer.valueOf(this.getAddress()).intValue();
        if (this.isModbusFormat()) {
            return temp >= 0 && temp < 50000;
        }
        return temp >= 0;
    }

    public boolean isModbusAnalogAddress() {
        if (this.isModbusFormat()) {
            int temp = Integer.valueOf(this.getAddress());
            return temp >= 30000 && temp < 50000;
        }
        return false;
    }

    public boolean isModbusDigitalAddress() {
        if (this.isModbusFormat()) {
            int temp = Integer.valueOf(this.getAddress());
            return temp < 30000 && temp >= 0;
        }
        return false;
    }

    public boolean isModbusHoldingAddress() {
        if (this.isModbusFormat()) {
            int temp = Integer.valueOf(this.getAddress());
            return temp > 40000 && temp < 50000;
        }
        return false;
    }

    public boolean isModbusInputAddress() {
        if (this.isModbusFormat()) {
            int temp = Integer.valueOf(this.getAddress());
            return temp > 30000 && temp < 40000;
        }
        return false;
    }

    public boolean isModbusCoilAddress() {
        if (this.isModbusFormat()) {
            int temp = Integer.valueOf(this.getAddress());
            return temp < 10000 && temp >= 0;
        }
        return false;
    }

    public boolean isModbusStatusAddress() {
        if (this.isModbusFormat()) {
            int temp = Integer.valueOf(this.getAddress());
            return temp > 10000 && temp < 20000;
        }
        return false;
    }

    public String getFlexAddress() {
        return this.getAddressFormat().getTag() + ":" + this.getAddress();
    }

    public int getDataAddress() {
        if (this.isHexFormat()) {
            return Integer.valueOf(this.getAddress(), 16);
        }
        if (this.isDecimalFormat()) {
            return Integer.valueOf(this.getAddress());
        }
        int temp = Integer.valueOf(this.getAddress());
        if (temp > 40000) {
            return temp - 40001;
        }
        if (temp > 30000) {
            return temp - 30001;
        }
        if (temp > 20000) {
            return temp - 20001;
        }
        if (temp > 10000) {
            return temp - 10001;
        }
        return temp - 1;
    }

    public int getDataAddressNoModbusAltering() {
        if (this.isHexFormat()) {
            return Integer.valueOf(this.getAddress(), 16);
        }
        return Integer.valueOf(this.getAddress());
    }

    public void setAddressFromInt(int address) {
        if (this.isHexFormat()) {
            this.setAddress(Integer.toString(address, 16));
        } else {
            this.setAddress(Integer.toString(address));
        }
    }

    public void setAddressFromString(String address) {
        int iAddr;
        if (this.isHexFormat()) {
            try {
                iAddr = Integer.valueOf(address, 16);
                address = "0000" + address;
                address = address.substring(address.length() - 4);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Must enter address in Hex.");
            }
        }
        try {
            iAddr = Integer.valueOf(address);
            address = "00000" + address;
            address = address.substring(address.length() - 5);
            if (this.isModbusFormat() && (iAddr == 0 || iAddr == 10000 || iAddr == 30000 || iAddr == 40000 || iAddr >= 50000 || iAddr >= 20000 && iAddr < 30000)) {
                throw new RuntimeException("Illegal Modbus address: Must be 0x, 1x, 3x or 4x format.");
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Must enter address in decimal.");
        }
        if (iAddr > 65535) {
            if (this.isHexFormat()) {
                throw new RuntimeException("Address must be less than 10000 hex.");
            }
            throw new RuntimeException("Address must be less than 65536.");
        }
        this.setAddress(address);
    }

    public String toString(Context context) {
        return this.getAddressFormat().getTag() + ":" + this.getAddress();
    }

    public String toDebugString() {
        return this.getAddressFormat().getTag() + ":" + this.getAddress();
    }
}

