/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.client.point;

import com.tridium.modbusCore.ModbusException;
import com.tridium.modbusCore.client.BModbusClientDevice;
import com.tridium.modbusCore.client.BModbusClientNetwork;
import com.tridium.modbusCore.client.datatypes.BDevicePollConfigEntry;
import com.tridium.modbusCore.client.point.BModbusClientProxyExt;
import com.tridium.modbusCore.datatypes.BFlexAddress;
import com.tridium.modbusCore.enums.BAddressFormatEnum;
import com.tridium.modbusCore.enums.BDataTypeEnum;
import com.tridium.modbusCore.enums.BRegisterTypeEnum;
import com.tridium.modbusCore.enums.BRegisterTypesEnum;
import com.tridium.modbusCore.messages.ModbusReadRequest;
import com.tridium.modbusCore.messages.ModbusResponse;
import com.tridium.modbusCore.messages.ModbusWriteRequest;
import com.tridium.modbusCore.point.BIModbusNumericProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BEnum;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BModbusClientNumericProxyExt
extends BModbusClientProxyExt
implements BIModbusNumericProxyExt {
    public static final Property regType = BModbusClientNumericProxyExt.newProperty((int)0, (BValue)BRegisterTypeEnum.holding, null);
    public static final Property dataType = BModbusClientNumericProxyExt.newProperty((int)0, (BValue)BDataTypeEnum.integerType, null);
    public static final Type TYPE = Sys.loadType(BModbusClientNumericProxyExt.class);

    @Override
    public BRegisterTypeEnum getRegType() {
        return (BRegisterTypeEnum)this.get(regType);
    }

    @Override
    public void setRegType(BRegisterTypeEnum v) {
        this.set(regType, (BValue)v, null);
    }

    @Override
    public BDataTypeEnum getDataType() {
        return (BDataTypeEnum)this.get(dataType);
    }

    @Override
    public void setDataType(BDataTypeEnum v) {
        this.set(dataType, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        super.started();
        if (this.getParentPoint().isWritablePoint()) {
            this.setFlags((Slot)regType, 1);
        }
    }

    public BReadWriteMode getMode() {
        return this.getParentPoint().isWritablePoint() ? BReadWriteMode.readWrite : BReadWriteMode.readonly;
    }

    @Override
    public void read() {
        if (this.configFault) {
            return;
        }
        BModbusClientDevice device = (BModbusClientDevice)this.getDevice();
        int address = device.getDeviceAddress();
        int pointAddress = this.getAbsoluteAddress().getDataAddress();
        int count = 1;
        if (this.isDataTypeLong()) {
            count *= 2;
        } else if (this.isDataTypeFloat()) {
            count *= 2;
        }
        int code = this.isHoldingRegisterType() ? 3 : 4;
        ModbusReadRequest req = new ModbusReadRequest(device.modbusNet().getModbusMode(), device, address, code, pointAddress, count);
        ModbusResponse rsp = (ModbusResponse)device.sendModbusMessage(req);
        if (rsp == null) {
            rsp = new ModbusResponse(device.modbusNet().getModbusMode(), device);
            rsp.exceptionCode = 9;
        }
        this.setOutValues(rsp);
    }

    public void setOutValues(ModbusResponse rec) {
        if (!rec.isError()) {
            if (this.isDataTypeInteger()) {
                this.setIntegerOutValues(rec, 2);
            } else if (this.isDataTypeLong()) {
                this.setIntegerOutValues(rec, 4);
            } else if (this.isDataTypeFloat()) {
                this.setFloatOutValues(rec, 4);
            }
        } else {
            this.readFail(rec.getExceptionString());
        }
    }

    private void setIntegerOutValues(ModbusResponse rec, int dataSize) {
        long regValue;
        try {
            regValue = rec.getRegister(0, dataSize, ((BModbusClientDevice)this.getDevice()).isLong3210Order(), this.isDataTypeSigned());
        }
        catch (IllegalArgumentException e) {
            this.readFail("error parsing integer value (" + e + ")");
            return;
        }
        this.readOk((BStatusValue)new BStatusNumeric((double)regValue));
    }

    private void setFloatOutValues(ModbusResponse rec, int dataSize) {
        float regValue;
        try {
            regValue = rec.getFloat(0, dataSize, ((BModbusClientDevice)this.getDevice()).isFloat3210Order());
        }
        catch (IllegalArgumentException e) {
            this.readFail("error parsing float value (" + e + ")");
            return;
        }
        this.readOk((BStatusValue)new BStatusNumeric((double)regValue));
    }

    @Override
    public BRegisterTypesEnum determineRegisterType() {
        if (this.getRegType().equals((Object)BRegisterTypeEnum.holding)) {
            return BRegisterTypesEnum.holdingRegister;
        }
        return BRegisterTypesEnum.inputRegister;
    }

    @Override
    public BEnum getRegisterType() {
        return this.getRegType();
    }

    @Override
    public int determineNumRegisters() {
        int numRegisters = 1;
        if (!this.isDataTypeInteger()) {
            numRegisters *= 2;
        }
        return numRegisters;
    }

    @Override
    public void changed(Property prop, Context context) {
        if (!this.isRunning()) {
            super.changed(prop, context);
            return;
        }
        if (prop.equals(dataType)) {
            this.setStale(true, null);
            if (this.getDevice() != null) {
                this.adjustPollSubscription();
            }
            if (this.getParentPoint().isWritablePoint()) {
                if (((BModbusClientDevice)this.getDevice()).writablePointAlreadyExists(this)) {
                    this.modbusNet().getModbusLog().error(this.getParent().getName() + " Duplicate Writable point for register address: " + (Object)((Object)this.getDataAddress()));
                    this.set(dataAddress, (BValue)new BFlexAddress(BAddressFormatEnum.hex, "-1"), null);
                } else {
                    this.getTuning().writeDesired();
                }
            }
        } else if (prop.equals(regType)) {
            if (context != noAddressCheck) {
                if (this.getParentPoint().isWritablePoint() && !this.isHoldingRegisterType()) {
                    this.set(regType, (BValue)BRegisterTypeEnum.holding, noAddressCheck);
                } else if (this.getDataAddress().isModbusFormat()) {
                    this.setStale(true, null);
                    if (this.getDataAddress().isModbusHoldingAddress()) {
                        if (!this.isHoldingRegisterType()) {
                            this.set(regType, (BValue)BRegisterTypeEnum.holding, noAddressCheck);
                        }
                    } else if (this.isHoldingRegisterType()) {
                        this.set(regType, (BValue)BRegisterTypeEnum.input, noAddressCheck);
                    }
                }
            }
            if (this.getDevice() != null) {
                if (this.getParentPoint().isWritablePoint() && ((BModbusClientDevice)this.getDevice()).writablePointAlreadyExists(this)) {
                    this.modbusNet().getModbusLog().error(this.getParent().getName() + " Duplicate Writable point for register address: " + (Object)((Object)this.getDataAddress()));
                    this.setDataAddress(new BFlexAddress(BAddressFormatEnum.hex, "-1"));
                }
                this.adjustPollSubscription();
            }
        } else {
            super.changed(prop, context);
        }
    }

    @Override
    public boolean isValidAddress(BFlexAddress addr) {
        if (!addr.isModbusFormat()) {
            return addr.isValid();
        }
        if (addr.isModbusAnalogAddress()) {
            if (this.getParentPoint().isWritablePoint()) {
                return addr.isModbusHoldingAddress();
            }
            if (addr.isModbusHoldingAddress()) {
                this.set(regType, (BValue)BRegisterTypeEnum.holding, noAddressCheck);
            } else {
                this.set(regType, (BValue)BRegisterTypeEnum.input, noAddressCheck);
            }
            return true;
        }
        return false;
    }

    public boolean isHoldingRegisterType() {
        return this.getRegType().equals((Object)BRegisterTypeEnum.holding);
    }

    public boolean isDataTypeInteger() {
        if (this.getDataType().equals((Object)BDataTypeEnum.integerType)) {
            return true;
        }
        return this.getDataType().equals((Object)BDataTypeEnum.signedInteger);
    }

    public boolean isDataTypeLong() {
        return this.getDataType().equals((Object)BDataTypeEnum.longType) || this.getDataType().equals((Object)BDataTypeEnum.unsignedLong);
    }

    public boolean isDataTypeFloat() {
        return this.getDataType().equals((Object)BDataTypeEnum.floatType);
    }

    public boolean isDataTypeSigned() {
        if (this.getDataType().equals((Object)BDataTypeEnum.signedInteger)) {
            return true;
        }
        return this.getDataType().equals((Object)BDataTypeEnum.longType);
    }

    @Override
    public void devicePoll(BDevicePollConfigEntry entry) {
        block6: {
            if (this.configFault || this.isUnoperational()) {
                return;
            }
            BModbusClientDevice device = (BModbusClientDevice)this.getDevice();
            int numRegisters = 1;
            if (!this.isDataTypeInteger()) {
                numRegisters *= 2;
            }
            ModbusResponse rsp = new ModbusResponse(device.modbusNet().getModbusMode(), device);
            int pointAddress = this.getAbsoluteAddress().getDataAddress();
            try {
                if (this.isHoldingRegisterType()) {
                    rsp.data = device.getHoldingRegisterValues(pointAddress, numRegisters, entry);
                    rsp.exceptionCode = device.getHoldingRegistersReadStatus(pointAddress, numRegisters, entry).getErrorCode();
                } else {
                    rsp.data = device.getInputRegisterValues(pointAddress, numRegisters, entry);
                    rsp.exceptionCode = device.getInputRegistersReadStatus(pointAddress, numRegisters, entry).getErrorCode();
                }
                rsp.byteCount = (byte)rsp.data.length;
                rsp.numberPoints = numRegisters;
                this.setOutValues(rsp);
            }
            catch (ModbusException e) {
                if (!this.modbusNet().getModbusLog().isTraceOn()) break block6;
                this.modbusNet().getModbusLog().trace(this.getParent().getName() + ">>> devicePoll error", (Throwable)((Object)e));
            }
        }
    }

    public void doWrite(BStatusValue out) {
        if (this.getParentPoint().isWritablePoint() && !this.configFault) {
            if (this.modbusNet() != null) {
                if (out == null) {
                    this.updateOutput(this.getWriteValue());
                    if (this.getParentPoint().isSubscribed()) {
                        this.read();
                    }
                } else {
                    this.updateOutput(out);
                    if (this.getParentPoint().isSubscribed()) {
                        this.read();
                    }
                }
            }
        } else if (!this.getParentPoint().isWritablePoint() && this.modbusNet().getModbusLog().isTraceOn()) {
            this.modbusNet().getModbusLog().trace(this.getParent().getName() + "- This ModbusClient float point is not writable, disregarding write request.");
        }
        super.doWrite(out);
    }

    public boolean updateOutput(BStatusValue out) {
        ModbusWriteRequest req;
        ModbusResponse resp;
        double fValue = ((BStatusNumeric)out).getValue();
        BModbusClientDevice device = (BModbusClientDevice)this.getDevice();
        BModbusClientNetwork network = (BModbusClientNetwork)this.modbusNet();
        int address = device.getDeviceAddress();
        int pointAddress = this.getAbsoluteAddress().getDataAddress();
        byte[] dataOut = this.isDataTypeInteger() ? this.setIntegerByteArray(fValue) : (this.isDataTypeLong() ? this.setLongByteArray(fValue) : this.setFloatByteArray(fValue));
        int count = 1;
        if (this.isDataTypeLong() || this.isDataTypeFloat()) {
            count *= 2;
        }
        int code = 6;
        if (device.isPresetMultiple()) {
            code = 16;
        }
        if ((resp = (ModbusResponse)device.sendModbusMessage(req = new ModbusWriteRequest(network.getModbusMode(), device, address, code, pointAddress, count, dataOut))) == null) {
            resp = new ModbusResponse(network.getModbusMode(), device);
            resp.exceptionCode = 9;
        }
        if (resp.isError() && resp.exceptionCode != 5) {
            this.writeFail(resp.getExceptionString());
            return false;
        }
        if (code == 6 && count > 1) {
            dataOut[0] = dataOut[2];
            dataOut[1] = dataOut[3];
            req = new ModbusWriteRequest(network.getModbusMode(), device, address, code, pointAddress + 1, 1, dataOut);
            resp = (ModbusResponse)device.sendModbusMessage(req);
            if (resp == null) {
                resp = new ModbusResponse(network.getModbusMode(), device);
                resp.exceptionCode = 9;
            }
            if (resp.isError() && resp.exceptionCode != 5) {
                this.writeFail(resp.getExceptionString());
                return false;
            }
        }
        this.writeOk(out);
        return true;
    }

    protected byte[] setIntegerByteArray(double fValue) {
        byte[] ba = new byte[2];
        fValue = fValue >= 0.0 ? (fValue += 0.5) : (fValue -= 0.5);
        double maxValue = 65535.0;
        double minValue = 0.0;
        if (this.isDataTypeSigned()) {
            maxValue = 32767.0;
            minValue = -32768.0;
        }
        if (fValue > maxValue) {
            fValue = maxValue;
        } else if (fValue < minValue) {
            fValue = minValue;
        }
        int intValue = (int)fValue;
        ba[0] = (byte)((intValue & 0xFF00) >> 8);
        ba[1] = (byte)(intValue & 0xFF);
        return ba;
    }

    protected byte[] setLongByteArray(double fValue) {
        double minValue;
        byte[] ba = new byte[4];
        fValue = fValue >= 0.0 ? (fValue += 0.5) : (fValue -= 0.5);
        double maxValue = this.isDataTypeSigned() ? 2.147483647E9 : 4.294967295E9;
        double d = minValue = this.isDataTypeSigned() ? -2.147483648E9 : 0.0;
        if (fValue > maxValue) {
            fValue = maxValue;
        } else if (fValue < minValue) {
            fValue = minValue;
        }
        long longValue = (long)fValue;
        if (((BModbusClientDevice)this.getDevice()).isLong3210Order()) {
            ba[0] = (byte)((longValue & 0xFFFFFFFFFF000000L) >> 24);
            ba[1] = (byte)((longValue & 0xFF0000L) >> 16);
            ba[2] = (byte)((longValue & 0xFF00L) >> 8);
            ba[3] = (byte)(longValue & 0xFFL);
        } else {
            ba[0] = (byte)((longValue & 0xFF00L) >> 8);
            ba[1] = (byte)(longValue & 0xFFL);
            ba[2] = (byte)((longValue & 0xFFFFFFFFFF000000L) >> 24);
            ba[3] = (byte)((longValue & 0xFF0000L) >> 16);
        }
        return ba;
    }

    protected byte[] setFloatByteArray(double fValue) {
        byte[] ba = new byte[4];
        int floatBits = Float.floatToIntBits((float)fValue);
        if (((BModbusClientDevice)this.getDevice()).isFloat3210Order()) {
            ba[0] = (byte)((floatBits & 0xFF000000) >> 24);
            ba[1] = (byte)((floatBits & 0xFF0000) >> 16);
            ba[2] = (byte)((floatBits & 0xFF00) >> 8);
            ba[3] = (byte)(floatBits & 0xFF);
        } else {
            ba[0] = (byte)((floatBits & 0xFF00) >> 8);
            ba[1] = (byte)(floatBits & 0xFF);
            ba[2] = (byte)((floatBits & 0xFF000000) >> 24);
            ba[3] = (byte)((floatBits & 0xFF0000) >> 16);
        }
        return ba;
    }
}

