/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.client.point;

import com.tridium.modbusCore.client.BModbusClientDevice;
import com.tridium.modbusCore.client.BModbusClientNetwork;
import com.tridium.modbusCore.client.point.BModbusClientNumericProxyExt;
import com.tridium.modbusCore.datatypes.BFlexAddress;
import com.tridium.modbusCore.enums.BAddressFormatEnum;
import com.tridium.modbusCore.enums.BDataTypeEnum;
import com.tridium.modbusCore.enums.BRegisterTypeEnum;
import com.tridium.modbusCore.messages.ModbusReadRequest;
import com.tridium.modbusCore.messages.ModbusResponse;
import com.tridium.modbusCore.messages.ModbusWriteRequest;
import com.tridium.modbusCore.point.BIModbusNumericBitsProxyExt;
import javax.baja.control.BNumericPoint;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BModbusClientNumericBitsProxyExt
extends BModbusClientNumericProxyExt
implements BIModbusNumericBitsProxyExt {
    public static final Property beginningBit = BModbusClientNumericBitsProxyExt.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)15));
    public static final Property numberOfBits = BModbusClientNumericBitsProxyExt.newProperty((int)0, (int)1, (BFacets)BFacets.makeInt(null, (int)1, (int)16));
    public static final Type TYPE = Sys.loadType(BModbusClientNumericBitsProxyExt.class);

    @Override
    public int getBeginningBit() {
        return this.getInt(beginningBit);
    }

    @Override
    public void setBeginningBit(int v) {
        this.setInt(beginningBit, v, null);
    }

    @Override
    public int getNumberOfBits() {
        return this.getInt(numberOfBits);
    }

    @Override
    public void setNumberOfBits(int v) {
        this.setInt(numberOfBits, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void changed(Property prop, Context context) {
        if (!this.isRunning()) {
            super.changed(prop, context);
            return;
        }
        if (prop.equals(beginningBit) || prop.equals(numberOfBits)) {
            if (context != noAddressCheck) {
                this.checkBitFieldSize();
            }
            if (((BModbusClientDevice)this.getDevice()).writablePointAlreadyExists(this)) {
                this.modbusNet().getModbusLog().error(this.getParent().getName() + " Duplicate Writable point for register address: " + (Object)((Object)this.getDataAddress()));
                this.setDataAddress(new BFlexAddress(BAddressFormatEnum.hex, "-1"));
            }
        } else if (prop.equals(dataType)) {
            if (context != noAddressCheck && !this.getDataType().equals((Object)BDataTypeEnum.integerType)) {
                this.set(dataType, (BValue)BDataTypeEnum.integerType, noAddressCheck);
            }
            this.setStale(true, null);
            if (this.getDevice() != null) {
                this.adjustPollSubscription();
            }
            if (this.getParentPoint().isWritablePoint()) {
                if (((BModbusClientDevice)this.getDevice()).writablePointAlreadyExists(this)) {
                    this.modbusNet().getModbusLog().error(this.getParent().getName() + " Duplicate Writable point for register address: " + (Object)((Object)this.getDataAddress()));
                    this.set(dataAddress, (BValue)new BFlexAddress(BAddressFormatEnum.hex, "-1"), null);
                } else {
                    this.getTuning().writeDesired();
                }
            }
        } else {
            super.changed(prop, context);
        }
    }

    @Override
    public void started() throws Exception {
        Property prop = this.getProperty("conversion");
        this.setFlags((Slot)prop, this.getFlags((Slot)prop) | 4);
        prop = this.getProperty("dataType");
        this.setFlags((Slot)prop, this.getFlags((Slot)prop) | 4);
        if (!this.getDataType().equals((Object)BDataTypeEnum.integerType)) {
            this.setDataType(BDataTypeEnum.integerType);
        }
        this.checkBitFieldSize();
        super.started();
    }

    @Override
    public void setOutValues(ModbusResponse rec) {
        if (!rec.isError()) {
            if (this.isDataTypeInteger()) {
                this.setIntegerOutValues(rec, 2);
            } else if (this.isDataTypeLong()) {
                this.setIntegerOutValues(rec, 4);
            } else if (this.isDataTypeFloat()) {
                this.setFloatOutValues(rec, 4);
            }
        } else {
            this.readFail(rec.getExceptionString());
        }
    }

    private void setIntegerOutValues(ModbusResponse rec, int dataSize) {
        int regValue;
        try {
            regValue = this.getBitsValue((int)rec.getRegister(0, dataSize, ((BModbusClientDevice)this.getDevice()).isLong3210Order(), this.isDataTypeSigned()));
        }
        catch (IllegalArgumentException e) {
            this.readFail("error parsing integer value (" + e + ")");
            return;
        }
        this.readOk((BStatusValue)new BStatusNumeric((double)regValue));
    }

    private void setFloatOutValues(ModbusResponse rec, int dataSize) {
        float regValue;
        try {
            regValue = this.getBitsValue(rec.getFloat(0, dataSize, ((BModbusClientDevice)this.getDevice()).isFloat3210Order()));
        }
        catch (IllegalArgumentException e) {
            this.readFail("error parsing float value (" + e + ")");
            return;
        }
        this.readOk((BStatusValue)new BStatusNumeric((double)regValue));
    }

    @Override
    public boolean updateOutput(BStatusValue out) {
        ModbusWriteRequest writeReq;
        float fValue = (float)((BStatusNumeric)out).getValue();
        if (fValue > (float)this.getMask()) {
            this.writeFail(fValue + " is greater than maximum value of " + this.getMask() + " (" + this.getNumberOfBits() + " bits)");
            return false;
        }
        BModbusClientDevice device = (BModbusClientDevice)this.getDevice();
        BModbusClientNetwork network = (BModbusClientNetwork)this.modbusNet();
        int address = device.getDeviceAddress();
        int pointAddress = this.getAbsoluteAddress().getDataAddress();
        int count = 1;
        if (this.isDataTypeLong() || this.isDataTypeFloat()) {
            count *= 2;
        }
        int code = this.isHoldingRegisterType() ? 3 : 4;
        ModbusReadRequest readReq = new ModbusReadRequest(network.getModbusMode(), device, address, code, pointAddress, count);
        ModbusResponse resp = (ModbusResponse)device.sendModbusMessage(readReq);
        if (resp == null) {
            resp = new ModbusResponse(network.getModbusMode(), device);
            resp.exceptionCode = 9;
        }
        if (resp.isError() && resp.exceptionCode != 5) {
            this.writeFail(resp.getExceptionString());
            return false;
        }
        byte[] dataOut = this.isDataTypeInteger() ? this.setIntegerByteArray(this.mergeBitsValue(fValue, (float)resp.getRegister(0, 2, ((BModbusClientDevice)this.getDevice()).isLong3210Order(), this.isDataTypeSigned()))) : (this.isDataTypeLong() ? this.setLongByteArray(this.mergeBitsValue(fValue, (float)resp.getRegister(0, 4, ((BModbusClientDevice)this.getDevice()).isLong3210Order(), this.isDataTypeSigned()))) : this.setFloatByteArray(this.mergeBitsValue(fValue, resp.getFloat(0, 4, ((BModbusClientDevice)this.getDevice()).isFloat3210Order()))));
        code = 6;
        if (device.isPresetMultiple()) {
            code = 16;
        }
        if ((resp = (ModbusResponse)device.sendModbusMessage(writeReq = new ModbusWriteRequest(network.getModbusMode(), device, address, code, pointAddress, count, dataOut))) == null) {
            resp = new ModbusResponse(network.getModbusMode(), device);
            resp.exceptionCode = 9;
        }
        if (resp.isError() && resp.exceptionCode != 5) {
            this.writeFail(resp.getExceptionString());
            return false;
        }
        if (code == 6 && count > 1) {
            dataOut[0] = dataOut[2];
            dataOut[1] = dataOut[3];
            writeReq = new ModbusWriteRequest(network.getModbusMode(), device, address, code, pointAddress + 1, 1, dataOut);
            resp = (ModbusResponse)device.sendModbusMessage(writeReq);
            if (resp == null) {
                resp = new ModbusResponse(network.getModbusMode(), device);
                resp.exceptionCode = 9;
            }
            if (resp.isError() && resp.exceptionCode != 5) {
                this.writeFail(resp.getExceptionString());
                return false;
            }
        }
        this.writeOk(out);
        return true;
    }

    @Override
    public boolean isValidAddress(BFlexAddress addr) {
        if (!addr.isModbusFormat()) {
            return addr.isValid();
        }
        if (addr.isModbusAnalogAddress()) {
            if (this.getParentPoint().isWritablePoint()) {
                return addr.isModbusHoldingAddress();
            }
            if (addr.isModbusHoldingAddress()) {
                this.set(regType, (BValue)BRegisterTypeEnum.holding, noAddressCheck);
            } else {
                this.set(regType, (BValue)BRegisterTypeEnum.input, noAddressCheck);
            }
            return true;
        }
        return false;
    }

    public void checkBitFieldSize() {
        int numBits;
        int beginBit = this.getBeginningBit();
        if (beginBit + (numBits = this.getNumberOfBits()) > 16) {
            this.modbusNet().getModbusLog().error(this.getParent().getName() + " bits " + beginBit + "-" + (beginBit + numBits - 1) + " exceed register bounds.");
            this.setInt(this.getProperty("numberOfBits"), 16 - beginBit, noAddressCheck);
        }
    }

    public float getBitsValue(float val) {
        return new Integer(this.getBitsValue((int)val)).floatValue();
    }

    public int getBitsValue(int val) {
        return (val & this.getRegisterMask()) >> this.getBeginningBit();
    }

    public float mergeBitsValue(float val, float reg) {
        return this.mergeBitsValue((int)val, reg);
    }

    public float mergeBitsValue(int val, float reg) {
        float outVal = (float)((BNumericPoint)this.getParent()).getOut().getValue();
        return (int)reg & ~this.getRegisterMask() | val << this.getBeginningBit();
    }

    public int getMask() {
        int mask = 0;
        int bits = this.getNumberOfBits();
        for (int i = 0; i < bits; ++i) {
            mask <<= 1;
            mask |= 1;
        }
        return mask;
    }

    public int getRegisterMask() {
        return this.getMask() << this.getBeginningBit();
    }
}

