/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.client.datatypes;

import com.tridium.basicdriver.MessageListener;
import com.tridium.basicdriver.message.Message;
import com.tridium.modbusCore.client.BModbusClientDevice;
import com.tridium.modbusCore.client.datatypes.BCommStatus;
import com.tridium.modbusCore.client.datatypes.BModbusClientPresetComponent;
import com.tridium.modbusCore.client.datatypes.BModbusClientPresetRegister;
import com.tridium.modbusCore.datatypes.BFlexAddress;
import com.tridium.modbusCore.enums.BDataTypeEnum;
import com.tridium.modbusCore.messages.ModbusResponse;
import com.tridium.modbusCore.messages.ModbusWriteRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.ICoalesceable;

public class BModbusClientPresetRegisters
extends BModbusClientPresetComponent
implements MessageListener {
    public static final Property dataType = BModbusClientPresetRegisters.newProperty((int)0, (BValue)BDataTypeEnum.integerType, null);
    public static final Action addPresetRegisterValue = BModbusClientPresetRegisters.newAction((int)0, (BValue)new BModbusClientPresetRegister(), null);
    public static final Type TYPE = Sys.loadType(BModbusClientPresetRegisters.class);

    public BDataTypeEnum getDataType() {
        return (BDataTypeEnum)this.get(dataType);
    }

    public void setDataType(BDataTypeEnum v) {
        this.set(dataType, (BValue)v, null);
    }

    public void addPresetRegisterValue(BModbusClientPresetRegister param) {
        this.invoke(addPresetRegisterValue, (BValue)param, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void writePresetValues() {
        byte[] dataOut;
        ByteArrayOutputStream oStream = new ByteArrayOutputStream();
        int address = this.getDevice().getDeviceAddress();
        int baseAddress = this.getAbsoluteStartingAddress().getDataAddress();
        boolean isPresetMultiple = this.getDevice().isPresetMultiple();
        BModbusClientPresetRegister[] kids = (BModbusClientPresetRegister[])this.getChildren(BModbusClientPresetRegister.class);
        if (kids == null || kids.length <= 0) {
            return;
        }
        for (int i = 0; i < kids.length; ++i) {
            BModbusClientPresetRegister kid = kids[i];
            float fValue = kid.getValue();
            dataOut = this.isDataTypeInteger() ? this.setIntegerByteArray(fValue) : (this.isDataTypeLong() ? this.setLongByteArray(fValue) : this.setFloatByteArray(fValue));
            if (!isPresetMultiple) {
                int count = 1;
                int pointAddress = baseAddress + i;
                if (this.isDataTypeLong() || this.isDataTypeFloat()) {
                    count *= 2;
                    pointAddress = baseAddress + i * 2;
                }
                int code = 6;
                ModbusWriteRequest req = new ModbusWriteRequest(this.getNetwork().getModbusMode(), this.getDevice(), address, code, pointAddress, 1, dataOut);
                if (count > 1) {
                    this.getNetwork().postWrite(new ModbusWriteFloatRequest(kid, req, dataOut, i == kids.length - 1));
                    continue;
                }
                kid.setLastChild(i == kids.length - 1);
                this.getNetwork().postWrite(new BModbusClientPresetComponent.ModbusClientWriteRequest(this, req, kid));
                continue;
            }
            try {
                oStream.write(dataOut);
                continue;
            }
            catch (IOException count) {
                // empty catch block
            }
        }
        if (isPresetMultiple) {
            int count = kids.length;
            int pointAddress = baseAddress;
            if (this.isDataTypeLong() || this.isDataTypeFloat()) {
                count *= 2;
            }
            int code = 16;
            dataOut = oStream.toByteArray();
            ModbusWriteRequest req = new ModbusWriteRequest(this.getNetwork().getModbusMode(), this.getDevice(), address, code, pointAddress, count, dataOut);
            this.getNetwork().postWrite(new BModbusClientPresetComponent.ModbusClientWriteRequest(this, req, this));
        }
    }

    @Override
    protected Property getBaseAddressProperty() {
        return BModbusClientDevice.holdingRegisterBaseAddress;
    }

    @Override
    protected boolean isValidAddress(BFlexAddress address) {
        if (!address.isModbusFormat()) {
            return address.isValid();
        }
        if (address.isModbusAnalogAddress()) {
            return address.isModbusHoldingAddress();
        }
        return false;
    }

    public void doAddPresetRegisterValue(BModbusClientPresetRegister param) {
        this.add(null, (BValue)param);
        BComponentSpace space = this.getComponentSpace();
        if (space != null) {
            space.update((BComponent)this, 0);
        }
    }

    public void processMessage(Message response) {
        int exceptionCode = 0;
        exceptionCode = response == null ? 9 : ((ModbusResponse)response).exceptionCode;
        this.setStatusFault(exceptionCode != 0 && exceptionCode != -2 && exceptionCode != 5);
        BCommStatus tmp = new BCommStatus(exceptionCode);
        BAbsTime timestamp = Clock.time();
        SlotCursor c = this.getProperties();
        while (c.next(BModbusClientPresetRegister.class)) {
            BModbusClientPresetRegister kid = (BModbusClientPresetRegister)c.get();
            kid.getWriteStatus().setErrorCode(tmp.getErrorCode());
            kid.getWriteStatus().setErrorDescription(tmp.getErrorDescription());
            if (exceptionCode != 0 && exceptionCode != 5) {
                kid.setLastFailedWrite(timestamp);
                continue;
            }
            kid.setLastSuccessfulWrite(timestamp);
        }
        if (exceptionCode == 0 || exceptionCode == 5) {
            this.fireWriteSuccessful(null);
            if (this.getNetwork().getModbusLog().isTraceOn()) {
                this.getNetwork().getModbusLog().trace(this.getName() + " write successful.");
            }
        } else if (this.getNetwork().getModbusLog().isTraceOn()) {
            this.getNetwork().getModbusLog().trace(this.getName() + " write unsuccessful.");
        }
    }

    public void computeStatus(boolean fireSuccessful) {
        SlotCursor c = this.getProperties();
        while (c.next(BModbusClientPresetRegister.class)) {
            BModbusClientPresetRegister kid = (BModbusClientPresetRegister)c.get();
            int errorCode = kid.getWriteStatus().getErrorCode();
            if (errorCode == 0 || errorCode == -2 || errorCode == 5) continue;
            this.setStatusFault(true);
            if (fireSuccessful && this.getNetwork().getModbusLog().isTraceOn()) {
                this.getNetwork().getModbusLog().trace(this.getName() + " write unsuccessful.");
            }
            return;
        }
        this.setStatusFault(false);
        if (fireSuccessful) {
            this.fireWriteSuccessful(null);
            if (this.getNetwork().getModbusLog().isTraceOn()) {
                this.getNetwork().getModbusLog().trace(this.getName() + " write successful.");
            }
        }
    }

    private boolean isDataTypeInteger() {
        if (this.getDataType().equals((Object)BDataTypeEnum.integerType)) {
            return true;
        }
        return this.getDataType().equals((Object)BDataTypeEnum.signedInteger);
    }

    private boolean isDataTypeLong() {
        return this.getDataType().equals((Object)BDataTypeEnum.longType);
    }

    private boolean isDataTypeFloat() {
        return this.getDataType().equals((Object)BDataTypeEnum.floatType);
    }

    private boolean isDataTypeSigned() {
        if (this.getDataType().equals((Object)BDataTypeEnum.signedInteger)) {
            return true;
        }
        return this.getDataType().equals((Object)BDataTypeEnum.longType);
    }

    private byte[] setIntegerByteArray(float fValue) {
        byte[] ba = new byte[2];
        fValue = fValue >= 0.0f ? (float)((double)fValue + 0.5) : (float)((double)fValue - 0.5);
        float maxValue = 65535.0f;
        float minValue = 0.0f;
        if (this.isDataTypeSigned()) {
            maxValue = 32767.0f;
            minValue = -32768.0f;
        }
        if (fValue > maxValue) {
            fValue = maxValue;
        } else if (fValue < minValue) {
            fValue = minValue;
        }
        int intValue = (int)fValue;
        ba[0] = (byte)((intValue & 0xFF00) >> 8);
        ba[1] = (byte)(intValue & 0xFF);
        return ba;
    }

    private byte[] setLongByteArray(float fValue) {
        byte[] ba = new byte[4];
        fValue = fValue >= 0.0f ? (float)((double)fValue + 0.5) : (float)((double)fValue - 0.5);
        float maxValue = 2.1474836E9f;
        float minValue = -2.1474836E9f;
        if (fValue > maxValue) {
            fValue = maxValue;
        } else if (fValue < minValue) {
            fValue = minValue;
        }
        int intValue = (int)fValue;
        if (this.getDevice().isFloat3210Order()) {
            ba[0] = (byte)((intValue & 0xFF000000) >> 24);
            ba[1] = (byte)((intValue & 0xFF0000) >> 16);
            ba[2] = (byte)((intValue & 0xFF00) >> 8);
            ba[3] = (byte)(intValue & 0xFF);
        } else {
            ba[0] = (byte)((intValue & 0xFF00) >> 8);
            ba[1] = (byte)(intValue & 0xFF);
            ba[2] = (byte)((intValue & 0xFF000000) >> 24);
            ba[3] = (byte)((intValue & 0xFF0000) >> 16);
        }
        return ba;
    }

    private byte[] setFloatByteArray(float fValue) {
        byte[] ba = new byte[4];
        int floatBits = Float.floatToIntBits(fValue);
        if (this.getDevice().isFloat3210Order()) {
            ba[0] = (byte)((floatBits & 0xFF000000) >> 24);
            ba[1] = (byte)((floatBits & 0xFF0000) >> 16);
            ba[2] = (byte)((floatBits & 0xFF00) >> 8);
            ba[3] = (byte)(floatBits & 0xFF);
        } else {
            ba[0] = (byte)((floatBits & 0xFF00) >> 8);
            ba[1] = (byte)(floatBits & 0xFF);
            ba[2] = (byte)((floatBits & 0xFF000000) >> 24);
            ba[3] = (byte)((floatBits & 0xFF0000) >> 16);
        }
        return ba;
    }

    private class ModbusWriteFloatRequest
    implements Runnable,
    ICoalesceable {
        private int hashCode;
        private BModbusClientPresetRegister source;
        private ModbusWriteRequest req;
        private byte[] dataOut;
        private boolean lastChild;

        public ModbusWriteFloatRequest(BModbusClientPresetRegister source, ModbusWriteRequest req, byte[] dataOut, boolean lastChild) {
            this.hashCode = source.hashCode();
            this.source = source;
            this.req = req;
            this.dataOut = dataOut;
            this.lastChild = lastChild;
        }

        @Override
        public void run() {
            this.source.setLastChild(false);
            this.source.processMessage(BModbusClientPresetRegisters.this.getDevice().sendModbusMessage(this.req));
            if (this.source.getWriteStatus().getErrorCode() != 0 && this.source.getWriteStatus().getErrorCode() != 5) {
                return;
            }
            this.dataOut[0] = this.dataOut[2];
            this.dataOut[1] = this.dataOut[3];
            ++this.req.startAddress;
            this.req.data = this.dataOut;
            this.source.setLastChild(this.lastChild);
            this.source.processMessage(BModbusClientPresetRegisters.this.getDevice().sendModbusMessage(this.req));
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (object instanceof ModbusWriteFloatRequest) {
                ModbusWriteFloatRequest o = (ModbusWriteFloatRequest)object;
                return this.source == o.source;
            }
            return false;
        }

        public Object getCoalesceKey() {
            return this;
        }

        public ICoalesceable coalesce(ICoalesceable c) {
            return c;
        }
    }
}

