/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.client.datatypes;

import com.tridium.basicdriver.MessageListener;
import com.tridium.modbusCore.client.BModbusClientDevice;
import com.tridium.modbusCore.client.BModbusClientNetwork;
import com.tridium.modbusCore.datatypes.BFlexAddress;
import com.tridium.modbusCore.messages.ModbusWriteRequest;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public abstract class BModbusClientPresetComponent
extends BComponent {
    public static final Property startingAddress = BModbusClientPresetComponent.newProperty((int)0, (BValue)new BFlexAddress(), null);
    public static final Property absoluteStartingAddress = BModbusClientPresetComponent.newProperty((int)3, (BValue)new BFlexAddress(), null);
    public static final Property status = BModbusClientPresetComponent.newProperty((int)67, (BValue)BStatus.down, null);
    public static final Property writeOnInputChange = BModbusClientPresetComponent.newProperty((int)0, (boolean)false, null);
    public static final Action write = BModbusClientPresetComponent.newAction((int)24, null);
    public static final Topic writeSuccessful = BModbusClientPresetComponent.newTopic((int)8, null);
    public static final Type TYPE = Sys.loadType(BModbusClientPresetComponent.class);
    private Subscriber subscriber;

    public BFlexAddress getStartingAddress() {
        return (BFlexAddress)this.get(startingAddress);
    }

    public void setStartingAddress(BFlexAddress v) {
        this.set(startingAddress, (BValue)v, null);
    }

    public BFlexAddress getAbsoluteStartingAddress() {
        return (BFlexAddress)this.get(absoluteStartingAddress);
    }

    public void setAbsoluteStartingAddress(BFlexAddress v) {
        this.set(absoluteStartingAddress, (BValue)v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public boolean getWriteOnInputChange() {
        return this.getBoolean(writeOnInputChange);
    }

    public void setWriteOnInputChange(boolean v) {
        this.setBoolean(writeOnInputChange, v, null);
    }

    public void write() {
        this.invoke(write, null, null);
    }

    public void fireWriteSuccessful(BValue event) {
        this.fire(writeSuccessful, event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.subscriber = new BaseAddressSubscriber();
        BModbusClientDevice device = this.getDevice();
        if (device == null) {
            return;
        }
        this.subscriber.subscribe((BComponent)device);
        this.setCurrentAbsoluteAddress();
    }

    public void stopped() throws Exception {
        this.subscriber.unsubscribeAll();
        this.subscriber = null;
        super.stopped();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(startingAddress) && this.getDevice() != null && context != Context.commit) {
            this.setCurrentAbsoluteAddress();
        }
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        if (action.equals(write)) {
            return this.getNetwork().postAsync((Runnable)new Invocation((BComponent)this, action, arg, cx));
        }
        return super.post(action, arg, cx);
    }

    private void setCurrentAbsoluteAddress() {
        if (!this.isValidAddress(this.getStartingAddress())) {
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)4, (boolean)true));
            this.getNetwork().getModbusLog().error("Illegal Modbus address for preset component " + this.getName() + ": Modbus Address does not match preset type.");
            return;
        }
        this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)4, (boolean)this.getDevice().isDown()));
        int baseAddr = 0;
        try {
            baseAddr = ((BFlexAddress)this.getDevice().get(this.getBaseAddressProperty())).getDataAddress();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (NumberFormatException e) {
            baseAddr = 0;
        }
        try {
            BFlexAddress absAddr = (BFlexAddress)this.getStartingAddress().newCopy();
            int rawAddress = absAddr.isModbusFormat() ? Integer.valueOf(absAddr.getAddress()).intValue() : absAddr.getDataAddress();
            absAddr.setAddressFromInt(rawAddress + baseAddr);
            this.setAbsoluteStartingAddress(absAddr);
        }
        catch (NullPointerException absAddr) {
        }
        catch (NumberFormatException e) {
            BFlexAddress absAddr = (BFlexAddress)this.getStartingAddress().newCopy();
            absAddr.setAddressFromInt(baseAddr);
            this.setAbsoluteStartingAddress(absAddr);
        }
    }

    public void doWrite() {
        if (this.isDown() || this.isDisabled()) {
            return;
        }
        this.writePresetValues();
    }

    protected abstract void writePresetValues();

    protected abstract Property getBaseAddressProperty();

    protected abstract boolean isValidAddress(BFlexAddress var1);

    public void setStatusFault(boolean x) {
        this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)2, (boolean)x));
    }

    public boolean isDown() {
        return this.getStatus().isDown();
    }

    public boolean isDisabled() {
        return this.getStatus().isDisabled();
    }

    public BModbusClientDevice getDevice() {
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BModbusClientDevice)) continue;
            if (this.isDisabled()) {
                this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)1, (boolean)((BModbusClientDevice)parent).isDisabled()));
                if (!this.subscriber.isSubscribed((BComponent)parent)) {
                    this.subscriber.subscribe((BComponent)parent);
                }
            }
            return (BModbusClientDevice)parent;
        }
        if (!this.isDisabled()) {
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)1, (boolean)true));
        }
        return null;
    }

    public BModbusClientNetwork getNetwork() {
        BModbusClientDevice device = this.getDevice();
        if (device == null) {
            return null;
        }
        return (BModbusClientNetwork)device.modbusNet();
    }

    protected class ModbusClientWriteRequest
    implements Runnable {
        private MessageListener source;
        private ModbusWriteRequest req;

        public ModbusClientWriteRequest(ModbusWriteRequest req, MessageListener source) {
            this.source = source;
            this.req = req;
        }

        @Override
        public void run() {
            this.source.processMessage(BModbusClientPresetComponent.this.getDevice().sendModbusMessage(this.req));
        }
    }

    private class BaseAddressSubscriber
    extends Subscriber {
        public void event(BComponentEvent event) {
            if (event.getId() == 0) {
                if (event.getSlot().equals((Object)BModbusClientPresetComponent.this.getBaseAddressProperty())) {
                    BModbusClientPresetComponent.this.setCurrentAbsoluteAddress();
                } else if (event.getSlot().equals((Object)BModbusClientDevice.status)) {
                    if (BModbusClientPresetComponent.this.getDevice().isDown()) {
                        BModbusClientPresetComponent.this.setStatus(BStatus.make((BStatus)BModbusClientPresetComponent.this.getStatus(), (int)4, (boolean)true));
                    } else {
                        BModbusClientPresetComponent.this.setStatus(BStatus.make((BStatus)BModbusClientPresetComponent.this.getStatus(), (int)4, (!BModbusClientPresetComponent.this.isValidAddress(BModbusClientPresetComponent.this.getStartingAddress()) ? 1 : 0) != 0));
                    }
                    BModbusClientPresetComponent.this.setStatus(BStatus.make((BStatus)BModbusClientPresetComponent.this.getStatus(), (int)1, (boolean)BModbusClientPresetComponent.this.getDevice().isDisabled()));
                }
            }
        }
    }
}

